/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.junit.Test;

public class CurvedLabelTest
extends RendererBaseTest {
    @Test
    public void testCurvedLabelsMultiLine() throws Exception {
        RendererBaseTest.setupVeraFonts();
        File property = new File(TestData.getResource((Object)this, (String)"curvedLabelsMultiLine.properties").toURI());
        PropertyDataStore dataStore = new PropertyDataStore(property.getParentFile());
        ContentFeatureSource featureSource = dataStore.getFeatureSource("curvedLabelsMultiLine");
        ReferencedEnvelope bounds = featureSource.getBounds();
        bounds.expandBy(1.0, 1.0);
        Style style = RendererBaseTest.loadStyle(this, "labelStyle.sld");
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)new FeatureLayer((FeatureSource)featureSource, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mapContent);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = new BufferedImage(200, 400, 5);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        renderer.paint(graphics, new Rectangle(0, 0, image.getWidth(), image.getHeight()), bounds);
        mapContent.dispose();
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/curvedLabelsMultiLine.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)1000);
    }
}

