/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.style.Style;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;

public class CompositeLayeringTest {
    SimpleFeatureSource fs;
    SimpleFeatureSource bfs;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("square");
        this.bfs = ds.getFeatureSource("bigsquare");
        this.bounds = this.fs.getBounds();
        this.bounds.expandBy(0.2, 0.2);
    }

    @Test
    public void testInternalBuffer() throws Exception {
        this.runSingleLayerTest("compositeInternalBuffer.sld");
    }

    private void runSingleLayerTest(String styleName) throws Exception {
        this.runSingleLayerTest(styleName, 100);
    }

    private void runSingleLayerTest(String styleName, int threshold) throws Exception {
        Style style = RendererBaseTest.loadStyle(this, styleName);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = new BufferedImage(256, 256, 5);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        renderer.paint(graphics, new Rectangle(0, 0, image.getWidth(), image.getHeight()), this.bounds);
        mc.dispose();
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/" + styleName + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)threshold);
    }
}

