/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.test.TestData;
import org.geotools.xml.styling.SLDParser;
import org.junit.Before;

public abstract class AbstractLabelLineTest {
    protected ReferencedEnvelope bounds;
    protected ContentFeatureSource featureSource;

    @Before
    public void setUp() throws Exception {
        RendererBaseTest.setupVeraFonts();
        File property = new File(TestData.getResource((Object)this, (String)"nonStraightLines.properties").toURI());
        PropertyDataStore dataStore = new PropertyDataStore(property.getParentFile());
        this.featureSource = dataStore.getFeatureSource("nonStraightLines");
        this.bounds = this.featureSource.getBounds();
        this.bounds.expandBy(1.0, 1.0);
    }

    protected Style loadParametricStyle(Object loader, String sldFilename, String ... parameters) throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL url = TestData.getResource((Object)loader, (String)sldFilename);
        String styleTemplate = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        for (int i = 0; i < parameters.length; i += 2) {
            String key = parameters[i];
            String value = parameters[i + 1];
            styleTemplate = styleTemplate.replace("%" + key + "%", value);
        }
        SLDParser stylereader = new SLDParser(factory, (Reader)new StringReader(styleTemplate));
        Style style = stylereader.readXML()[0];
        return style;
    }

    protected BufferedImage renderNonStraightLines(SimpleFeatureSource featureSource, Style style, int width, int height, ReferencedEnvelope bounds) {
        MapContent mapContent = new MapContent();
        mapContent.addLayer((Layer)new FeatureLayer((FeatureSource)featureSource, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mapContent);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = new BufferedImage(width, height, 5);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        renderer.paint(graphics, new Rectangle(0, 0, image.getWidth(), image.getHeight()), bounds);
        mapContent.dispose();
        return image;
    }
}

