/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.Font;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelIndex;
import org.geotools.renderer.label.LabelPainter;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.styling.StyleBuilder;
import org.geotools.test.TestGraphics;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class LabelCacheImplTest {
    private static final Geometry L4 = LabelCacheImplTest.geometry("POLYGON((0 0, 0 0.1, 0.1 0.1, 0.1 0, 0 0))");
    private static final Geometry L3 = LabelCacheImplTest.geometry("LINESTRING(20 20, 30 30)");
    private static final Geometry L2 = LabelCacheImplTest.geometry("LINESTRING(10 10, 20 20)");
    private static final Geometry L1 = LabelCacheImplTest.geometry("LINESTRING(0 0, 10 10)");
    private static final String LAYER_ID = "layerId";
    SimpleFeatureType schema;
    SimpleFeatureBuilder fb;
    LabelCacheImpl cache;
    StyleBuilder sb;
    NumberRange<Double> ALL_SCALES = new NumberRange(Double.class, (Number)Double.NEGATIVE_INFINITY, (Number)Double.POSITIVE_INFINITY);

    @Before
    public void setupSchema() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test");
        tb.add("name", String.class);
        tb.add("geom", Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.schema = tb.buildFeatureType();
        this.fb = new SimpleFeatureBuilder(this.schema);
        this.cache = new LabelCacheImpl();
        this.cache.startLayer(LAYER_ID);
        this.sb = new StyleBuilder();
    }

    @Before
    public void setVeraFont() throws IOException, FontFormatException {
        RendererBaseTest.setupVeraFonts();
    }

    @Test
    public void testSimpleGrouping() throws Exception {
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        ts.getOptions().put("group", "true");
        SimpleFeature f1 = this.createFeature("label1", L1);
        SimpleFeature f2 = this.createFeature("label1", L2);
        this.addToCache(this.cache, ts, f1);
        this.addToCache(this.cache, ts, f2);
        List labels = this.cache.getActiveLabels();
        Assert.assertEquals((long)1L, (long)labels.size());
        LabelCacheItem item = (LabelCacheItem)labels.get(0);
        Assert.assertEquals((Object)"label1", (Object)item.getLabel());
        Assert.assertEquals((long)2L, (long)item.getGeoms().size());
    }

    @Test
    public void testGroupDifferentSymbolizers() throws Exception {
        TextSymbolizer ts1 = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        ts1.getOptions().put("group", "true");
        TextSymbolizer ts2 = this.sb.createTextSymbolizer(Color.YELLOW, (Font)null, "name");
        ts2.getOptions().put("group", "true");
        SimpleFeature f1 = this.createFeature("label1", L1);
        SimpleFeature f2 = this.createFeature("label1", L2);
        this.addToCache(this.cache, ts1, f1);
        this.addToCache(this.cache, ts2, f2);
        List labels = this.cache.getActiveLabels();
        Assert.assertEquals((long)2L, (long)labels.size());
    }

    @Test
    public void testMinNonGrouped() throws Exception {
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        TextSymbolizer tsGroup = this.sb.createTextSymbolizer(Color.YELLOW, (Font)null, "name");
        tsGroup.getOptions().put("group", "true");
        SimpleFeature f1 = this.createFeature("label1", L1);
        SimpleFeature f2 = this.createFeature("label1", L2);
        SimpleFeature f3 = this.createFeature("label1", L3);
        this.addToCache(this.cache, tsGroup, f1);
        this.addToCache(this.cache, ts, f2);
        this.addToCache(this.cache, tsGroup, f3);
        List labels = this.cache.getActiveLabels();
        Assert.assertEquals((long)2L, (long)labels.size());
        LabelCacheItem item1 = (LabelCacheItem)labels.get(0);
        Assert.assertEquals((Object)"label1", (Object)item1.getLabel());
        Assert.assertEquals(Arrays.asList(L1, L3), (Object)item1.getGeoms());
        LabelCacheItem item2 = (LabelCacheItem)labels.get(1);
        Assert.assertEquals((Object)"label1", (Object)item2.getLabel());
        Assert.assertEquals(Collections.singletonList(L2), (Object)item2.getGeoms());
    }

    @Test
    public void testCustomBehaviour() throws TransformException, FactoryException {
        final ArrayList labels = new ArrayList();
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        LabelCacheImpl myCache = new LabelCacheImpl(){

            int paintLabel(Graphics2D graphics, Rectangle displayArea, LabelIndex glyphs, int paintedLineLabels, LabelPainter painter, LabelCacheItem labelItem) {
                labels.add(labelItem.getLabel());
                return super.paintLabel(graphics, displayArea, glyphs, paintedLineLabels, painter, labelItem);
            }
        };
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        SimpleFeature f1 = this.createFeature("label1", L1);
        myCache.enableLayer(LAYER_ID);
        this.addToCache(myCache, ts, f1);
        myCache.endLayer(LAYER_ID, graphics, new Rectangle(0, 0, 256, 256));
        myCache.end(graphics, new Rectangle(0, 0, 256, 256));
        Assert.assertEquals((long)1L, (long)labels.size());
    }

    @Test
    public void testRendererListener() throws Exception {
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        RenderListener listener = new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                exception.set(e);
            }
        };
        this.cache.addRenderListener(listener);
        SimpleFeature f1 = this.createFeature("label1", L1);
        this.addToCache(this.cache, ts, f1);
        this.cache.endLayer(LAYER_ID, null, null);
        TestGraphics testGraphics = new TestGraphics();
        testGraphics.setRenderingHints(Collections.emptyMap());
        this.cache.end((Graphics2D)testGraphics, new Rectangle(0, 0, 10, 10));
        Assert.assertNotNull(exception.get());
    }

    @Test
    public void testUsesCustomLabelPainter() throws Exception {
        LabelPainter painter = (LabelPainter)Mockito.mock(LabelPainter.class);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        this.cache.setConstructPainter((x, y) -> painter);
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "name");
        SimpleFeature f1 = this.createFeature("label1", L1);
        this.addToCache(this.cache, ts, f1);
        this.cache.endLayer(LAYER_ID, graphics, new Rectangle(0, 0, 256, 256));
        this.cache.end(graphics, new Rectangle(0, 0, 256, 256));
        ((LabelPainter)Mockito.verify((Object)painter)).setLabel((LabelCacheItem)Mockito.any(LabelCacheItem.class));
        ((LabelPainter)Mockito.verify((Object)painter, (VerificationMode)Mockito.atLeastOnce())).getLabel();
    }

    @Test
    public void testDecimateSmallRing() throws Exception {
        Font font = this.sb.createFont("Bitstream Vera Sans", 12.0);
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, font, "name");
        ts.getOptions().put("followLine", "true");
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        RenderListener listener = new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                exception.set(e);
            }
        };
        this.cache.addRenderListener(listener);
        SimpleFeature f1 = this.createFeature("label1", L4);
        this.addToCache(this.cache, ts, f1);
        this.cache.endLayer(LAYER_ID, null, null);
        BufferedImage bi = new BufferedImage(10, 10, 6);
        Graphics2D graphics = bi.createGraphics();
        this.cache.end(graphics, new Rectangle(0, 0, 10, 10));
        Assert.assertNull(exception.get());
    }

    @Test
    public void testFollowLineAutoWrap() throws Exception {
        Font font = this.sb.createFont("Bitstream Vera Sans", 12.0);
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, font, "name");
        ts.getOptions().put("autoWrap", "10");
        ts.getOptions().put("followLine", "true");
        SimpleFeature f1 = this.createFeature("label1", L4);
        this.addToCache(this.cache, ts, f1);
        List items = this.cache.getActiveLabels();
        LabelCacheItem item = (LabelCacheItem)items.get(0);
        Assert.assertTrue((boolean)item.isFollowLineEnabled());
        Assert.assertEquals((long)0L, (long)item.getAutoWrap());
    }

    private SimpleFeature createFeature(String label, Geometry geom) {
        this.fb.add((Object)label);
        this.fb.add((Object)geom);
        return this.fb.buildFeature(null);
    }

    private static Geometry geometry(String wkt) {
        try {
            return new WKTReader().read(wkt);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testSymbolizerCaching() throws Exception {
        Font font = this.sb.createFont("Bitstream Vera Sans", 12.0);
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, font, "name");
        SimpleFeature f1 = this.createFeature("label1", L4);
        this.addToCache(this.cache, ts, f1);
        SimpleFeature f2 = this.createFeature("label2", L4);
        this.addToCache(this.cache, ts, f2);
        List items = this.cache.getActiveLabels();
        Assert.assertEquals((long)2L, (long)items.size());
        Assert.assertEquals((Object)"label1", (Object)((LabelCacheItem)items.get(0)).getLabel());
        Assert.assertEquals((Object)"label2", (Object)((LabelCacheItem)items.get(1)).getLabel());
        Assert.assertSame((Object)((LabelCacheItem)items.get(0)).getTextStyle(), (Object)((LabelCacheItem)items.get(1)).getTextStyle());
    }

    private void addToCache(LabelCacheImpl cache, TextSymbolizer ts, SimpleFeature f1) throws TransformException, FactoryException {
        cache.put(LAYER_ID, ts, (Feature)f1, new LiteShape2((Geometry)f1.getDefaultGeometry(), null, null, false), this.ALL_SCALES);
    }
}

