/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.composite;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.renderer.composite.CompositeTest;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.StyleBuilder;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@RunWith(value=Parameterized.class)
public class StreamingRendererCompositeTest {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static GridCoverage2D BKG;
    private static GridCoverage2D BKG2;
    private static GridCoverage2D MAP;
    private static GridCoverage2D MAP2;
    private String composite;

    public StreamingRendererCompositeTest(String composite) {
        this.composite = composite;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        result.add(new Object[]{"copy"});
        result.add(new Object[]{"destination"});
        result.add(new Object[]{"source-over"});
        result.add(new Object[]{"destination-over"});
        result.add(new Object[]{"source-in"});
        result.add(new Object[]{"destination-in"});
        result.add(new Object[]{"source-out"});
        result.add(new Object[]{"destination-out"});
        result.add(new Object[]{"source-atop"});
        result.add(new Object[]{"destination-atop"});
        result.add(new Object[]{"xor"});
        result.add(new Object[]{"multiply"});
        result.add(new Object[]{"screen"});
        result.add(new Object[]{"overlay"});
        result.add(new Object[]{"darken"});
        result.add(new Object[]{"lighten"});
        result.add(new Object[]{"color-dodge"});
        result.add(new Object[]{"color-burn"});
        result.add(new Object[]{"hard-light"});
        result.add(new Object[]{"soft-light"});
        result.add(new Object[]{"difference"});
        result.add(new Object[]{"exclusion"});
        return result;
    }

    @BeforeClass
    public static void prepareData() throws Exception {
        BKG = StreamingRendererCompositeTest.readCoverage("bkg.png");
        BKG2 = StreamingRendererCompositeTest.readCoverage("bkg2.png");
        MAP = StreamingRendererCompositeTest.readCoverage("map.png");
        MAP2 = StreamingRendererCompositeTest.readCoverage("map2.png");
    }

    private static GridCoverage2D readCoverage(String imageFileName) throws Exception {
        BufferedImage bi = ImageIO.read(CompositeTest.class.getResourceAsStream("test-data/" + imageFileName));
        GridCoverageFactory factory = new GridCoverageFactory();
        ReferencedEnvelope envelope = ReferencedEnvelope.rect((double)0.0, (double)0.0, (double)bi.getWidth(), (double)bi.getHeight(), (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
        return factory.create((CharSequence)imageFileName, (RenderedImage)bi, (Bounds)envelope);
    }

    @Test
    public void testCompositeFts1() throws Exception {
        BufferedImage blended = this.composeFts(BKG, MAP);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend1-" + this.composite + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)0);
    }

    @Test
    public void testCompositeFts2() throws Exception {
        BufferedImage blended = this.composeFts(BKG2, MAP2);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend2-" + this.composite + ".png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)0);
    }

    @Test
    public void testCompositeExternalGraphicPoint1() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("pointBlend.sld");
        BufferedImage blended = this.composePoint(BKG, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend1-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeExternalGraphicPoint2() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("pointBlend2.sld");
        BufferedImage blended = this.composePoint(BKG2, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend2-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeRedMark() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("redMarkBlend.sld");
        BufferedImage blended = this.composePoint(BKG2, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/bkg2-red-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeRedStrokeLine() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("redLineBlend.sld");
        BufferedImage blended = this.composeLine(BKG2, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/bkg2-red-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeRedGraphicStrokeLine() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("redLineGraphicStrokeBlend.sld");
        BufferedImage blended = this.composeLine(BKG2, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/bkg2-red-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeExternalGraphicLine1() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("lineBlend.sld");
        BufferedImage blended = this.composeLine(BKG, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend1-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeExternalGraphicLine2() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("lineBlend2.sld");
        BufferedImage blended = this.composeLine(BKG2, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend2-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeRedFill() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("redFillBlend.sld");
        BufferedImage blended = this.composePolygon(BKG2, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/bkg2-red-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeGraphicFill() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("fillBlend.sld");
        BufferedImage blended = this.composePolygon(BKG, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend1-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    @Test
    public void testCompositeGraphicFill2() throws Exception {
        Style style = this.applyCompositeOnFirstSymbolizer("fillBlend2.sld");
        BufferedImage blended = this.composePolygon(BKG2, style);
        File reference = new File("./src/test/resources/org/geotools/renderer/composite/test-data/blend2-" + this.composite + ".png");
        int threshold = 50;
        if ("copy".equals(this.composite)) {
            threshold = 200;
        }
        ImageAssert.assertEquals((File)reference, (RenderedImage)blended, (int)threshold);
    }

    private BufferedImage composeFts(GridCoverage2D first, GridCoverage2D second) {
        MapContent mc = new MapContent();
        StyleBuilder sb = new StyleBuilder();
        Style baseStyle = sb.createStyle((Symbolizer)sb.createRasterSymbolizer());
        mc.addLayer((Layer)new GridCoverageLayer(first, baseStyle));
        FeatureTypeStyle compositeFts = sb.createFeatureTypeStyle((Symbolizer)sb.createRasterSymbolizer());
        compositeFts.getOptions().put("composite", this.composite);
        Style compositeStyle = sb.createStyle();
        compositeStyle.featureTypeStyles().add(compositeFts);
        mc.addLayer((Layer)new GridCoverageLayer(second, compositeStyle));
        RenderedImage referenceImage = first.getRenderedImage();
        BufferedImage blended = new BufferedImage(referenceImage.getWidth(), referenceImage.getWidth(), 6);
        Graphics2D graphics = blended.createGraphics();
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        sr.paint(graphics, new Rectangle(0, 0, referenceImage.getWidth(), referenceImage.getHeight()), ReferencedEnvelope.reference((Bounds)first.getEnvelope()));
        graphics.dispose();
        mc.dispose();
        return blended;
    }

    private BufferedImage composePoint(GridCoverage2D first, Style pointStyle) throws SchemaException, IOException {
        MapContent mc = new MapContent();
        StyleBuilder sb = new StyleBuilder();
        Style baseStyle = sb.createStyle((Symbolizer)sb.createRasterSymbolizer());
        mc.addLayer((Layer)new GridCoverageLayer(first, baseStyle));
        RenderedImage referenceImage = first.getRenderedImage();
        Point midPoint = new Point((CoordinateSequence)new LiteCoordinateSequence(new double[]{(double)referenceImage.getWidth() / 2.0, (double)referenceImage.getHeight() / 2.0}), GEOMETRY_FACTORY);
        SimpleFeatureType ft = DataUtilities.createType((String)"test", (String)"geom:Point:srid=4326");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        fb.add((Object)midPoint);
        SimpleFeature pointFeature = fb.buildFeature(null);
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature)pointFeature);
        mc.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, pointStyle));
        BufferedImage blended = new BufferedImage(referenceImage.getWidth(), referenceImage.getWidth(), 6);
        Graphics2D graphics = blended.createGraphics();
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        sr.paint(graphics, new Rectangle(0, 0, referenceImage.getWidth(), referenceImage.getHeight()), ReferencedEnvelope.reference((Bounds)first.getEnvelope()));
        graphics.dispose();
        mc.dispose();
        return blended;
    }

    private BufferedImage composeLine(GridCoverage2D first, Style lineStyle) throws SchemaException, IOException {
        MapContent mc = new MapContent();
        StyleBuilder sb = new StyleBuilder();
        Style baseStyle = sb.createStyle((Symbolizer)sb.createRasterSymbolizer());
        mc.addLayer((Layer)new GridCoverageLayer(first, baseStyle));
        RenderedImage referenceImage = first.getRenderedImage();
        LineString midLine = new LineString((CoordinateSequence)new LiteCoordinateSequence(new double[]{0.0, (double)referenceImage.getHeight() / 2.0, referenceImage.getWidth(), (double)referenceImage.getHeight() / 2.0}), GEOMETRY_FACTORY);
        SimpleFeatureType ft = DataUtilities.createType((String)"test", (String)"geom:LineString:srid=4326");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        fb.add((Object)midLine);
        SimpleFeature pointFeature = fb.buildFeature(null);
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature)pointFeature);
        mc.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, lineStyle));
        BufferedImage blended = new BufferedImage(referenceImage.getWidth(), referenceImage.getWidth(), 6);
        Graphics2D graphics = blended.createGraphics();
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        sr.paint(graphics, new Rectangle(0, 0, referenceImage.getWidth(), referenceImage.getHeight()), ReferencedEnvelope.reference((Bounds)first.getEnvelope()));
        graphics.dispose();
        mc.dispose();
        return blended;
    }

    private BufferedImage composePolygon(GridCoverage2D first, Style polygonStyle) throws SchemaException, IOException {
        MapContent mc = new MapContent();
        StyleBuilder sb = new StyleBuilder();
        Style baseStyle = sb.createStyle((Symbolizer)sb.createRasterSymbolizer());
        mc.addLayer((Layer)new GridCoverageLayer(first, baseStyle));
        RenderedImage referenceImage = first.getRenderedImage();
        int w = referenceImage.getWidth();
        int h = referenceImage.getHeight();
        LinearRing shell = new LinearRing((CoordinateSequence)new LiteCoordinateSequence(new double[]{0.0, 0.0, 0.0, h, w, h, w, 0.0, 0.0, 0.0}), GEOMETRY_FACTORY);
        Polygon polygon = new Polygon(shell, null, GEOMETRY_FACTORY);
        SimpleFeatureType ft = DataUtilities.createType((String)"test", (String)"geom:Polygon:srid=4326");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        fb.add((Object)polygon);
        SimpleFeature pointFeature = fb.buildFeature(null);
        SimpleFeatureCollection collection = DataUtilities.collection((SimpleFeature)pointFeature);
        mc.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, polygonStyle));
        BufferedImage blended = new BufferedImage(referenceImage.getWidth(), referenceImage.getWidth(), 6);
        Graphics2D graphics = blended.createGraphics();
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        sr.paint(graphics, new Rectangle(0, 0, referenceImage.getWidth(), referenceImage.getHeight()), ReferencedEnvelope.reference((Bounds)first.getEnvelope()));
        graphics.dispose();
        mc.dispose();
        return blended;
    }

    private Style applyCompositeOnFirstSymbolizer(String styleName) throws IOException {
        Style style = RendererBaseTest.loadStyle(StreamingRendererCompositeTest.class, styleName);
        Symbolizer symbolizer = (Symbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        symbolizer.getOptions().put("composite", this.composite);
        return style;
    }
}

