/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer;

import java.awt.RenderingHints;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.StyleBuilder;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeneralizationDistanceTest {
    private static final double EPS = 0.001;
    private SimpleFeatureCollection collection;
    private Style style;
    private Double lastDistance;
    private GeneralizingCollectionFeatureSource source;
    private CoordinateReferenceSystem webMercator;

    @Before
    public void setupData() throws SchemaException, ParseException, FactoryException {
        SimpleFeatureType buildingType = DataUtilities.createType((String)"building", (String)"id:0,geom:Polygon:srid=3857,name:String");
        SimpleFeature buildingFeature = SimpleFeatureBuilder.build((SimpleFeatureType)buildingType, (Object[])new Object[]{0, new WKTReader().read("POLYGON((0 0, 10 0, 10 10, 0 10, 0 0))"), "church"}, (String)"building.bd1");
        this.collection = DataUtilities.collection((SimpleFeature)buildingFeature);
        this.source = new GeneralizingCollectionFeatureSource(this.collection);
        this.lastDistance = null;
        StyleBuilder sb = new StyleBuilder();
        this.style = sb.createStyle((Symbolizer)sb.createPolygonSymbolizer());
        this.webMercator = CRS.decode((String)"EPSG:3857", (boolean)true);
    }

    @Test
    public void testDistanceNoReprojection() throws Exception {
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.source, this.style));
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        RendererBaseTest.renderImage((GTRenderer)sr, new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, this.webMercator), null, 100, 100);
        Assert.assertNotNull((Object)this.lastDistance);
        Assert.assertEquals((double)0.08, (double)this.lastDistance, (double)0.001);
    }

    @Test
    public void testDistanceReprojectionValidArea() throws Exception {
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.source, this.style));
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        RendererBaseTest.renderImage((GTRenderer)sr, new ReferencedEnvelope(0.0, 0.001, 0.0, 0.001, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), null, 100, 100);
        Assert.assertNotNull((Object)this.lastDistance);
        Assert.assertEquals((double)0.89, (double)this.lastDistance, (double)0.001);
    }

    @Test
    public void testDistanceReprojectionWholeWorld() throws Exception {
        this.assertDistanceWholeWorldRendering(Collections.emptyMap(), null);
        this.assertDistanceWholeWorldRendering(Collections.singletonMap("advancedProjectionHandling", Boolean.TRUE), 160300.0);
    }

    public void assertDistanceWholeWorldRendering(Map<Object, Object> hints, Double expectedDistance) {
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.source, this.style));
        StreamingRenderer sr = new StreamingRenderer();
        sr.setRendererHints(hints);
        sr.setMapContent(mc);
        RendererBaseTest.renderImage((GTRenderer)sr, new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), null, 200, 100);
        if (expectedDistance == null) {
            Assert.assertNull((Object)this.lastDistance);
        } else {
            Assert.assertNotNull((Object)this.lastDistance);
            Assert.assertEquals((double)expectedDistance, (double)this.lastDistance, (double)1.0);
        }
    }

    class GeneralizingCollectionFeatureSource
    extends CollectionFeatureSource {
        public GeneralizingCollectionFeatureSource(SimpleFeatureCollection collection) {
            super(collection);
        }

        public SimpleFeatureCollection getFeatures(Query query) {
            GeneralizationDistanceTest.this.lastDistance = (Double)query.getHints().get((Object)Hints.GEOMETRY_DISTANCE);
            return super.getFeatures(query);
        }

        public synchronized Set<RenderingHints.Key> getSupportedHints() {
            return Collections.singleton(Hints.GEOMETRY_DISTANCE);
        }
    }
}

