/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.logging.Level;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.LoggerTest;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

@Ignore
public class StreamingRendererMapContentReleaseTest
extends LoggerTest {
    private static final StyleFactory sf = CommonFactoryFinder.getStyleFactory();
    private static final FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    private static final GeometryFactory geom = JTSFactoryFinder.getGeometryFactory();

    @BeforeClass
    public static void setupOnce() {
        System.gc();
        Runtime.getRuntime().runFinalization();
    }

    @Test
    public void testMapContentRelease() {
        int i;
        MapContent content = new MapContent();
        DefaultFeatureCollection coll = new DefaultFeatureCollection();
        FeatureLayer layer = new FeatureLayer((FeatureCollection)coll, StreamingRendererMapContentReleaseTest.createDefaultStyle());
        FeatureLayer layer2 = new FeatureLayer((FeatureCollection)coll, StreamingRendererMapContentReleaseTest.createDefaultStyle());
        content.addLayer((Layer)layer);
        content.addLayer((Layer)layer2);
        SimpleFeatureTypeBuilder tbuilder = new SimpleFeatureTypeBuilder();
        tbuilder.setName("feature1");
        tbuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        tbuilder.add("geometry", Geometry.class);
        tbuilder.add("name", String.class);
        SimpleFeatureType type = tbuilder.buildFeatureType();
        int featureNumber = 50;
        ReferencedEnvelope bounds = new ReferencedEnvelope(-20.0, 20.0, -30.0, 30.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        PrimitiveIterator.OfDouble rand = new Random().doubles(bounds.getMinX(), bounds.getMaxX()).iterator();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(type);
        for (i = 0; i < featureNumber; ++i) {
            ArrayList<Coordinate> points = new ArrayList<Coordinate>();
            for (int j = 0; j < 5; ++j) {
                points.add(new Coordinate(rand.next().doubleValue(), rand.next().doubleValue()));
            }
            fb.add((Object)geom.createLineString(points.toArray(new Coordinate[0])));
            fb.add((Object)("Feature " + i));
            coll.add(fb.buildFeature(null));
        }
        for (i = 0; i < 10; ++i) {
            this.grabLogger(Level.SEVERE);
            this.renderAndStop(content, bounds);
            Runtime.getRuntime().runFinalization();
            String messages = this.getLogOutput();
            MatcherAssert.assertThat((Object)messages, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Call MapContent dispose() to prevent memory leaks")));
            this.releaseLogger();
        }
    }

    private void renderAndStop(MapContent content, ReferencedEnvelope bounds) {
        final StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(content);
        renderer.addRenderListener(new RenderListener(){
            int count = 0;

            public void featureRenderer(SimpleFeature feature) {
                ++this.count;
                if (this.count > 10) {
                    renderer.stopRendering();
                }
            }

            public void errorOccurred(Exception e) {
            }
        });
        Rectangle area = new Rectangle(0, 0, 2000, 2000);
        BufferedImage img = new BufferedImage(area.width, area.height, 2);
        renderer.paint((Graphics2D)img.getGraphics(), area, bounds);
    }

    private static Style createDefaultStyle() {
        Color foreground = Color.darkGray;
        int thick = 3;
        Stroke stroke = sf.stroke((Expression)ff.literal((Object)foreground), null, (Expression)ff.literal(thick), null, null, null, null);
        LineSymbolizer lineSym = sf.createLineSymbolizer(stroke, null);
        Rule r = sf.createRule();
        r.symbolizers().add(lineSym);
        Style style = sf.createStyle();
        FeatureTypeStyle fts = sf.createFeatureTypeStyle();
        fts.rules().add(r);
        style.featureTypeStyles().add(fts);
        return style;
    }
}

