/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.awt.Rectangle;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.LoggerTest;
import org.geotools.map.MapViewport;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;

public class MapViewportTest
extends LoggerTest {
    private static final ReferencedEnvelope WORLD_1_1 = new ReferencedEnvelope(150.0, 152.0, -33.0, -35.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private static final ReferencedEnvelope BIG_WORLD_1_1 = new ReferencedEnvelope(140.0, 160.0, -30.0, -50.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private static final Rectangle SCREEN_1_1 = new Rectangle(100, 100);
    private static final Rectangle SCREEN_2_1 = new Rectangle(200, 100);
    private static final Rectangle SCREEN_1_2 = new Rectangle(100, 200);
    private static final Rectangle SCREEN_2_2 = new Rectangle(200, 200);
    private static final double TOL = 1.0E-6;

    @Test
    public void defaultCtor() {
        MapViewport vp = new MapViewport();
        Assert.assertFalse((boolean)vp.isMatchingAspectRatio());
        Assert.assertTrue((boolean)vp.isEmpty());
        Assert.assertTrue((boolean)vp.getBounds().isEmpty());
        Assert.assertTrue((boolean)vp.getScreenArea().isEmpty());
        Assert.assertNull((Object)vp.getCoordinateReferenceSystem());
    }

    @Test
    public void boundsCtor() {
        MapViewport vp = new MapViewport(WORLD_1_1);
        Assert.assertTrue((boolean)vp.isEmpty());
        Assert.assertFalse((boolean)vp.isMatchingAspectRatio());
        Assert.assertTrue((boolean)vp.getScreenArea().isEmpty());
        Assert.assertTrue((boolean)WORLD_1_1.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
    }

    @Test
    public void booleanCtor() {
        MapViewport vp = new MapViewport(true);
        Assert.assertTrue((boolean)vp.isEmpty());
        Assert.assertTrue((boolean)vp.isMatchingAspectRatio());
        Assert.assertTrue((boolean)vp.getBounds().isEmpty());
        Assert.assertTrue((boolean)vp.getScreenArea().isEmpty());
    }

    @Test
    public void fullCtor() {
        MapViewport vp = new MapViewport(WORLD_1_1, true);
        Assert.assertTrue((boolean)vp.isEmpty());
        Assert.assertTrue((boolean)vp.isMatchingAspectRatio());
        Assert.assertTrue((boolean)vp.getScreenArea().isEmpty());
        Assert.assertTrue((boolean)WORLD_1_1.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
    }

    @Test
    public void copyCtor() {
        MapViewport vp = new MapViewport(WORLD_1_1, true);
        vp.setScreenArea(SCREEN_1_1);
        vp.setEditable(false);
        MapViewport copy = new MapViewport(vp);
        Assert.assertTrue((boolean)copy.isEditable());
        this.assertViewportsEqual(vp, copy);
    }

    @Test
    public void copyCtorHandlesEmtpyViewport() {
        MapViewport vp = new MapViewport();
        MapViewport copy = new MapViewport(vp);
        this.assertViewportsEqual(vp, copy);
    }

    private void assertViewportsEqual(MapViewport vp1, MapViewport vp2) {
        Assert.assertEquals((Object)vp1.getBounds(), (Object)vp2.getBounds());
        Assert.assertEquals((Object)vp1.getScreenArea(), (Object)vp2.getScreenArea());
        Assert.assertEquals((Object)vp1.getScreenToWorld(), (Object)vp2.getScreenToWorld());
        Assert.assertEquals((Object)vp1.isMatchingAspectRatio(), (Object)vp2.isMatchingAspectRatio());
    }

    @Test
    public void setBoundsNoAspectCorrection() {
        MapViewport vp = new MapViewport();
        vp.setScreenArea(SCREEN_2_1);
        vp.setBounds(WORLD_1_1);
        Assert.assertTrue((boolean)WORLD_1_1.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
    }

    @Test
    public void setBoundsWithAspectCorrection_2_1() {
        double w = WORLD_1_1.getWidth();
        ReferencedEnvelope expected = new ReferencedEnvelope(WORLD_1_1.getMinX() - w / 2.0, WORLD_1_1.getMaxX() + w / 2.0, WORLD_1_1.getMinY(), WORLD_1_1.getMaxY(), WORLD_1_1.getCoordinateReferenceSystem());
        this.assertAspectCorrection(SCREEN_2_1, expected);
    }

    @Test
    public void setBoundsWithAspectCorrection_1_2() {
        double h = WORLD_1_1.getHeight();
        ReferencedEnvelope expected = new ReferencedEnvelope(WORLD_1_1.getMinX(), WORLD_1_1.getMaxX(), WORLD_1_1.getMinY() - h / 2.0, WORLD_1_1.getMaxY() + h / 2.0, WORLD_1_1.getCoordinateReferenceSystem());
        this.assertAspectCorrection(SCREEN_1_2, expected);
    }

    private void assertAspectCorrection(Rectangle screenArea, ReferencedEnvelope expectedBounds) {
        MapViewport vp = new MapViewport(WORLD_1_1, true);
        vp.setScreenArea(screenArea);
        Assert.assertTrue((boolean)expectedBounds.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
    }

    @Test
    public void settingBoundsSetsTheViewportCRS() {
        MapViewport vp = new MapViewport();
        Assert.assertFalse((boolean)CRS.equalsIgnoreMetadata((Object)WORLD_1_1.getCoordinateReferenceSystem(), (Object)vp.getCoordinateReferenceSystem()));
        vp.setBounds(WORLD_1_1);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)WORLD_1_1.getCoordinateReferenceSystem(), (Object)vp.getCoordinateReferenceSystem()));
    }

    @Test
    public void boundsChangeWithScreenArea() {
        MapViewport vp = new MapViewport(true);
        vp.setScreenArea(SCREEN_1_1);
        vp.setBounds(WORLD_1_1);
        vp.setScreenArea(SCREEN_2_1);
        ReferencedEnvelope expectedBounds = new ReferencedEnvelope(WORLD_1_1.getMinX(), WORLD_1_1.getMaxX() + WORLD_1_1.getWidth(), WORLD_1_1.getMinY(), WORLD_1_1.getMaxY(), WORLD_1_1.getCoordinateReferenceSystem());
        Assert.assertTrue((boolean)expectedBounds.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
        vp.setFixedBoundsOnResize(true);
        vp.setScreenArea(SCREEN_1_1);
        vp.setBounds(WORLD_1_1);
        vp.setScreenArea(SCREEN_2_1);
        expectedBounds = new ReferencedEnvelope(WORLD_1_1.getMinX() - WORLD_1_1.getWidth() / 2.0, WORLD_1_1.getMaxX() + WORLD_1_1.getWidth() / 2.0, WORLD_1_1.getMinY(), WORLD_1_1.getMaxY(), WORLD_1_1.getCoordinateReferenceSystem());
        Assert.assertTrue((boolean)expectedBounds.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
        vp.setScreenArea(SCREEN_1_1);
        vp.setBounds(WORLD_1_1);
        vp.setScreenArea(SCREEN_2_2);
        Assert.assertTrue((boolean)WORLD_1_1.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
        vp.setScreenArea(SCREEN_1_1);
        Assert.assertTrue((boolean)WORLD_1_1.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
    }

    @Test
    public void newBoundsAreHonoured_NoAspectMatching() {
        MapViewport vp = new MapViewport(false);
        vp.setScreenArea(SCREEN_1_1);
        vp.setBounds(WORLD_1_1);
        vp.setBounds(BIG_WORLD_1_1);
        Assert.assertTrue((boolean)BIG_WORLD_1_1.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
    }

    @Test
    public void newBoundsAreHonoured_AspectMatching() {
        MapViewport vp = new MapViewport(true);
        vp.setScreenArea(SCREEN_1_1);
        vp.setBounds(WORLD_1_1);
        vp.setBounds(BIG_WORLD_1_1);
        Assert.assertTrue((boolean)BIG_WORLD_1_1.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
    }

    @Test
    public void coordinateTransform_MatchingAspectRatioDisabled() throws Exception {
        MapViewport vp = new MapViewport(false);
        ReferencedEnvelope world = WORLD_1_1;
        Rectangle screen = SCREEN_2_1;
        vp.setBounds(world);
        vp.setScreenArea(screen);
        double[] screenXY = new double[]{screen.getMinX(), screen.getMinY(), screen.getMaxX(), screen.getMaxY()};
        double[] worldXY = new double[screenXY.length];
        vp.getScreenToWorld().transform(screenXY, 0, worldXY, 0, screenXY.length / 2);
        Assert.assertEquals((double)world.getMinX(), (double)worldXY[0], (double)1.0E-6);
        Assert.assertEquals((double)world.getMaxY(), (double)worldXY[1], (double)1.0E-6);
        Assert.assertEquals((double)world.getMaxX(), (double)worldXY[2], (double)1.0E-6);
        Assert.assertEquals((double)world.getMinY(), (double)worldXY[3], (double)1.0E-6);
    }

    @Test
    public void coordinateTransform_MatchingAspectRatioEnabled() throws Exception {
        MapViewport vp = new MapViewport(true);
        Rectangle screen = SCREEN_2_1;
        vp.setBounds(WORLD_1_1);
        vp.setScreenArea(screen);
        ReferencedEnvelope actualWorld = vp.getBounds();
        double[] screenXY = new double[]{screen.getMinX(), screen.getMinY(), screen.getMaxX(), screen.getMaxY()};
        double[] worldXY = new double[screenXY.length];
        vp.getScreenToWorld().transform(screenXY, 0, worldXY, 0, screenXY.length / 2);
        Assert.assertEquals((double)actualWorld.getMinX(), (double)worldXY[0], (double)1.0E-6);
        Assert.assertEquals((double)actualWorld.getMaxY(), (double)worldXY[1], (double)1.0E-6);
        Assert.assertEquals((double)actualWorld.getMaxX(), (double)worldXY[2], (double)1.0E-6);
        Assert.assertEquals((double)actualWorld.getMinY(), (double)worldXY[3], (double)1.0E-6);
    }

    @Test
    public void boundsCtorSetsNullWorldToScreen() {
        MapViewport vp = new MapViewport(WORLD_1_1);
        Assert.assertNull((Object)vp.getWorldToScreen());
    }

    @Test
    public void boundsCtorSetNullScreenToWorld() {
        MapViewport vp = new MapViewport(WORLD_1_1);
        Assert.assertNull((Object)vp.getScreenToWorld());
    }

    @Test
    public void noArgCtorThenSetBoundsGivesNullWorldToScreen() {
        MapViewport vp = new MapViewport();
        vp.setBounds(WORLD_1_1);
        Assert.assertNull((Object)vp.getWorldToScreen());
    }

    @Test
    public void noArgCtorThenSetBoundsGivesNullScreenToWorld() {
        MapViewport vp = new MapViewport();
        vp.setBounds(WORLD_1_1);
        Assert.assertNull((Object)vp.getWorldToScreen());
    }

    @Test
    public void newViewportIsEditableByDefault() {
        MapViewport vp = new MapViewport();
        Assert.assertTrue((boolean)vp.isEditable());
    }

    @Test
    public void setAndRetrieveEditableStatus() {
        MapViewport vp = new MapViewport();
        vp.setEditable(false);
        Assert.assertFalse((boolean)vp.isEditable());
        vp.setEditable(true);
        Assert.assertTrue((boolean)vp.isEditable());
    }

    @Test
    public void callSetBoundsWhenNonEditable() throws Exception {
        MapViewport vp = new MapViewport();
        vp.setBounds(WORLD_1_1);
        vp.setEditable(false);
        this.grabLogger();
        vp.setBounds(BIG_WORLD_1_1);
        String s = this.getLogOutput();
        Assert.assertTrue((boolean)s.contains("Ignored call to setBounds"));
        Assert.assertTrue((boolean)WORLD_1_1.boundsEquals2D((Bounds)vp.getBounds(), 1.0E-6));
        this.releaseLogger();
    }

    @Test
    public void callSetScreenAreaWhenNonEditable() throws Exception {
        MapViewport vp = new MapViewport();
        vp.setScreenArea(SCREEN_1_1);
        vp.setEditable(false);
        this.grabLogger();
        vp.setScreenArea(SCREEN_2_1);
        String s = this.getLogOutput();
        Assert.assertTrue((boolean)s.contains("Ignored call to setScreenArea"));
        Assert.assertEquals((Object)SCREEN_1_1, (Object)vp.getScreenArea());
        this.releaseLogger();
    }

    @Test
    public void callSetCoordinateReferenceSystemWhenNonEditable() throws Exception {
        CoordinateReferenceSystem crs = WORLD_1_1.getCoordinateReferenceSystem();
        MapViewport vp = new MapViewport();
        vp.setCoordinateReferenceSystem(crs);
        vp.setEditable(false);
        this.grabLogger();
        vp.setCoordinateReferenceSystem(null);
        String s = this.getLogOutput();
        Assert.assertTrue((boolean)s.contains("Ignored call to setCoordinateReferenceSystem"));
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)crs, (Object)vp.getCoordinateReferenceSystem()));
        this.releaseLogger();
    }

    @Test
    public void callSetMatchingAspectRatioWhenNonEditable() throws Exception {
        MapViewport vp = new MapViewport();
        boolean original = vp.isMatchingAspectRatio();
        vp.setEditable(false);
        this.grabLogger();
        vp.setMatchingAspectRatio(!original);
        String s = this.getLogOutput();
        Assert.assertTrue((boolean)s.contains("Ignored call to setMatchingAspectRatio"));
        Assert.assertEquals((Object)original, (Object)vp.isMatchingAspectRatio());
        this.releaseLogger();
    }
}

