/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Rectangle;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.logging.Logging;

class GridGeometryReducer {
    static final Logger LOGGER = Logging.getLogger(GridGeometryReducer.class);
    ReferencedEnvelope validArea;

    public GridGeometryReducer(ReferencedEnvelope validArea) {
        this.validArea = validArea;
    }

    public GridGeometry2D reduce(GridGeometry2D gg) {
        if (gg.getEnvelope().getMaximum(1) > this.validArea.getMaximum(1)) {
            gg = this.reduceGridGeometrySide(gg, Side.TOP);
        }
        if (gg.getEnvelope().getMaximum(0) > this.validArea.getMaximum(0)) {
            gg = this.reduceGridGeometrySide(gg, Side.RIGHT);
        }
        if (gg.getEnvelope().getMinimum(1) < this.validArea.getMinimum(1)) {
            gg = this.reduceGridGeometrySide(gg, Side.BOTTOM);
        }
        if (gg.getEnvelope().getMinimum(0) < this.validArea.getMinimum(0)) {
            gg = this.reduceGridGeometrySide(gg, Side.LEFT);
        }
        return gg;
    }

    private GridGeometry2D reduceGridGeometrySide(GridGeometry2D gg, Side side) {
        Side curr = side;
        for (int i = 0; i <= 4; ++i) {
            for (int step = 1; step < 10; ++step) {
                GridEnvelope2D gridRange = gg.getGridRange2D();
                Rectangle bounds = gridRange.getBounds();
                GridEnvelope2D reducedRange = new GridEnvelope2D((Rectangle)gridRange);
                switch (curr) {
                    case TOP: {
                        reducedRange.setBounds(bounds.x, bounds.y + step, bounds.width, bounds.height - step);
                        break;
                    }
                    case RIGHT: {
                        reducedRange.setBounds(bounds.x, bounds.y, bounds.width - step, bounds.height);
                        break;
                    }
                    case BOTTOM: {
                        reducedRange.setBounds(bounds.x, bounds.y, bounds.width, bounds.height - step);
                        break;
                    }
                    case LEFT: {
                        reducedRange.setBounds(bounds.x + step, bounds.y, bounds.width - step, bounds.height);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected side " + side);
                    }
                }
                GridGeometry2D reducedGeometry = new GridGeometry2D((GridEnvelope)reducedRange, gg.getGridToCRS(), gg.getCoordinateReferenceSystem());
                Bounds reducedEnvelope = reducedGeometry.getEnvelope();
                if (!reducedGeometry.getGridRange2D().isEmpty()) {
                    switch (side) {
                        case TOP: {
                            if (!(reducedEnvelope.getMaximum(1) <= this.validArea.getMaximum(1))) break;
                            return reducedGeometry;
                        }
                        case RIGHT: {
                            if (!(reducedEnvelope.getMaximum(0) <= this.validArea.getMaximum(0))) break;
                            return reducedGeometry;
                        }
                        case BOTTOM: {
                            if (!(reducedEnvelope.getMinimum(1) >= this.validArea.getMinimum(1))) break;
                            return reducedGeometry;
                        }
                        case LEFT: {
                            if (!(reducedEnvelope.getMinimum(0) >= this.validArea.getMinimum(0))) break;
                            return reducedGeometry;
                        }
                        default: {
                            throw new RuntimeException("Unexpected side " + side);
                        }
                    }
                }
                curr = curr.next();
            }
        }
        LOGGER.warning("Could not reduce the grid geometry inside the valid area bounds: " + this.validArea + "\nGrid geometry is" + gg);
        return gg;
    }

    public GeneralBounds getCutEnvelope(GridGeometry2D reduced) {
        GeneralBounds result;
        MathTransform2D mt = reduced.getGridToCRS2D();
        if (mt instanceof AffineTransform2D) {
            AffineTransform2D at = (AffineTransform2D)mt;
            double scaleX = Math.abs(at.getScaleX());
            double scaleY = Math.abs(at.getScaleY());
            double step = (scaleX + scaleY) / 2.0 / 10.0;
            ReferencedEnvelope envelope = reduced.getEnvelope2D();
            result = new GeneralBounds(envelope.getCoordinateReferenceSystem());
            result.setEnvelope(new double[]{envelope.getMinX() + step, envelope.getMinY() + step, envelope.getMaxX() - step, envelope.getMaxY() - step});
        } else {
            result = new GeneralBounds(reduced.getEnvelope());
        }
        return result;
    }

    static enum Side {
        TOP(0),
        RIGHT(1),
        BOTTOM(2),
        LEFT(3);

        private int value;

        private Side(int value) {
            this.value = value;
        }

        public Side next() {
            int next = (this.value + 1) % 4;
            return Side.values()[next];
        }
    }
}

