/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.ReadResolutionCalculator;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.EmptyIntersectionException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.PolygonExtractor;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class GridCoverageReaderHelper {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final int DEFAULT_PADDING = 10;
    private static final Logger LOGGER = Logging.getLogger(GridCoverageReaderHelper.class);
    private GridCoverage2DReader reader;
    private ReferencedEnvelope mapExtent;
    private Rectangle mapRasterArea;
    private MathTransform worldToScreen;
    private GridGeometry2D requestedGridGeometry;
    private boolean paddingRequired;
    private boolean sameCRS;
    private int padding;

    public GridCoverageReaderHelper(GridCoverage2DReader reader, Rectangle mapRasterArea, ReferencedEnvelope mapExtent, Interpolation interpolation) throws FactoryException, IOException {
        this(reader, mapRasterArea, mapExtent, interpolation, null);
    }

    public GridCoverageReaderHelper(GridCoverage2DReader reader, Rectangle mapRasterArea, ReferencedEnvelope mapExtent, Interpolation interpolation, Hints hints) throws FactoryException, IOException {
        this.reader = reader;
        this.mapExtent = mapExtent;
        this.requestedGridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(mapRasterArea), (Bounds)mapExtent);
        this.worldToScreen = this.requestedGridGeometry.getCRSToGrid2D(PixelOrientation.UPPER_LEFT);
        this.padding = 10;
        if (hints != null && hints.containsKey((Object)GridCoverageRenderer.PADDING)) {
            this.padding = (Integer)hints.get((Object)GridCoverageRenderer.PADDING);
        }
        this.sameCRS = CRS.isEquivalent((CoordinateReferenceSystem)mapExtent.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)reader.getCoordinateReferenceSystem());
        boolean bl = this.paddingRequired = (!this.sameCRS || !(interpolation instanceof InterpolationNearest) || this.isMultiCRSReader(reader)) && !GridCoverageReaderHelper.isReprojectingReader(reader);
        if (this.paddingRequired) {
            MathTransform originalGridToWorld = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
            int[] paddings = this.computeRenderingPaddings(reader, mapExtent, interpolation, originalGridToWorld);
            GridEnvelope2D requestedGridEnvelope = new GridEnvelope2D(mapRasterArea);
            this.applyReadGutter(requestedGridEnvelope, paddings[0], paddings[1]);
            try {
                this.requestedGridGeometry = new GridGeometry2D((GridEnvelope)requestedGridEnvelope, PixelInCell.CELL_CORNER, this.worldToScreen.inverse(), mapExtent.getCoordinateReferenceSystem(), null);
                this.mapExtent = ReferencedEnvelope.reference((ReferencedEnvelope)this.requestedGridGeometry.getEnvelope2D());
                Dimension size = this.requestedGridGeometry.getGridRange2D().getBounds().getSize();
                this.mapRasterArea = new Rectangle(0, 0, size.width, size.height);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.mapExtent = mapExtent;
            this.mapRasterArea = mapRasterArea;
        }
    }

    private int[] computeRenderingPaddings(GridCoverage2DReader reader, ReferencedEnvelope mapExtent, Interpolation interpolation, MathTransform originalGridToWorld) throws IOException {
        int[] paddings = new int[]{this.padding, this.padding};
        double[][] levels = reader.getResolutionLevels();
        if (!(originalGridToWorld instanceof AffineTransform2D) || levels == null || interpolation instanceof InterpolationNearest) {
            return paddings;
        }
        try {
            CoordinateReferenceSystem readerCRS = reader.getCoordinateReferenceSystem();
            ReadResolutionCalculator cc = new ReadResolutionCalculator(this.requestedGridGeometry, readerCRS, levels[0]);
            double[] requestedRes = cc.computeRequestedResolution(mapExtent.transform(readerCRS, true));
            double[] nativeRes = levels[0];
            if (nativeRes[0] > requestedRes[0]) {
                paddings[0] = (int)Math.round(nativeRes[0] / requestedRes[0] * (double)this.padding);
            }
            if (nativeRes[1] > requestedRes[1]) {
                paddings[1] = (int)Math.round(nativeRes[1] / requestedRes[1] * (double)this.padding);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to account for oversampling in padding calculation, will use standard padding", e);
        }
        return paddings;
    }

    public static boolean isReprojectingReader(GridCoverage2DReader reader) throws IOException {
        return "true".equals(reader.getMetadataValue("ReprojectingReader"));
    }

    boolean isMultiCRSReader(GridCoverage2DReader reader) throws IOException {
        return "true".equals(reader.getMetadataValue("MultiCRSReader"));
    }

    public ReferencedEnvelope getReadEnvelope() {
        return this.mapExtent;
    }

    private void applyReadGutter(GridEnvelope2D gridRange, int padX, int padY) {
        gridRange.setBounds(gridRange.x - padX, gridRange.y - padY, gridRange.width + padX * 2, gridRange.height + padY * 2);
    }

    private GridGeometry2D applyReadGutter(GridGeometry2D gg) {
        MathTransform gridToCRS = gg.getGridToCRS();
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)gg.getGridRange2D());
        this.applyReadGutter(range, this.padding, this.padding);
        CoordinateReferenceSystem crs = gg.getEnvelope2D().getCoordinateReferenceSystem();
        GridGeometry2D result = new GridGeometry2D((GridEnvelope)range, PixelInCell.CELL_CORNER, gridToCRS, crs, null);
        return result;
    }

    public GridCoverage2D readCoverage(GeneralParameterValue[] params) throws IOException {
        return this.readSingleCoverage(params, this.requestedGridGeometry);
    }

    public List<GridCoverage2D> readCoverages(GeneralParameterValue[] readParams, ProjectionHandler handler) throws IOException, FactoryException, TransformException {
        return this.readCoverages(readParams, handler, new GridCoverageFactory());
    }

    public List<GridCoverage2D> readCoverages(GeneralParameterValue[] readParams, ProjectionHandler handler, GridCoverageFactory gridCoverageFactory) throws IOException, FactoryException, TransformException {
        if (handler == null) {
            GridCoverage2D readCoverage = this.readCoverage(readParams);
            GridCoverage2D cropped = this.cropCoverageOnRequestedEnvelope(readCoverage);
            if (cropped == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(cropped);
        }
        ArrayList<GridCoverage2D> coverages = new ArrayList<GridCoverage2D>();
        List queryEnvelopes = handler.getQueryEnvelopes();
        for (ReferencedEnvelope envelope : queryEnvelopes) {
            List<GridCoverage2D> readCoverages = this.readCoverageInEnvelope(envelope, readParams, handler, this.paddingRequired);
            if (readCoverages == null) continue;
            coverages.addAll(readCoverages);
        }
        SingleCRS readerCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.reader.getCoordinateReferenceSystem());
        if (readerCRS instanceof GeographicCRS) {
            int lonAxis;
            ReferencedEnvelope readerEnvelope = ReferencedEnvelope.reference((Bounds)this.reader.getOriginalEnvelope());
            boolean northEast = CRS.getAxisOrder((CoordinateReferenceSystem)readerCRS) == CRS.AxisOrder.NORTH_EAST;
            int n = lonAxis = northEast ? 1 : 0;
            if (readerEnvelope.getMaximum(lonAxis) > 180.0) {
                double ty;
                double tx;
                ReferencedEnvelope excess;
                if (northEast) {
                    excess = new ReferencedEnvelope(-90.0, 90.0, 180.0, 360.0, (CoordinateReferenceSystem)readerCRS);
                    tx = 0.0;
                    ty = 360.0;
                } else {
                    excess = new ReferencedEnvelope(180.0, 360.0, -90.0, 90.0, (CoordinateReferenceSystem)readerCRS);
                    tx = 360.0;
                    ty = 0.0;
                }
                for (ReferencedEnvelope envelope : queryEnvelopes) {
                    List<GridCoverage2D> readCoverages;
                    ReferencedEnvelope translated = new ReferencedEnvelope(envelope);
                    translated.translate(tx, ty);
                    ReferencedEnvelope intersection = new ReferencedEnvelope((Envelope)translated.intersection((Envelope)excess), translated.getCoordinateReferenceSystem());
                    boolean isEmptyEnvelope = intersection == null || intersection.isNull() || intersection.getHeight() == 0.0 || intersection.getWidth() == 0.0;
                    if (isEmptyEnvelope || (readCoverages = this.readCoverageInEnvelope(intersection, readParams, handler, false)) == null) continue;
                    for (GridCoverage2D gc : readCoverages) {
                        GridCoverage2D displaced = GridCoverageRendererUtilities.displace(gc, -tx, -ty, gridCoverageFactory);
                        if (this.coveragesContainArea(coverages, displaced)) continue;
                        coverages.add(displaced);
                    }
                }
            }
        }
        return coverages;
    }

    private boolean coveragesContainArea(List<GridCoverage2D> coverages, GridCoverage2D test) {
        for (GridCoverage2D coverage : coverages) {
            if (!coverage.getEnvelope2D().contains((BoundingBox)test.getEnvelope2D())) continue;
            return true;
        }
        return false;
    }

    private GridCoverage2D cropCoverageOnRequestedEnvelope(GridCoverage2D readCoverage) {
        if (readCoverage == null) {
            return null;
        }
        try {
            ReferencedEnvelope requested = ReferencedEnvelope.reference((Bounds)this.requestedGridGeometry.getEnvelope());
            ReferencedEnvelope requestedNativeCRS = requested.transform(readCoverage.getCoordinateReferenceSystem(), true);
            ReferencedEnvelope coverageEnvelope = ReferencedEnvelope.reference((Bounds)readCoverage.getEnvelope());
            ReferencedEnvelope cropEnvelope = new ReferencedEnvelope((Envelope)requestedNativeCRS.intersection((Envelope)coverageEnvelope), readCoverage.getCoordinateReferenceSystem());
            if (this.isNotEmpty(cropEnvelope)) {
                GridCoverage2D cropCoverage = this.cropCoverage(readCoverage, requestedNativeCRS);
                return cropCoverage;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to crop coverage on the requested area, using the original one", e);
            return readCoverage;
        }
    }

    List<GridCoverage2D> readCoverageInEnvelope(ReferencedEnvelope envelope, GeneralParameterValue[] readParams, ProjectionHandler handler, boolean paddingRequired) throws TransformException, FactoryException, IOException {
        GridCoverage2D coverage;
        Polygon polygon = JTS.toGeometry((ReferencedEnvelope)envelope);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(this.mapRasterArea), (Bounds)this.mapExtent);
        CoordinateReferenceSystem readerCRS = this.reader.getCoordinateReferenceSystem();
        GridGeometry2D readingGridGeometry = this.computeReadingGeometry(gg, readerCRS, polygon, handler, readParams);
        if (readingGridGeometry == null) {
            return null;
        }
        if (paddingRequired) {
            readingGridGeometry = this.applyReadGutter(readingGridGeometry);
        }
        if ((coverage = this.readSingleCoverage(readParams, readingGridGeometry)) == null) {
            return null;
        }
        ReferencedEnvelope readingEnvelope = ReferencedEnvelope.reference((ReferencedEnvelope)readingGridGeometry.getEnvelope2D());
        ReferencedEnvelope coverageEnvelope = ReferencedEnvelope.reference((ReferencedEnvelope)coverage.getEnvelope2D());
        Polygon coverageFootprint = JTS.toGeometry((ReferencedEnvelope)coverageEnvelope);
        Geometry preProcessed = handler.preProcess((Geometry)coverageFootprint);
        if (preProcessed != null && !preProcessed.isEmpty()) {
            if (coverageFootprint.equals(preProcessed)) {
                if (!readingEnvelope.contains((Envelope)coverageEnvelope)) {
                    ReferencedEnvelope cropEnvelope = new ReferencedEnvelope((Envelope)readingEnvelope.intersection((Envelope)coverageEnvelope), readerCRS);
                    GridCoverage2D cropped = this.cropCoverage(coverage, cropEnvelope);
                    return this.singleton(cropped);
                }
                return this.singleton(coverage);
            }
            List<Polygon> polygons = PolygonExtractor.INSTANCE.getPolygons(preProcessed);
            ArrayList<GridCoverage2D> coverages = new ArrayList<GridCoverage2D>();
            for (Polygon p : polygons) {
                ReferencedEnvelope cropEnvelope = new ReferencedEnvelope(p.getEnvelopeInternal(), readerCRS);
                cropEnvelope = new ReferencedEnvelope((Envelope)cropEnvelope.intersection((Envelope)coverageEnvelope), readerCRS);
                GridCoverage2D cropped = this.cropCoverage(coverage, cropEnvelope = new ReferencedEnvelope((Envelope)cropEnvelope.intersection((Envelope)readingEnvelope), readerCRS));
                if (cropped == null) continue;
                coverages.add(cropped);
            }
            return coverages;
        }
        return null;
    }

    private List<GridCoverage2D> singleton(GridCoverage2D coverage) {
        if (coverage == null) {
            return null;
        }
        return Collections.singletonList(coverage);
    }

    private boolean isNotEmpty(ReferencedEnvelope envelope) {
        return !envelope.isEmpty() && !envelope.isNull() && envelope.getWidth() > 0.0 && envelope.getHeight() > 0.0;
    }

    private GridCoverage2D cropCoverage(GridCoverage2D coverage, ReferencedEnvelope cropEnvelope) {
        if (this.isNotEmpty(cropEnvelope)) {
            ParameterValueGroup param = PROCESSOR.getOperation("CoverageCrop").getParameters();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("Envelope").setValue((Object)cropEnvelope);
            try {
                GridCoverage2D cropped = (GridCoverage2D)PROCESSOR.doOperation(param);
                return cropped;
            }
            catch (EmptyIntersectionException e) {
                return null;
            }
        }
        return null;
    }

    private GridGeometry2D computeReadingGeometry(GridGeometry2D gg, CoordinateReferenceSystem readerCRS, Polygon polygon, ProjectionHandler handler, GeneralParameterValue[] readParams) throws TransformException, FactoryException, IOException {
        GridGeometry2D readingGridGeometry;
        MathTransform2D crsToGrid2D = gg.getCRSToGrid2D();
        MathTransform2D gridToCRS2D = gg.getGridToCRS2D();
        if (this.sameCRS) {
            Envelope gridEnvelope = JTS.transform((Geometry)polygon, (MathTransform)crsToGrid2D).getEnvelopeInternal();
            GridEnvelope2D gridRange = new GridEnvelope2D((int)gridEnvelope.getMinX(), (int)gridEnvelope.getMinY(), (int)Math.round(gridEnvelope.getWidth()), (int)Math.round(gridEnvelope.getHeight()));
            readingGridGeometry = new GridGeometry2D((GridEnvelope)gridRange, (MathTransform)gridToCRS2D, readerCRS);
        } else {
            ReferencedEnvelope readEnvelope = new ReferencedEnvelope(polygon.getEnvelopeInternal(), readerCRS);
            ReferencedEnvelope reducedEnvelope = this.reduceEnvelope(readEnvelope, handler);
            if (reducedEnvelope == null) {
                return null;
            }
            ReferencedEnvelope reducedEnvelopeInRequestedCRS = reducedEnvelope.transform(this.requestedGridGeometry.getCoordinateReferenceSystem(), true);
            ReferencedEnvelope gridEnvelope = ReferencedEnvelope.reference((Bounds)CRS.transform((MathTransform)crsToGrid2D, (Bounds)reducedEnvelopeInRequestedCRS));
            GridEnvelope2D readingGridRange = new GridEnvelope2D((int)gridEnvelope.getMinX(), (int)gridEnvelope.getMinY(), (int)gridEnvelope.getWidth(), (int)gridEnvelope.getHeight());
            GridGeometry2D localGridGeometry = new GridGeometry2D((GridEnvelope)readingGridRange, (MathTransform)gridToCRS2D, this.mapExtent.getCoordinateReferenceSystem());
            double[][] resolutionLevels = this.reader.getResolutionLevels();
            ReadResolutionCalculator calculator = new ReadResolutionCalculator(localGridGeometry, readerCRS, resolutionLevels != null ? resolutionLevels[0] : null);
            String name = "Accurate resolution computation";
            boolean accurateResolution = true;
            if (readParams != null) {
                for (GeneralParameterValue gParam : readParams) {
                    ParameterValue param;
                    Object value;
                    if (gParam == null || !"Accurate resolution computation".equalsIgnoreCase(gParam.getDescriptor().getName().toString())) continue;
                    if (!(gParam instanceof ParameterValue) || (value = (param = (ParameterValue)gParam).getValue()) == null) break;
                    accurateResolution = (Boolean)value;
                    break;
                }
            }
            calculator.setAccurateResolution(accurateResolution && this.isAccurateResolutionComputationSafe(readEnvelope));
            double[] readResolution = calculator.computeRequestedResolution(reducedEnvelope);
            int width = (int)Math.max(1L, Math.round(readEnvelope.getWidth() / Math.abs(readResolution[0])));
            int height = (int)Math.max(1L, Math.round(readEnvelope.getHeight() / Math.abs(readResolution[1])));
            GridEnvelope2D gridRange = new GridEnvelope2D(0, 0, width, height);
            readingGridGeometry = new GridGeometry2D((GridEnvelope)gridRange, (Bounds)readEnvelope);
        }
        return readingGridGeometry;
    }

    boolean isAccurateResolutionComputationSafe(ReferencedEnvelope readEnvelope) throws MismatchedDimensionException, FactoryException, TransformException {
        CoordinateReferenceSystem readCRS = readEnvelope.getCoordinateReferenceSystem();
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)new ReferencedEnvelope(readCRS), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (boolean)true);
        if (handler != null) {
            if (handler.getValidAreaBounds() == null || handler instanceof WrappingProjectionHandler) {
                return true;
            }
            try {
                ReferencedEnvelope validBounds = handler.getValidAreaBounds().transform(readCRS, true);
                return validBounds.contains((Envelope)readEnvelope);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private ReferencedEnvelope reduceEnvelope(ReferencedEnvelope envelope, ProjectionHandler handler) throws TransformException, FactoryException {
        Polygon polygon = JTS.toGeometry((ReferencedEnvelope)envelope);
        Geometry geom = handler.preProcess((Geometry)polygon);
        if (geom == null) {
            return null;
        }
        PolygonExtractor pe = new PolygonExtractor();
        Polygon largest = null;
        for (Polygon p : pe.getPolygons(geom)) {
            if (largest != null && !(largest.getArea() > p.getArea())) continue;
            largest = p;
        }
        ReferencedEnvelope reduced = new ReferencedEnvelope(largest.getEnvelopeInternal(), envelope.getCoordinateReferenceSystem());
        return reduced;
    }

    GridCoverage2D readSingleCoverage(GeneralParameterValue[] readParams, GridGeometry2D gg) throws IOException {
        Parameter readGGParam = (Parameter)AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        readGGParam.setValue((Object)new GridGeometry2D((GridGeometry)gg));
        GridCoverage2D coverage = null;
        if (readParams != null) {
            int length = readParams.length;
            if (length > 0) {
                int i;
                String name = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
                for (i = 0; i < length && !readParams[i].getDescriptor().getName().toString().equalsIgnoreCase(name); ++i) {
                }
                if (i < length) {
                    readParams[i] = readGGParam;
                    coverage = this.reader.read(readParams);
                } else {
                    GeneralParameterValue[] readParams2 = new GeneralParameterValue[length + 1];
                    System.arraycopy(readParams, 0, readParams2, 0, length);
                    readParams2[length] = readGGParam;
                    coverage = this.reader.read(readParams2);
                }
            } else {
                coverage = this.reader.read(new GeneralParameterValue[]{readGGParam});
            }
        } else {
            coverage = gg != null ? this.reader.read(new GeneralParameterValue[]{readGGParam}) : this.reader.read(null);
        }
        return coverage;
    }
}

