/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.Scale2OpImage;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.Crop;
import org.geotools.coverage.processing.operation.Mosaic;
import org.geotools.coverage.processing.operation.Resample;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.gridcoverage2d.GridGeometryReducer;
import org.geotools.renderer.lite.gridcoverage2d.PolygonExtractor;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.algorithm.match.HausdorffSimilarityMeasure;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class GridCoverageRendererUtilities {
    private static final double EPS = 1.0E-6;
    private static final Logger LOGGER = Logging.getLogger(GridCoverageRendererUtilities.class);
    private static final CoverageProcessor processor = CoverageProcessor.getInstance((Hints)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));

    static void ensureNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(Errors.format(8, name));
        }
    }

    static void ensureSourceNotNull(Object source, String name) {
        if (source == null) {
            throw new IllegalArgumentException(Errors.format(3, name));
        }
    }

    static GridCoverage2D resample(GridCoverage2D gc, CoordinateReferenceSystem crs, Interpolation interpolation, GeneralEnvelope destinationEnvelope, double[] bkgValues, Hints hints) throws FactoryException {
        assert (CRS.equalsIgnoreMetadata((Object)destinationEnvelope.getCoordinateReferenceSystem(), (Object)crs) || CRS.findMathTransform((CoordinateReferenceSystem)destinationEnvelope.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)crs).isIdentity());
        ParameterValueGroup param = processor.getOperation("Resample").getParameters().clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("CoordinateReferenceSystem").setValue((Object)crs);
        param.parameter("InterpolationType").setValue((Object)interpolation);
        if (bkgValues != null) {
            param.parameter("BackgroundValues").setValue((Object)bkgValues);
        }
        return (GridCoverage2D)((Resample)processor.getOperation("Resample")).doOperation(param, hints);
    }

    public static List<GridCoverage2D> reproject(List<GridCoverage2D> coverages, CoordinateReferenceSystem destinationCRS, Interpolation interpolation, GeneralEnvelope destinationEnvelope, double[] bkgValues, GridCoverageFactory gridCoverageFactory, Hints hints) throws FactoryException {
        ArrayList<GridCoverage2D> reprojectedCoverages = new ArrayList<GridCoverage2D>();
        for (GridCoverage2D coverage : coverages) {
            if (coverage == null) continue;
            CoordinateReferenceSystem coverageCRS = coverage.getCoordinateReferenceSystem();
            if (!CRS.equalsIgnoreMetadata((Object)coverageCRS, (Object)destinationCRS)) {
                GridCoverage2D reprojected = GridCoverageRendererUtilities.reproject(coverage, destinationCRS, interpolation, destinationEnvelope, bkgValues, gridCoverageFactory, hints);
                if (reprojected == null) continue;
                reprojectedCoverages.add(reprojected);
                continue;
            }
            reprojectedCoverages.add(coverage);
        }
        return reprojectedCoverages;
    }

    public static GridCoverage2D reproject(GridCoverage2D coverage, CoordinateReferenceSystem destinationCRS, Interpolation interpolation, GeneralEnvelope destinationEnvelope, double[] bkgValues, GridCoverageFactory gridCoverageFactory, Hints hints) throws FactoryException {
        coverage = GridCoverageRendererUtilities.addRoiIfMissing(coverage, gridCoverageFactory);
        coverage = GridCoverageRendererUtilities.resample(coverage, destinationCRS, interpolation, destinationEnvelope, bkgValues, hints);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reprojecting to crs " + destinationCRS.toString());
        }
        return coverage;
    }

    private static GridCoverage2D addRoiIfMissing(GridCoverage2D coverage, GridCoverageFactory gridCoverageFactory) {
        RenderedImage input = coverage.getRenderedImage();
        Object roiObject = input.getProperty("ROI");
        Object gcRoiObject = coverage.getProperty("GC_ROI");
        if (!(roiObject instanceof ROI) && !(gcRoiObject instanceof ROI)) {
            Envelope env = new Envelope((double)input.getMinX(), (double)(input.getMinX() + input.getWidth()), (double)input.getMinY(), (double)(input.getMinY() + input.getHeight()));
            ROI roi = new ROI((RenderedImage)new ROIGeometry((Geometry)JTS.toGeometry((Envelope)env)).getAsImage());
            PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)input);
            pi.setProperty("ROI", (Object)roi);
            Map sourceProperties = coverage.getProperties();
            HashMap<String, ROI> properties = sourceProperties == null ? new HashMap<String, ROI>() : new HashMap(sourceProperties);
            properties.put("GC_ROI", roi);
            return gridCoverageFactory.create((CharSequence)coverage.getName(), (RenderedImage)pi, coverage.getGridGeometry(), coverage.getSampleDimensions(), (GridCoverage[])new GridCoverage2D[]{coverage}, properties);
        }
        return coverage;
    }

    static GridCoverage2D coverageCrop(GridCoverage2D gc, GeneralEnvelope envelope, double[] background, Hints hints) {
        GeneralEnvelope oldEnvelope = (GeneralEnvelope)gc.getEnvelope();
        GeneralEnvelope intersectionEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)envelope);
        intersectionEnvelope.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
        intersectionEnvelope.intersect((org.opengis.geometry.Envelope)oldEnvelope);
        if (intersectionEnvelope.isEmpty()) {
            return null;
        }
        ParameterValueGroup param = processor.getOperation("CoverageCrop").getParameters().clone();
        param.parameter("source").setValue((Object)gc);
        param.parameter("Envelope").setValue((Object)intersectionEnvelope);
        return (GridCoverage2D)((Crop)processor.getOperation("CoverageCrop")).doOperation(param, hints);
    }

    static GridCoverage2D displace(GridCoverage2D coverage, double tx, double ty, GridCoverageFactory gridCoverageFactory) {
        GridGeometry2D originalGG = coverage.getGridGeometry();
        GridEnvelope gridRange = originalGG.getGridRange();
        Envelope2D envelope = originalGG.getEnvelope2D();
        double minx = envelope.getMinX() + tx;
        double miny = envelope.getMinY() + ty;
        double maxx = envelope.getMaxX() + tx;
        double maxy = envelope.getMaxY() + ty;
        ReferencedEnvelope translatedEnvelope = new ReferencedEnvelope(minx, maxx, miny, maxy, envelope.getCoordinateReferenceSystem());
        GridGeometry2D translatedGG = new GridGeometry2D(gridRange, (org.opengis.geometry.Envelope)translatedEnvelope);
        GridCoverage2D translatedCoverage = gridCoverageFactory.create((CharSequence)coverage.getName(), coverage.getRenderedImage(), translatedGG, coverage.getSampleDimensions(), (GridCoverage[])new GridCoverage2D[]{coverage}, coverage.getProperties());
        return translatedCoverage;
    }

    static GridCoverage2D mosaic(List<GridCoverage2D> coverages, List<GridCoverage2D> alphas, GeneralEnvelope renderingEnvelope, Hints hints, double[] background) {
        try {
            ReferencedEnvelope targetEnvelope = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)renderingEnvelope);
            ReferencedEnvelope coveragesEnvelope = null;
            for (GridCoverage2D coverage : coverages) {
                ReferencedEnvelope re = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)coverage.getEnvelope2D());
                if (coveragesEnvelope == null) {
                    coveragesEnvelope = re;
                    continue;
                }
                coveragesEnvelope.expandToInclude((Envelope)re);
            }
            if ((targetEnvelope = new ReferencedEnvelope((Envelope)targetEnvelope.intersection(coveragesEnvelope), renderingEnvelope.getCoordinateReferenceSystem())).isEmpty() || targetEnvelope.isNull()) {
                return null;
            }
            GridCoverage2D firstCoverage = coverages.get(0);
            GridGeometry2D referenceGG = firstCoverage.getGridGeometry();
            MathTransform2D mt = referenceGG.getCRSToGrid2D();
            Rectangle rasterSpaceEnvelope = CRS.transform((MathTransform)mt, (org.opengis.geometry.Envelope)targetEnvelope).toRectangle2D().getBounds();
            GridEnvelope2D gridRange = new GridEnvelope2D(rasterSpaceEnvelope);
            GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)gridRange, referenceGG.getGridToCRS(), firstCoverage.getCoordinateReferenceSystem2D());
            ParameterValueGroup param = processor.getOperation("Mosaic").getParameters().clone();
            param.parameter("sources").setValue(coverages);
            param.parameter("geometry").setValue((Object)gridGeometry);
            if (background != null) {
                param.parameter("outputNoData").setValue((Object)background);
            }
            if (!alphas.isEmpty()) {
                param.parameter("alphas").setValue(alphas);
            }
            return (GridCoverage2D)((Mosaic)processor.getOperation("Mosaic")).doOperation(param, hints);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to mosaic the input coverages", e);
        }
    }

    static GeneralEnvelope reprojectEnvelope(GeneralEnvelope inputEnvelope, CoordinateReferenceSystem outputCRS) throws Exception {
        GeneralEnvelope outputEnvelope = null;
        CoordinateReferenceSystem inputCRS = inputEnvelope.getCoordinateReferenceSystem();
        if (!CRS.equalsIgnoreMetadata((Object)inputCRS, (Object)outputCRS)) {
            outputEnvelope = CRS.transform((org.opengis.geometry.Envelope)inputEnvelope, (CoordinateReferenceSystem)outputCRS);
            outputEnvelope.setCoordinateReferenceSystem(outputCRS);
        }
        if (outputEnvelope == null) {
            outputEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)inputEnvelope);
            outputEnvelope.setCoordinateReferenceSystem(inputCRS);
        }
        return null;
    }

    static GeneralEnvelope reprojectEnvelopeWithWGS84Pivot(GeneralEnvelope inputEnvelope, CoordinateReferenceSystem targetCRS) throws Exception {
        GridCoverageRendererUtilities.ensureNotNull(inputEnvelope, "destinationEnvelope");
        GridCoverageRendererUtilities.ensureNotNull(targetCRS, "coverageCRS");
        CoordinateReferenceSystem destinationCRS = inputEnvelope.getCoordinateReferenceSystem();
        try {
            CoordinateOperation operation = CRS.getCoordinateOperationFactory((boolean)true).createOperation(destinationCRS, targetCRS);
            GeneralEnvelope output = CRS.transform((CoordinateOperation)operation, (org.opengis.geometry.Envelope)inputEnvelope);
            output.setCoordinateReferenceSystem(targetCRS);
            return output;
        }
        catch (TransformException te) {
            GeneralEnvelope destinationEnvelopeWGS84 = GridCoverageRendererUtilities.reprojectEnvelope(inputEnvelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            return GridCoverageRendererUtilities.reprojectEnvelope(destinationEnvelopeWGS84, targetCRS);
        }
    }

    public static double[] colorToArray(Color color) {
        if (color == null) {
            return null;
        }
        return new double[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public static void removeNotIntersecting(List<GridCoverage2D> coverages, GeneralEnvelope destinationEnvelope) {
        Iterator<GridCoverage2D> it = coverages.iterator();
        while (it.hasNext()) {
            GridCoverage2D coverage = it.next();
            ReferencedEnvelope re = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)coverage.getEnvelope2D());
            if (destinationEnvelope.intersects((org.opengis.geometry.Envelope)re, false)) continue;
            it.remove();
        }
    }

    public static List<GridCoverage2D> displace(List<GridCoverage2D> coverages, ProjectionHandler handler, GeneralEnvelope destinationEnvelope, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, GridCoverageFactory gridCoverageFactory) throws FactoryException, TransformException {
        if (handler == null) {
            return coverages;
        }
        ArrayList<GridCoverage2D> displacedCoverages = new ArrayList<GridCoverage2D>();
        ReferencedEnvelope testEnvelope = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)destinationEnvelope);
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        PolygonExtractor polygonExtractor = new PolygonExtractor();
        for (GridCoverage2D coverage : coverages) {
            Polygon polygon = JTS.toGeometry((BoundingBox)coverage.getEnvelope2D());
            Geometry postProcessed = handler.postProcess(mt, (Geometry)polygon);
            List<Polygon> polygons = polygonExtractor.getPolygons(postProcessed);
            for (Polygon displaced : polygons) {
                Envelope intersection = testEnvelope.intersection(displaced.getEnvelopeInternal());
                if (intersection == null || intersection.isNull() || intersection.getArea() == 0.0) continue;
                if (displaced.equals((Geometry)polygon)) {
                    displacedCoverages.add(coverage);
                    continue;
                }
                double[] tx = GridCoverageRendererUtilities.getTranslationFactors(polygon, displaced);
                if (tx == null) continue;
                GridCoverage2D displacedCoverage = GridCoverageRendererUtilities.displace(coverage, tx[0], tx[1], gridCoverageFactory);
                displacedCoverages.add(displacedCoverage);
            }
        }
        return displacedCoverages;
    }

    public static List<GridCoverage2D> forceToValidBounds(List<GridCoverage2D> coverages, ProjectionHandler handler, double[] bgValues, CoordinateReferenceSystem targetCRS, Hints hints) {
        boolean reprojectionNeeded = false;
        for (GridCoverage2D coverage : coverages) {
            CoordinateReferenceSystem coverageCRS;
            if (coverage == null || CRS.equalsIgnoreMetadata((Object)(coverageCRS = coverage.getCoordinateReferenceSystem()), (Object)targetCRS)) continue;
            reprojectionNeeded = true;
            break;
        }
        if (reprojectionNeeded && handler != null && handler.getValidAreaBounds() != null) {
            ArrayList<GridCoverage2D> cropped = new ArrayList<GridCoverage2D>();
            ReferencedEnvelope validArea = handler.getValidAreaBounds();
            GridGeometryReducer reducer = new GridGeometryReducer(validArea);
            for (GridCoverage2D coverage : coverages) {
                GridGeometry2D gg = coverage.getGridGeometry();
                GridGeometry2D reduced = reducer.reduce(gg);
                if (!reduced.equals((Object)gg)) {
                    GeneralEnvelope cutEnvelope = reducer.getCutEnvelope(reduced);
                    GridCoverage2D croppedCoverage = GridCoverageRendererUtilities.crop(coverage, cutEnvelope, false, bgValues, hints);
                    if (croppedCoverage == null) continue;
                    cropped.add(croppedCoverage);
                    continue;
                }
                cropped.add(coverage);
            }
            coverages = cropped;
        }
        return coverages;
    }

    public static GridCoverage2D crop(GridCoverage2D coverage, GeneralEnvelope destinationEnvelope, boolean doReprojection, double[] backgroundValues, Hints hints) {
        GridCoverage2D outputCoverage = coverage;
        GeneralEnvelope coverageEnvelope = (GeneralEnvelope)coverage.getEnvelope();
        CoordinateReferenceSystem coverageCRS = coverage.getCoordinateReferenceSystem2D();
        try {
            GeneralEnvelope renderingEnvelopeInCoverageCRS = null;
            renderingEnvelopeInCoverageCRS = doReprojection ? GridCoverageRendererUtilities.reprojectEnvelopeWithWGS84Pivot(destinationEnvelope, coverageCRS) : new GeneralEnvelope((org.opengis.geometry.Envelope)destinationEnvelope);
            GeneralEnvelope cropEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)renderingEnvelopeInCoverageCRS);
            cropEnvelope.intersect((org.opengis.geometry.Envelope)coverageEnvelope);
            if (cropEnvelope.isEmpty() || cropEnvelope.isNull()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("The destination envelope does not intersect the envelope of the source coverage.");
                }
                return null;
            }
            outputCoverage = GridCoverageRendererUtilities.coverageCrop(coverage, cropEnvelope, backgroundValues, hints);
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Crop Failed for reason: " + t.getLocalizedMessage(), t);
            }
            outputCoverage = coverage;
        }
        return outputCoverage;
    }

    public static GridCoverage2D mosaicSorted(List<GridCoverage2D> coverages, GeneralEnvelope destinationEnvelope, double[] bgValues, Hints hints) {
        GridCoverage2D mosaicked = null;
        if (coverages.size() == 0) {
            return null;
        }
        if (coverages.size() == 1) {
            mosaicked = coverages.get(0);
        } else {
            Comparator sliverComparator = (c1, c2) -> {
                RenderedImage r1 = c1.getRenderedImage();
                RenderedImage r2 = c2.getRenderedImage();
                long areaDiff = (long)r2.getWidth() * (long)r2.getHeight() - (long)r1.getWidth() * (long)r1.getHeight();
                return (int)Math.signum(areaDiff);
            };
            Collections.sort(coverages, sliverComparator);
            Hints mosaicHints = new Hints((RenderingHints)hints);
            mosaicHints.put((Object)JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)false);
            mosaicked = GridCoverageRendererUtilities.mosaic(coverages, new ArrayList<GridCoverage2D>(), destinationEnvelope, mosaicHints, bgValues);
        }
        return mosaicked;
    }

    public static GridCoverage2D affine(GridCoverage2D coverage, Interpolation interpolation, AffineTransform affineTransform, double[] bkgValues, boolean useInputSampleDimensions, GridCoverageFactory gridCoverageFactory, Hints hints) {
        RenderedImage finalImage = coverage.getRenderedImage();
        GridGeometry2D gridGeometry = coverage.getGridGeometry();
        MathTransform2D finalGCTransform = gridGeometry.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
        if (!(finalGCTransform instanceof AffineTransform)) {
            throw new UnsupportedOperationException("Non-affine transformations not yet implemented");
        }
        AffineTransform finalGCgridToWorld = new AffineTransform((AffineTransform)finalGCTransform);
        Range noData = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage) != null ? CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage).getAsRange() : null;
        ROI roi = CoverageUtilities.getROIProperty((GridCoverage2D)coverage);
        AffineTransform finalRasterTransformation = (AffineTransform)affineTransform.clone();
        finalRasterTransformation.concatenate(finalGCgridToWorld);
        ImageLayout finalLayout = Scale2OpImage.layoutHelper((RenderedImage)finalImage, (double)((float)Math.abs(finalRasterTransformation.getScaleX())), (double)((float)Math.abs(finalRasterTransformation.getScaleY())), (double)((float)finalRasterTransformation.getTranslateX()), (double)((float)finalRasterTransformation.getTranslateY()), (Interpolation)interpolation, null);
        if (finalLayout.getWidth(null) < 1 || finalLayout.getHeight(null) < 1) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Unable to create a granuleDescriptor due to jai scale bug");
            }
            return null;
        }
        RenderedImage im = null;
        ImageWorker iw = new ImageWorker(finalImage);
        iw.setRenderingHints((RenderingHints)hints);
        iw.setROI(roi);
        iw.setNoData(noData);
        iw.affine(finalRasterTransformation, interpolation, bkgValues);
        im = iw.getRenderedImage();
        roi = iw.getROI();
        noData = iw.extractNoDataProperty(im);
        int numBands = im.getSampleModel().getNumBands();
        GridSampleDimension[] sd = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            sd[i] = new GridSampleDimension((CharSequence)(useInputSampleDimensions ? coverage.getSampleDimension(i).getDescription() : TypeMap.getColorInterpretation((ColorModel)im.getColorModel(), (int)i).name()));
        }
        HashMap properties = coverage.getProperties();
        if (properties == null) {
            properties = new HashMap();
        }
        CoverageUtilities.setNoDataProperty((Map)properties, (Object)noData);
        CoverageUtilities.setROIProperty(properties, (ROI)roi);
        return gridCoverageFactory.create((CharSequence)coverage.getName(), im, new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage((RenderedImage)im).getBounds()), coverage.getEnvelope()), sd, new GridCoverage[]{coverage}, properties);
    }

    private static double[] getTranslationFactors(Polygon reference, Polygon displaced) {
        Envelope re = reference.getEnvelopeInternal();
        Envelope de = displaced.getEnvelopeInternal();
        double dw = Math.abs(re.getWidth() - de.getWidth());
        double dh = Math.abs(re.getHeight() - de.getHeight());
        if (dw > 1.0E-6 * re.getWidth() || dh > 1.0E-6 * re.getWidth()) {
            return null;
        }
        double dx = de.getMinX() - re.getMinX();
        double dy = de.getMinY() - re.getMinY();
        Polygon cloned = (Polygon)displaced.copy();
        cloned.apply((CoordinateSequenceFilter)AffineTransformation.translationInstance((double)(-dx), (double)(-dy)));
        HausdorffSimilarityMeasure hausdorffSimilarityMeasure = new HausdorffSimilarityMeasure();
        if (1.0 - hausdorffSimilarityMeasure.measure((Geometry)cloned, (Geometry)reference) > 1.0E-6) {
            return null;
        }
        return new double[]{dx, dy};
    }
}

