/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.filter.function.InFunction;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.renderer.lite.FilterMemoizer;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.xml.sax.helpers.NamespaceSupport;

class MemoryFilterOptimizer
extends DuplicatingFilterVisitor {
    static final Object NULL_PLACEHOLDER = new Object();
    private final Set<Object> memoizeCandidates;
    Map<Expression, Expression> expressionReplacements = new HashMap<Expression, Expression>();
    Map<Filter, Filter> filterReplacements = new HashMap<Filter, Filter>();
    SimpleFeatureType simpleFeatureType;

    public MemoryFilterOptimizer(FeatureType schema, Set<Object> memoizeCandidates) {
        if (schema instanceof SimpleFeatureType) {
            this.simpleFeatureType = (SimpleFeatureType)schema;
        }
        this.memoizeCandidates = memoizeCandidates;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(And filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Id filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Not filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Or filter, Object extraData) {
        return this.memoize(filter, extraData, this::inFilterOptimizer);
    }

    private Object inFilterOptimizer(Or filter, Object extraData) {
        InFunction inFilter = this.replaceWithInFilter(filter);
        if (inFilter == null) {
            return super.visit(filter, extraData);
        }
        return this.ff.equals((Expression)inFilter, (Expression)this.ff.literal(true));
    }

    private InFunction replaceWithInFilter(Or filter) {
        List children = filter.getChildren();
        Expression expression = null;
        ArrayList<Literal> literals = new ArrayList<Literal>(children.size());
        for (Filter childFilter : children) {
            if (!(childFilter instanceof PropertyIsEqualTo)) {
                return null;
            }
            PropertyIsEqualTo eqto = (PropertyIsEqualTo)childFilter;
            Pair<Expression, Literal> equalsParameters = this.getEqualsParameters(eqto);
            if (equalsParameters == null) {
                return null;
            }
            if (expression == null) {
                expression = (Expression)equalsParameters.getLeft();
            } else if (!Objects.equals(expression, equalsParameters.getLeft())) {
                return null;
            }
            literals.add((Literal)equalsParameters.getRight());
        }
        ArrayList<Object> inParameters = new ArrayList<Object>(literals.size() + 1);
        inParameters.add(expression);
        inParameters.addAll(literals);
        InFunction inFunction = new InFunction();
        inFunction.setParameters(inParameters);
        return inFunction;
    }

    private Pair<Expression, Literal> getEqualsParameters(PropertyIsEqualTo equals) {
        Literal literal = null;
        Expression expression = null;
        if (equals.getExpression1() instanceof Literal) {
            literal = (Literal)equals.getExpression1();
            expression = equals.getExpression2();
        } else if (equals.getExpression2() instanceof Literal) {
            literal = (Literal)equals.getExpression2();
            expression = equals.getExpression1();
        }
        if (expression != null && literal != null) {
            return Pair.of((Object)expression, (Object)literal);
        }
        return null;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Contains filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Equals filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Touches filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public Object visit(Within filter, Object extraData) {
        return this.memoize(filter, extraData, (x$0, x$1) -> super.visit(x$0, x$1));
    }

    public <T extends Filter> T memoize(T filter, Object extraData, BiFunction<T, Object, Object> duplicator) {
        if (!this.memoizeCandidates.contains(filter)) {
            return (T)((Filter)duplicator.apply(filter, extraData));
        }
        Filter replacement = this.filterReplacements.get(filter);
        if (replacement == null) {
            Filter duplicated = (Filter)duplicator.apply(filter, extraData);
            replacement = FilterMemoizer.memoize(duplicated);
            this.filterReplacements.put(filter, replacement);
        }
        return (T)replacement;
    }

    public Object visit(PropertyName expression, Object extraData) {
        Object replacement = this.expressionReplacements.get(expression);
        if (replacement == null) {
            replacement = this.simpleFeatureType != null && this.simpleFeatureType.indexOf(expression.getPropertyName()) >= 0 ? new IndexPropertyName(this.simpleFeatureType, expression) : (this.memoizeCandidates.contains(expression) ? new MemoizedPropertyName(expression) : expression);
            this.expressionReplacements.put((Expression)expression, (Expression)replacement);
        }
        return replacement;
    }

    static class MemoizedPropertyName
    implements PropertyName {
        PropertyName delegate;
        Object lastFeature = NULL_PLACEHOLDER;
        Object lastResult;
        Class lastContext;

        public MemoizedPropertyName(PropertyName delegate) {
            this.delegate = delegate;
        }

        public String getPropertyName() {
            return this.delegate.getPropertyName();
        }

        public NamespaceSupport getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        public Object evaluate(Object object) {
            if (object != this.lastFeature || this.lastContext != null) {
                this.lastResult = this.delegate.evaluate(object);
                this.lastFeature = object;
                this.lastContext = null;
            }
            return this.lastResult;
        }

        public <T> T evaluate(Object object, Class<T> context) {
            if (object != this.lastFeature || !Objects.equals(this.lastContext, context)) {
                this.lastResult = this.delegate.evaluate(object, context);
                this.lastContext = context;
            }
            return (T)this.lastResult;
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return this.delegate.accept(visitor, extraData);
        }
    }

    static class IndexPropertyName
    implements PropertyName {
        private final AttributeDescriptor descriptor;
        private SimpleFeatureType schema;
        PropertyName delegate;
        int index;

        public IndexPropertyName(SimpleFeatureType schema, PropertyName delegate) {
            this.delegate = delegate;
            this.schema = schema;
            this.index = schema.indexOf(delegate.getPropertyName());
            this.descriptor = schema.getDescriptor(this.index);
        }

        public String getPropertyName() {
            return this.delegate.getPropertyName();
        }

        public NamespaceSupport getNamespaceContext() {
            return this.delegate.getNamespaceContext();
        }

        public Object evaluate(Object object) {
            return this.evaluate(object, null);
        }

        public <T> T evaluate(Object object, Class<T> context) {
            SimpleFeature sf;
            SimpleFeatureType other;
            if (object instanceof SimpleFeature && ((other = (sf = (SimpleFeature)object).getFeatureType()) == this.schema || other.getDescriptor(this.index).equals(this.descriptor))) {
                if (other != this.schema) {
                    this.schema = other;
                }
                try {
                    Object value = sf.getAttribute(this.index);
                    if (context == null || context.isInstance(value)) {
                        return (T)value;
                    }
                    return (T)Converters.convert((Object)value, context);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("Could not locate attribute at index " + this.index + " on feature " + object, e);
                }
            }
            return (T)this.delegate.evaluate(object, context);
        }

        public Object accept(ExpressionVisitor visitor, Object extraData) {
            return this.delegate.accept(visitor, extraData);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

