/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.renderer.style.StyleAttributeExtractor;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.AnchorPoint;

public class StyleAttributeExtractorTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    StyleBuilder sb = new StyleBuilder(this.ff);

    @Test
    public void testPlainFilter() {
        PropertyIsGreaterThan f = this.ff.greater((Expression)this.ff.property("attribute"), (Expression)this.ff.literal(10));
        Rule r = this.sb.createRule((Symbolizer)this.sb.createPointSymbolizer());
        r.setFilter((Filter)f);
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        r.accept((StyleVisitor)extractor);
        Set atts = extractor.getAttributeNameSet();
        Assert.assertTrue((boolean)atts.contains("attribute"));
        Assert.assertEquals((long)1L, (long)atts.size());
        Assert.assertTrue((boolean)extractor.getDefaultGeometryUsed());
    }

    @Test
    public void testGeometryTransformation() {
        PointSymbolizer ps = this.sb.createPointSymbolizer();
        ps.setGeometry((Expression)this.ff.function("offset", new Expression[]{this.ff.property("the_geom"), this.ff.property("offx"), this.ff.property("offy")}));
        Rule r = this.sb.createRule((Symbolizer)ps);
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        r.accept((StyleVisitor)extractor);
        Set atts = extractor.getAttributeNameSet();
        Assert.assertEquals((long)3L, (long)atts.size());
        Assert.assertTrue((boolean)atts.contains("the_geom"));
        Assert.assertTrue((boolean)atts.contains("offx"));
        Assert.assertTrue((boolean)atts.contains("offy"));
        Assert.assertFalse((boolean)extractor.getDefaultGeometryUsed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPropertyFucntion() {
        PointSymbolizer ps = this.sb.createPointSymbolizer();
        ps.setGeometry((Expression)this.ff.function("offset", new Expression[]{this.ff.property("the_geom"), this.ff.property("offx"), this.ff.property("offy")}));
        Function func = this.ff.function("property", new Expression[]{this.ff.function("env", new Expression[]{this.ff.literal((Object)"pname")})});
        PropertyIsEqualTo filter = this.ff.equals((Expression)func, (Expression)this.ff.literal((Object)"test"));
        Rule r = this.sb.createRule((Symbolizer)ps);
        r.setFilter((Filter)filter);
        try {
            EnvFunction.setLocalValue((String)"pname", (Object)"name");
            StyleAttributeExtractor extractor = new StyleAttributeExtractor();
            r.accept((StyleVisitor)extractor);
            Set atts = extractor.getAttributeNameSet();
            Assert.assertEquals((long)4L, (long)atts.size());
            Assert.assertTrue((boolean)atts.contains("the_geom"));
            Assert.assertTrue((boolean)atts.contains("offx"));
            Assert.assertTrue((boolean)atts.contains("offy"));
            Assert.assertTrue((boolean)atts.contains("name"));
            Assert.assertFalse((boolean)extractor.getDefaultGeometryUsed());
            Set propNames = extractor.getAttributes();
            Assert.assertNotNull((Object)propNames);
            Assert.assertEquals((long)atts.size(), (long)propNames.size());
            for (PropertyName pn : propNames) {
                Assert.assertTrue((boolean)atts.contains(pn.getPropertyName()));
            }
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void testGraphicAnchor() {
        Graphic g = this.sb.createGraphic();
        g.setAnchorPoint((AnchorPoint)this.sb.createAnchorPoint((Expression)this.ff.property("ax"), (Expression)this.ff.property("ay")));
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        g.accept((StyleVisitor)extractor);
        Set atts = extractor.getAttributeNameSet();
        Assert.assertEquals((long)2L, (long)atts.size());
        Assert.assertTrue((boolean)atts.contains("ax"));
        Assert.assertTrue((boolean)atts.contains("ay"));
    }

    @Test
    public void testLineSymbolizer() {
        PropertyName expression = this.ff.property("attribute");
        LineSymbolizer lineSymbolizer = this.sb.createLineSymbolizer();
        lineSymbolizer.setPerpendicularOffset((Expression)expression);
        Rule r = this.sb.createRule((Symbolizer)lineSymbolizer);
        StyleAttributeExtractor extractor = new StyleAttributeExtractor();
        r.accept((StyleVisitor)extractor);
        Set atts = extractor.getAttributeNameSet();
        Assert.assertTrue((boolean)atts.contains("attribute"));
        Assert.assertEquals((long)1L, (long)atts.size());
        lineSymbolizer.setPerpendicularOffset((Expression)this.ff.literal(34.12));
        extractor = new StyleAttributeExtractor();
        r.accept((StyleVisitor)extractor);
        atts = extractor.getAttributeNameSet();
        Assert.assertEquals((long)0L, (long)atts.size());
    }
}

