/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageReader;
import it.geosolutions.imageio.plugins.arcgrid.spi.AsciiGridsImageReaderSpi;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.jaiext.piecewise.DefaultConstantPiecewiseTransformElement;
import it.geosolutions.jaiext.piecewise.DefaultLinearPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.DefaultPassthroughPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1D;
import it.geosolutions.jaiext.piecewise.DefaultPiecewiseTransform1DElement;
import it.geosolutions.jaiext.piecewise.MathTransformation;
import it.geosolutions.jaiext.piecewise.NoninvertibleTransformException;
import it.geosolutions.jaiext.piecewise.PiecewiseTransform1D;
import it.geosolutions.jaiext.piecewise.PiecewiseUtilities;
import it.geosolutions.jaiext.piecewise.Position;
import it.geosolutions.jaiext.piecewise.SingleDimensionTransformation;
import it.geosolutions.jaiext.piecewise.TransformationException;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import org.geotools.TestData;
import org.geotools.image.ImageWorker;
import org.geotools.renderer.lite.gridcoverage2d.MathTransformationAdapter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.operation.TransformException;

public class TestPiecewise {
    private static final String LOGGER = null;

    @Test
    public void linearTransform() throws IOException, TransformException, TransformationException {
        DefaultPiecewiseTransform1DElement e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((int)0, (int)100), (Range)RangeFactory.create((int)0, (int)200));
        Assert.assertTrue((boolean)(e0 instanceof DefaultLinearPiecewiseTransform1DElement));
        Assert.assertEquals((double)((DefaultLinearPiecewiseTransform1DElement)e0).getOutputMinimum(), (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)((DefaultLinearPiecewiseTransform1DElement)e0).getOutputMaximum(), (double)e0.transform(e0.getInputMaximum()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((DefaultLinearPiecewiseTransform1DElement)e0).getOffset(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)((DefaultLinearPiecewiseTransform1DElement)e0).getScale(), (double)0.0);
        Assert.assertFalse((boolean)e0.isIdentity());
        Assert.assertEquals((long)1L, (long)e0.getSourceDimensions());
        Assert.assertEquals((long)1L, (long)e0.getTargetDimensions());
        try {
            Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((long)1L, (long)transform.getSourceDimensions());
        Assert.assertEquals((long)1L, (long)transform.getTargetDimensions());
    }

    @Test
    public void mathTransform1DAdapter() throws IOException, TransformException {
        MathTransformationAdapter defaultAdapter = new MathTransformationAdapter();
        Assert.assertEquals((long)defaultAdapter.getSourceDimensions(), (long)1L);
        Assert.assertEquals((long)defaultAdapter.getTargetDimensions(), (long)1L);
        try {
            defaultAdapter.inverseTransform();
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            defaultAdapter.transform(0.0);
            Assert.assertFalse((boolean)true);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void constantTransform() throws IOException, TransformException, NoninvertibleTransformException, TransformationException {
        DefaultPiecewiseTransform1DElement e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY), (byte)0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            e0.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY), (int)0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            e0.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultPiecewiseTransform1D transform1 = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform1.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform1.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        Assert.assertFalse((boolean)transform.equals((Object)transform1));
        Assert.assertFalse((boolean)transform1.equals((Object)transform));
        Assert.assertFalse((boolean)transform.equals((Object)transform));
        Assert.assertFalse((boolean)transform1.equals((Object)transform1));
        Assert.assertEquals((long)transform1.hashCode(), (long)transform.hashCode());
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY), (double)0.0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(0.0), (double)0.0);
        Assert.assertEquals((double)e0.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        try {
            e0.inverse();
            Assert.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(Double.POSITIVE_INFINITY), (double)0.0, (double)0.0);
        e0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((int)3, (int)3), (double)0.0);
        Assert.assertTrue((boolean)(e0 instanceof DefaultConstantPiecewiseTransformElement));
        Assert.assertEquals((double)0.0, (double)e0.transform(3.0), (double)0.0);
        Assert.assertEquals((double)3.0, (double)e0.inverse().transform(new Position(0.0), null).getOrdinatePosition(), (double)0.0);
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{e0});
        Assert.assertEquals((double)0.0, (double)e0.transform(3.0), (double)0.0);
        Assert.assertEquals((double)transform.transform(3.0), (double)0.0, (double)0.0);
    }

    @Test
    public void piecewiseLogarithm() throws IOException, TransformException, TransformationException {
        DefaultPiecewiseTransform1DElement zero = DefaultPiecewiseTransform1DElement.create((CharSequence)"zero", (Range)RangeFactory.create((int)0, (int)0), (int)0);
        DefaultPiecewiseTransform1DElement mainElement = new DefaultPiecewiseTransform1DElement((CharSequence)"natural logarithm", RangeFactory.create((int)0, (boolean)false, (int)255, (boolean)true), new MathTransformation(){

            public double derivative(double arg0) throws TransformException {
                return 1.0 / arg0;
            }

            public double transform(double arg0) {
                return Math.log(arg0);
            }

            public int getSourceDimensions() {
                return 1;
            }

            public int getTargetDimensions() {
                return 1;
            }

            public boolean isIdentity() {
                return false;
            }

            public MathTransformation inverseTransform() {
                return null;
            }

            public Position transform(Position ptSrc, Position ptDst) throws TransformationException {
                if (ptDst == null) {
                    ptDst = new Position();
                }
                ptDst.setOrdinatePosition(this.transform(ptSrc.getOrdinatePosition()));
                return ptDst;
            }
        });
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)transform.transform(1.0), (double)0.0);
        Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(255.0), (double)0.0);
        Assert.assertEquals((double)Math.log(124.0), (double)transform.transform(124.0), (double)0.0);
        boolean exceptionFound = false;
        try {
            Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(256.0), (double)0.0);
        }
        catch (TransformationException e) {
            exceptionFound = true;
        }
        Assert.assertTrue((boolean)exceptionFound);
        DefaultPiecewiseTransform1DElement nodata = DefaultPiecewiseTransform1DElement.create((CharSequence)"no-data", (Range)RangeFactory.create((int)-1, (int)-1), (double)Double.NaN);
        transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement, nodata});
        Assert.assertEquals((double)0.0, (double)transform.transform(0.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)transform.transform(1.0), (double)0.0);
        Assert.assertEquals((double)Math.log(255.0), (double)transform.transform(255.0), (double)0.0);
        Assert.assertEquals((double)Math.log(124.0), (double)transform.transform(124.0), (double)0.0);
        exceptionFound = false;
        try {
            Assert.assertTrue((boolean)Double.isNaN(transform.transform(256.0)));
        }
        catch (TransformationException e1) {
            exceptionFound = true;
        }
        Assert.assertTrue((boolean)exceptionFound);
        DefaultPiecewiseTransform1DElement overlap = DefaultPiecewiseTransform1DElement.create((CharSequence)"overlap", (Range)RangeFactory.create((int)-100, (int)12), (double)Double.NaN);
        exceptionFound = false;
        try {
            transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{zero, mainElement, overlap, nodata});
        }
        catch (Throwable e) {
            exceptionFound = true;
        }
        Assert.assertTrue((boolean)exceptionFound);
    }

    @Test
    public void defaultTransform() throws IOException, TransformException, TransformationException {
        DefaultPiecewiseTransform1DElement t0 = new DefaultPiecewiseTransform1DElement((CharSequence)"t0", RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true), PiecewiseUtilities.createLinearTransform1D((Range)RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true), (Range)RangeFactory.create((int)200, (int)201)));
        Assert.assertEquals((double)t0.transform(0.5), (double)200.5, (double)0.0);
        Assert.assertTrue((boolean)t0.contains(0.5));
        Assert.assertTrue((boolean)t0.contains(RangeFactory.create((double)0.1, (double)0.9)));
        Assert.assertFalse((boolean)t0.contains(1.5));
        Assert.assertFalse((boolean)t0.contains(RangeFactory.create((double)0.1, (double)1.9)));
        Assert.assertTrue((boolean)t0.equals((Object)t0));
        Assert.assertEquals((double)t0.transform(new Position(0.5), null).getOrdinatePosition(), (double)200.5, (double)0.0);
        Assert.assertEquals((double)t0.inverse().transform(new Position(200.5), null).getOrdinatePosition(), (double)0.5, (double)0.0);
        t0 = DefaultPiecewiseTransform1DElement.create((CharSequence)"t0", (Range)RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true), (Range)RangeFactory.create((int)200, (int)201));
        Assert.assertFalse((boolean)t0.equals((Object)DefaultPiecewiseTransform1DElement.create((CharSequence)"t0", (Range)RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true), (Range)RangeFactory.create((int)200, (int)202))));
        Assert.assertEquals((double)t0.transform(0.5), (double)200.5, (double)0.0);
        Assert.assertEquals((double)t0.transform(new Position(0.5), null).getOrdinatePosition(), (double)200.5, (double)0.0);
        Assert.assertEquals((double)t0.inverse().transform(new Position(200.5), null).getOrdinatePosition(), (double)0.5, (double)0.0);
        DefaultPiecewiseTransform1DElement t1 = DefaultPiecewiseTransform1DElement.create((CharSequence)"t1", (Range)RangeFactory.create((double)1.0, (boolean)false, (double)2.0, (boolean)true), (int)201);
        Assert.assertEquals((double)t1.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform(1.6), (double)201.0, (double)0.0);
        Assert.assertFalse((boolean)t0.equals((Object)t1));
        Assert.assertEquals((double)t1.transform(new Position(1.8), null).getOrdinatePosition(), (double)201.0, (double)0.0);
        t1 = new DefaultConstantPiecewiseTransformElement((CharSequence)"t1", RangeFactory.create((double)1.0, (boolean)false, (double)2.0, (boolean)true), 201);
        Assert.assertEquals((double)t1.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform(1.6), (double)201.0, (double)0.0);
        Assert.assertEquals((double)t1.transform(new Position(1.8), null).getOrdinatePosition(), (double)201.0, (double)0.0);
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{t1}, 12.0);
        Assert.assertEquals((Object)transform.getName().toString(), (Object)t1.getName().toString());
        Assert.assertEquals((double)transform.getApproximateDomainRange().getMin().doubleValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((double)transform.getApproximateDomainRange().getMax().doubleValue(), (double)2.0, (double)0.0);
        Assert.assertEquals((double)transform.transform(1.5), (double)201.0, (double)0.0);
        Assert.assertEquals((double)transform.transform(new Position(1.5), null).getOrdinatePosition(), (double)201.0, (double)0.0);
        Assert.assertEquals((double)transform.transform(2.5), (double)0.0, (double)12.0);
        try {
            transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"", (Range)RangeFactory.create((int)0, (int)100), (Range)RangeFactory.create((double)Double.NEGATIVE_INFINITY, (double)Double.POSITIVE_INFINITY))});
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void passthroughTransform() throws IOException, TransformException, TransformationException {
        DefaultPassthroughPiecewiseTransform1DElement p0 = new DefaultPassthroughPiecewiseTransform1DElement((CharSequence)"p0", RangeFactory.create((double)0.0, (boolean)true, (double)1.0, (boolean)true));
        Assert.assertEquals((long)p0.getTargetDimensions(), (long)1L);
        Assert.assertEquals((long)p0.getSourceDimensions(), (long)1L);
        Assert.assertTrue((boolean)p0.isIdentity());
        Assert.assertEquals((Object)p0.inverse(), (Object)SingleDimensionTransformation.IDENTITY);
        Assert.assertEquals((double)p0.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p0.transform(new Position(0.5), null).getOrdinatePosition(), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p0.inverse().transform(new Position(0.5), null).getOrdinatePosition(), (double)0.5, (double)0.0);
        Position inDP = new Position(0.6);
        Position outDP = p0.transform(inDP, null);
        Assert.assertTrue((outDP.getOrdinatePosition() == 0.6 ? 1 : 0) != 0);
        DefaultPiecewiseTransform1D piecewise = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{p0}, 11.0);
        Assert.assertEquals((double)piecewise.getApproximateDomainRange().getMin().doubleValue(), (double)0.0, (double)0.0);
        Assert.assertEquals((double)piecewise.getApproximateDomainRange().getMax().doubleValue(), (double)1.0, (double)0.0);
        Assert.assertEquals((double)piecewise.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)piecewise.transform(new Position(0.5), null).getOrdinatePosition(), (double)0.5, (double)0.0);
        Assert.assertEquals((double)piecewise.transform(1.5), (double)0.0, (double)11.0);
        DefaultPassthroughPiecewiseTransform1DElement p1 = new DefaultPassthroughPiecewiseTransform1DElement((CharSequence)"p1");
        Assert.assertEquals((long)p1.getTargetDimensions(), (long)1L);
        Assert.assertEquals((long)p1.getSourceDimensions(), (long)1L);
        Assert.assertTrue((boolean)p1.isIdentity());
        Assert.assertEquals((Object)p1.inverse(), (Object)SingleDimensionTransformation.IDENTITY);
        Assert.assertEquals((double)p1.transform(0.5), (double)0.5, (double)0.0);
        Assert.assertEquals((double)p1.transform(111.5), (double)111.5, (double)0.0);
        Assert.assertEquals((double)p1.transform(new Position(123.5), null).getOrdinatePosition(), (double)123.5, (double)0.0);
        Assert.assertEquals((double)p1.inverse().transform(new Position(657.5), null).getOrdinatePosition(), (double)657.5, (double)0.0);
        Position inDP1 = new Position(0.6);
        Position outDP1 = p1.transform(inDP1, null);
        Assert.assertTrue((outDP1.getOrdinatePosition() == 0.6 ? 1 : 0) != 0);
    }

    @Test
    public void lookupByte() throws IOException, TransformException {
        RenderedImage image = new ImageWorker((RenderedImage)JAI.create((String)"ImageRead", (Object)TestData.file((Object)this, (String)"usa.png"))).forceComponentColorModel().retainFirstBand().getRenderedImage();
        if (TestData.isInteractiveTest()) {
            ImageIOUtilities.visualize((RenderedImage)image, (String)"testLookupByte");
        }
        DefaultPiecewiseTransform1DElement c1 = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"c1", (Range)RangeFactory.create((int)1, (int)128), (Range)RangeFactory.create((int)1, (int)255));
        DefaultPiecewiseTransform1DElement c0 = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"c0", (Range)RangeFactory.create((int)129, (int)255), (Range)RangeFactory.create((int)255, (int)255));
        DefaultPiecewiseTransform1DElement nodata = DefaultLinearPiecewiseTransform1DElement.create((CharSequence)"nodata", (Range)RangeFactory.create((int)0, (int)0), (int)0);
        DefaultPiecewiseTransform1D list = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{c0, c1, nodata});
        ImageWorker w = new ImageWorker(image);
        RenderedOp finalimage = w.piecewise((PiecewiseTransform1D)list, null).getRenderedOperation();
        if (TestData.isInteractiveTest()) {
            ImageIOUtilities.visualize((RenderedImage)finalimage, (String)"testLookupByte");
        } else {
            finalimage.getTiles();
        }
    }

    @Test
    public void SWANLOGARITHMIC() throws IOException {
        RenderedImage image = this.getSWAN();
        if (TestData.isInteractiveTest()) {
            ImageIOUtilities.visualize((RenderedImage)image, (String)"testSWANLOGARITHMIC");
        }
        ImageWorker w = new ImageWorker(image).setROI(new ROI(new ImageWorker(image).binarize(0.0).getRenderedImage()));
        final double[] minimum = w.getMinimums();
        final double[] maximum = w.getMaximums();
        DefaultPiecewiseTransform1DElement mainElement = new DefaultPiecewiseTransform1DElement((CharSequence)"natural logarithm", RangeFactory.create((double)minimum[0], (double)maximum[0]), (MathTransformation)new MathTransformationAdapter(){

            public double derivative(double arg0) throws TransformException {
                return 1.0 / arg0;
            }

            public double transform(double arg0) {
                return minimum[0] + 1.2 * Math.log(arg0 / minimum[0]) * ((maximum[0] - minimum[0]) / Math.log(maximum[0] / minimum[0]));
            }

            public boolean isIdentity() {
                return false;
            }
        });
        DefaultPiecewiseTransform1D transform = new DefaultPiecewiseTransform1D(new DefaultPiecewiseTransform1DElement[]{mainElement}, 0.0);
        boolean exceptionThrown = false;
        try {
            RenderedOp d = w.piecewise((PiecewiseTransform1D)transform, Integer.valueOf(2)).getRenderedOperation();
            d.getTiles();
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((boolean)exceptionThrown);
        RenderedOp finalImage = w.piecewise((PiecewiseTransform1D)transform, Integer.valueOf(0)).getRenderedOperation();
        if (TestData.isInteractiveTest()) {
            ImageIOUtilities.visualize((RenderedImage)finalImage, (String)"testSWANLOGARITHMIC");
        } else {
            finalImage.getTiles();
        }
        finalImage.dispose();
    }

    private RenderedImage getSWAN() throws IOException, FileNotFoundException {
        AsciiGridsImageReader reader = (AsciiGridsImageReader)new AsciiGridsImageReaderSpi().createReaderInstance();
        reader.setInput((Object)new FileImageInputStream(TestData.file((Object)this, (String)"arcgrid/SWAN_NURC_LigurianSeaL07_HSIGN.asc")));
        RenderedImage image = reader.readAsRenderedImage(0, null);
        return image;
    }

    @Before
    public void setUp() throws Exception {
        try {
            new ParameterBlockJAI("GenericPiecewise");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = TestData.copy((Object)this, (String)"arcgrid/arcgrid.zip");
        Assert.assertTrue((boolean)file.exists());
        TestData.unzipFile((Object)this, (String)"arcgrid/arcgrid.zip");
    }
}

