/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReprojectionTest
extends TestCase {
    private SimpleFeatureType pointFeautureType;
    private GeometryFactory gf = new GeometryFactory();
    protected int errors;

    protected void setUp() throws Exception {
        super.setUp();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Lines");
        builder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.pointFeautureType = builder.buildFeatureType();
    }

    public SimpleFeatureCollection createLineCollection() throws Exception {
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(this.createLine(-177.0, 0.0, -177.0, 10.0));
        fc.add(this.createLine(-177.0, 0.0, -200.0, 0.0));
        fc.add(this.createLine(-177.0, 0.0, -177.0, 100.0));
        return fc;
    }

    private SimpleFeature createLine(double x1, double y1, double x2, double y2) throws IllegalAttributeException {
        Coordinate[] coords = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y2)};
        return SimpleFeatureBuilder.build((SimpleFeatureType)this.pointFeautureType, (Object[])new Object[]{this.gf.createLineString(coords)}, null);
    }

    private Style createLineStyle() {
        StyleBuilder sb = new StyleBuilder();
        return sb.createStyle((Symbolizer)sb.createLineSymbolizer());
    }

    public void testSkipProjectionErrors() throws Exception {
        MapContent MapContent2 = new MapContent();
        MapContent2.addLayer((Layer)new FeatureLayer((FeatureCollection)this.createLineCollection(), this.createLineStyle()));
        ReferencedEnvelope reWgs = new ReferencedEnvelope(new Envelope(-180.0, -170.0, 20.0, 40.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem utm1N = CRS.decode((String)"EPSG:32601");
        ReferencedEnvelope reUtm = reWgs.transform(utm1N, true);
        BufferedImage image = new BufferedImage(200, 200, 6);
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(MapContent2);
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                ++ReprojectionTest.this.errors;
            }
        });
        this.errors = 0;
        sr.paint((Graphics2D)image.getGraphics(), new Rectangle(200, 200), reUtm);
        MapContent2.dispose();
        ReprojectionTest.assertEquals((int)1, (int)this.errors);
    }
}

