/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.test.TestData;
import org.geotools.util.logging.Logging;
import org.geotools.xml.styling.SLDParser;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.style.Fill;
import org.opengis.style.Graphic;

public class Rendering2DTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger(Rendering2DTest.class);
    private final int xCenter = -74;
    private final int yCenter = 41;
    static final String LINE = "linefeature";
    static final String POLYGON = "polygonfeature";
    static final String POINT = "pointfeature";
    static final String RING = "ringfeature";
    static final String COLLECTION = "collfeature";
    protected static final Map rendererHints = new HashMap();
    protected static final FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public Rendering2DTest(String testName) {
        super(testName);
        rendererHints.put("optimizedDataLoadingEnabled", true);
    }

    Style loadTestStyle() throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory(null);
        URL surl = TestData.getResource((Object)((Object)this), (String)"test-sld.xml");
        SLDParser stylereader = new SLDParser(factory, surl);
        StyledLayerDescriptor sld = stylereader.parseSLD();
        UserLayer layer = (UserLayer)sld.getStyledLayers()[0];
        return layer.getUserStyles()[0];
    }

    Style createTestStyle() throws IllegalFilterException {
        StyleFactory sFac = CommonFactoryFinder.getStyleFactory(null);
        PointSymbolizer pointsym = sFac.createPointSymbolizer();
        pointsym.setGraphic((Graphic)sFac.getDefaultGraphic());
        Rule rule = sFac.createRule();
        rule.symbolizers().add(this.polysym(sFac));
        FeatureTypeStyle fts = sFac.createFeatureTypeStyle(new Rule[]{rule});
        fts.featureTypeNames().add(new NameImpl(POLYGON));
        Rule rule1 = sFac.createRule();
        rule.symbolizers().add(this.polysym(sFac));
        FeatureTypeStyle fts1 = sFac.createFeatureTypeStyle(new Rule[]{rule1});
        fts1.featureTypeNames().add(new NameImpl(POLYGON));
        Rule rule2 = sFac.createRule();
        rule2.symbolizers().add(this.linesym(sFac));
        FeatureTypeStyle fts2 = sFac.createFeatureTypeStyle();
        fts2.rules().add(rule2);
        fts2.featureTypeNames().add(new NameImpl(LINE));
        Rule rule3 = sFac.createRule();
        rule3.symbolizers().add(pointsym);
        FeatureTypeStyle fts3 = sFac.createFeatureTypeStyle();
        fts3.rules().add(rule3);
        fts3.featureTypeNames().add(new NameImpl(POINT));
        Rule rule4 = sFac.createRule();
        rule4.symbolizers().addAll(Arrays.asList(this.polysym(sFac), this.linesym(sFac)));
        FeatureTypeStyle fts4 = sFac.createFeatureTypeStyle();
        fts4.rules().add(rule4);
        fts4.featureTypeNames().add(new NameImpl("collFeature"));
        Rule rule5 = sFac.createRule();
        rule5.symbolizers().add(this.linesym(sFac));
        FeatureTypeStyle fts5 = sFac.createFeatureTypeStyle();
        fts5.rules().add(rule5);
        fts5.featureTypeNames().add(new NameImpl("ringFeature"));
        Style style = sFac.createStyle();
        style.featureTypeStyles().addAll(Arrays.asList(fts1, fts, fts2, fts3, fts4, fts5));
        return style;
    }

    private LineSymbolizer linesym(StyleFactory sFac) throws IllegalFilterException {
        LineSymbolizer linesym = sFac.createLineSymbolizer();
        Stroke myStroke = sFac.getDefaultStroke();
        myStroke.setColor((Expression)filterFactory.literal((Object)"#0000ff"));
        myStroke.setWidth((Expression)filterFactory.literal((Object)5));
        LOGGER.fine("got new Stroke " + myStroke);
        linesym.setStroke((org.opengis.style.Stroke)myStroke);
        return linesym;
    }

    private PolygonSymbolizer polysym(StyleFactory sFac) throws IllegalFilterException {
        PolygonSymbolizer polysym = sFac.createPolygonSymbolizer();
        org.geotools.styling.Fill myFill = sFac.getDefaultFill();
        myFill.setColor((Expression)filterFactory.literal((Object)"#ff0000"));
        polysym.setFill((Fill)myFill);
        Stroke myStroke = sFac.getDefaultStroke();
        myStroke.setColor((Expression)filterFactory.literal((Object)"#0000ff"));
        myStroke.setWidth((Expression)filterFactory.literal((Object)2));
        polysym.setStroke((org.opengis.style.Stroke)myStroke);
        return polysym;
    }

    private PolygonSymbolizer polysym1(StyleFactory sFac) throws IllegalFilterException {
        PolygonSymbolizer polysym = sFac.createPolygonSymbolizer();
        org.geotools.styling.Fill myFill = sFac.getDefaultFill();
        myFill.setColor((Expression)filterFactory.literal((Object)"#00ff00"));
        polysym.setFill((Fill)myFill);
        Stroke myStroke = sFac.getDefaultStroke();
        myStroke.setColor((Expression)filterFactory.literal((Object)"#00ff00"));
        myStroke.setWidth((Expression)filterFactory.literal((Object)2));
        polysym.setStroke((org.opengis.style.Stroke)myStroke);
        return polysym;
    }

    SimpleFeatureCollection createTestFeatureCollection(CoordinateReferenceSystem crs, String typeName) throws Exception {
        GeometryFactory geomFac = new GeometryFactory();
        return this.createTestFeatureCollection(crs, geomFac, typeName);
    }

    SimpleFeatureCollection createTestFeatureCollection(CoordinateReferenceSystem crs, GeometryFactory geomFac, String typeName) throws Exception {
        LineString line = this.makeSampleLineString(geomFac);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(LINE);
        if (crs != null) {
            builder.add("collection", line.getClass(), crs);
        } else {
            builder.add("centerline", line.getClass());
        }
        builder.add("name", String.class);
        SimpleFeatureType lineType = builder.buildFeatureType();
        SimpleFeature lineFeature = SimpleFeatureBuilder.build((SimpleFeatureType)lineType, (Object[])new Object[]{line, "centerline"}, null);
        Polygon polygon = this.makeSamplePolygon(geomFac);
        builder.setName(POLYGON);
        if (crs != null) {
            builder.add("collection", polygon.getClass(), crs);
        } else {
            builder.add("edge", polygon.getClass());
        }
        builder.add("name", String.class);
        SimpleFeatureType polygonType = builder.buildFeatureType();
        SimpleFeature polygonFeature = SimpleFeatureBuilder.build((SimpleFeatureType)polygonType, (Object[])new Object[]{polygon, "edge"}, null);
        Point point = this.makeSamplePoint(geomFac);
        builder.setName(POINT);
        if (crs != null) {
            builder.add("collection", point.getClass(), crs);
        } else {
            builder.add("centre", point.getClass());
        }
        builder.add("name", String.class);
        SimpleFeatureType pointType = builder.buildFeatureType();
        SimpleFeature pointFeature = SimpleFeatureBuilder.build((SimpleFeatureType)pointType, (Object[])new Object[]{point, "centre"}, null);
        LinearRing ring = this.makeSampleLinearRing(geomFac);
        builder.setName(RING);
        if (crs != null) {
            builder.add("collection", line.getClass(), crs);
        } else {
            builder.add("centerline", line.getClass());
        }
        builder.add("name", String.class);
        SimpleFeatureType lrType = builder.buildFeatureType();
        SimpleFeature ringFeature = SimpleFeatureBuilder.build((SimpleFeatureType)lrType, (Object[])new Object[]{ring, "centerline"}, null);
        GeometryCollection coll = this.makeSampleGeometryCollection(geomFac);
        builder.setName(COLLECTION);
        if (crs != null) {
            builder.add("collection", coll.getClass(), crs);
        } else {
            builder.add("collection", coll.getClass());
        }
        builder.add("name", String.class);
        SimpleFeatureType collType = builder.buildFeatureType();
        SimpleFeature collFeature = SimpleFeatureBuilder.build((SimpleFeatureType)collType, (Object[])new Object[]{coll, "collection"}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(lineFeature);
        data.addFeature(polygonFeature);
        data.addFeature(pointFeature);
        data.addFeature(ringFeature);
        data.addFeature(collFeature);
        return data.getFeatureSource(typeName).getFeatures();
    }

    public void testSimplePolygonRender() throws Exception {
        LOGGER.finer("starting rendering2DTest");
        SimpleFeatureCollection ft = this.createTestFeatureCollection((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, POLYGON);
        Style style = this.createTestStyle();
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)ft, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        renderer.setRendererHints(rendererHints);
        RendererBaseTest.showRender("testSimplePolygonRender", (GTRenderer)renderer, 1000L, map.getMaxBounds());
    }

    public void testSimpleLineRender() throws Exception {
        SimpleFeatureCollection ft = this.createTestFeatureCollection((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, LINE);
        Style style = this.createTestStyle();
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)ft, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        renderer.setRendererHints(rendererHints);
        ReferencedEnvelope env = map.getMaxBounds();
        env = new ReferencedEnvelope(env.getMinX() - 20.0, env.getMaxX() + 20.0, env.getMinY() - 20.0, env.getMaxY() + 20.0, map.getCoordinateReferenceSystem());
        RendererBaseTest.showRender("testSimpleLineRender", (GTRenderer)renderer, 1000L, env);
    }

    public void testSimplePointRender() throws Exception {
        SimpleFeatureCollection ft = this.createTestFeatureCollection((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, POINT);
        Style style = this.createTestStyle();
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)ft, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        renderer.setRendererHints(rendererHints);
        ReferencedEnvelope env = map.getMaxBounds();
        env = new ReferencedEnvelope(env.getMinX() - 20.0, env.getMaxX() + 20.0, env.getMinY() - 20.0, env.getMaxY() + 20.0, map.getCoordinateReferenceSystem());
        RendererBaseTest.showRender("testSimplePointRender", (GTRenderer)renderer, 1000L, env);
    }

    public void testReprojectionWithPackedCoordinateSequence() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("starting testLiteRender2").append("\n");
        GeometryFactory geomFac = new GeometryFactory((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY);
        SimpleFeatureCollection ft = this.createTestFeatureCollection((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, geomFac, POLYGON);
        Style style = this.createTestStyle();
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)ft, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        renderer.setRendererHints(rendererHints);
        CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"NAD83 / BCAlbers\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_parallel_1\",50],PARAMETER[\"standard_parallel_2\",58.5],PARAMETER[\"latitude_of_center\",45],PARAMETER[\"longitude_of_center\",-126],PARAMETER[\"false_easting\",1000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3005\"]]");
        MathTransform t = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)crs, (boolean)true);
        ReferencedEnvelope env = map.getMaxBounds();
        ReferencedEnvelope bounds = new ReferencedEnvelope(JTS.transform((Envelope)env, null, (MathTransform)t, (int)10), crs);
        RendererBaseTest.showRender("testReprojection", (GTRenderer)renderer, 1000L, bounds);
        LOGGER.finer(stringBuffer.toString());
    }

    public void testLineReprojection() throws Exception {
        LOGGER.finer("starting testLiteRender2");
        GeometryFactory geomFac = new GeometryFactory((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY);
        SimpleFeatureCollection ft = this.createTestFeatureCollection((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, geomFac, LINE);
        Style style = this.createTestStyle();
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)ft, style));
        CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"NAD83 / BCAlbers\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_parallel_1\",50],PARAMETER[\"standard_parallel_2\",58.5],PARAMETER[\"latitude_of_center\",45],PARAMETER[\"longitude_of_center\",-126],PARAMETER[\"false_easting\",1000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3005\"]]");
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setRendererHints(rendererHints);
        renderer.setMapContent(map);
        ReferencedEnvelope env = map.getMaxBounds();
        env = new ReferencedEnvelope(env.getMinX() - 20.0, env.getMaxX() + 20.0, env.getMinY() - 20.0, env.getMaxY() + 20.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope newbounds = env.transform(crs, true);
        RendererBaseTest.showRender("testLineReprojection", (GTRenderer)renderer, 1000L, newbounds);
    }

    public void testPointReprojection() throws Exception {
        LOGGER.finer("starting testLiteRender2");
        GeometryFactory geomFac = new GeometryFactory((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY);
        SimpleFeatureCollection ft = this.createTestFeatureCollection((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, geomFac, POINT);
        Style style = this.createTestStyle();
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)ft, style));
        CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"NAD83 / BCAlbers\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_parallel_1\",50],PARAMETER[\"standard_parallel_2\",58.5],PARAMETER[\"latitude_of_center\",45],PARAMETER[\"longitude_of_center\",-126],PARAMETER[\"false_easting\",1000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3005\"]]");
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setRendererHints(rendererHints);
        renderer.setMapContent(map);
        ReferencedEnvelope env = map.getMaxBounds();
        env = new ReferencedEnvelope(env.getMinX() - 20.0, env.getMaxX() + 20.0, env.getMinY() - 20.0, env.getMaxY() + 20.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ReferencedEnvelope newbounds = env.transform(crs, true);
        RendererBaseTest.showRender("testPointReprojection", (GTRenderer)renderer, 1000L, newbounds);
    }

    public void testDefinitionQueryProcessing() throws Exception {
    }

    public void testDefinitionQuerySLDProcessing() throws Exception {
    }

    private SimpleFeatureCollection createTestDefQueryFeatureCollection() throws Exception {
        MemoryDataStore data = new MemoryDataStore();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("querytest");
        builder.add("id", String.class);
        builder.add("point", Point.class);
        builder.add("line", LineString.class);
        builder.add("polygon", Polygon.class);
        SimpleFeatureType type = builder.buildFeatureType();
        GeometryFactory gf = new GeometryFactory();
        LineString l = this.line(gf, new int[]{20, 20, 100, 20, 100, 100});
        Polygon p = (Polygon)l.convexHull();
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"ft1", this.point(gf, 20, 20), l, p}, (String)"test.1");
        data.addFeature(f);
        l = this.line(gf, new int[]{130, 130, 110, 110, 110, 130, 30, 130});
        p = (Polygon)l.convexHull();
        f = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"ft2", this.point(gf, 130, 130), l, p}, (String)"test.2");
        data.addFeature(f);
        l = this.line(gf, new int[]{150, 150, 190, 140, 190, 190});
        p = (Polygon)l.convexHull();
        f = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{"ft3", this.point(gf, 150, 150), l, p}, (String)"test.3");
        data.addFeature(f);
        String typeName = type.getTypeName();
        return data.getFeatureSource(typeName).getFeatures();
    }

    private Style createDefQueryTestStyle() throws IllegalFilterException {
        StyleFactory sFac = CommonFactoryFinder.getStyleFactory();
        PointSymbolizer pointsym = sFac.createPointSymbolizer();
        pointsym.setGraphic((Graphic)sFac.getDefaultGraphic());
        pointsym.setGeometryPropertyName("point");
        Rule rulep = sFac.createRule();
        rulep.symbolizers().add(pointsym);
        FeatureTypeStyle ftsP = sFac.createFeatureTypeStyle();
        ftsP.rules().add(rulep);
        ftsP.featureTypeNames().add(new NameImpl("querytest"));
        LineSymbolizer linesym = sFac.createLineSymbolizer();
        linesym.setGeometryPropertyName("line");
        Stroke myStroke = sFac.getDefaultStroke();
        myStroke.setColor((Expression)filterFactory.literal((Object)"#0000ff"));
        myStroke.setWidth((Expression)filterFactory.literal((Object)3));
        LOGGER.info("got new Stroke " + myStroke);
        linesym.setStroke((org.opengis.style.Stroke)myStroke);
        Rule rule2 = sFac.createRule();
        rule2.symbolizers().add(linesym);
        FeatureTypeStyle ftsL = sFac.createFeatureTypeStyle();
        ftsL.rules().add(rule2);
        ftsL.featureTypeNames().add(new NameImpl("querytest"));
        PolygonSymbolizer polysym = sFac.createPolygonSymbolizer();
        polysym.setGeometryPropertyName("polygon");
        org.geotools.styling.Fill myFill = sFac.getDefaultFill();
        myFill.setColor((Expression)filterFactory.literal((Object)"#ff0000"));
        polysym.setFill((Fill)myFill);
        polysym.setStroke((org.opengis.style.Stroke)sFac.getDefaultStroke());
        Rule rule = sFac.createRule();
        rule.symbolizers().add(polysym);
        FeatureTypeStyle ftsPoly = sFac.createFeatureTypeStyle(new Rule[]{rule});
        ftsPoly.featureTypeNames().add(new NameImpl("querytest"));
        Style style = sFac.createStyle();
        style.featureTypeStyles().addAll(Arrays.asList(ftsPoly, ftsL, ftsP));
        return style;
    }

    public LineString line(GeometryFactory gf, int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
        }
        return gf.createLineString(coords);
    }

    public Point point(GeometryFactory gf, int x, int y) {
        Coordinate coord = new Coordinate((double)x, (double)y);
        return gf.createPoint(coord);
    }

    private Point makeSamplePoint(GeometryFactory geomFac) {
        Coordinate c = new Coordinate(-88.0, 27.0);
        Point point = geomFac.createPoint(c);
        return point;
    }

    private LineString makeSampleLineString(GeometryFactory geomFac) {
        Coordinate[] linestringCoordinates = new Coordinate[]{new Coordinate(-79.0, 36.0), new Coordinate(-80.0, 36.0), new Coordinate(-80.0, 35.0), new Coordinate(-81.0, 35.0), new Coordinate(-81.0, 34.0), new Coordinate(-82.0, 34.0), new Coordinate(-82.0, 33.0)};
        LineString line = geomFac.createLineString(linestringCoordinates);
        return line;
    }

    private Polygon makeSamplePolygon(GeometryFactory geomFac) {
        Coordinate[] polygonCoordinates = new Coordinate[]{new Coordinate(-81.0, 34.0), new Coordinate(-80.0, 32.0), new Coordinate(-80.0, 30.0), new Coordinate(-81.0, 29.0), new Coordinate(-83.0, 30.0), new Coordinate(-85.0, 29.0), new Coordinate(-87.0, 30.0), new Coordinate(-87.0, 32.0), new Coordinate(-85.0, 34.0), new Coordinate(-81.0, 34.0)};
        try {
            LinearRing ring = geomFac.createLinearRing(polygonCoordinates);
            Polygon polyg = geomFac.createPolygon(ring, null);
            return polyg;
        }
        catch (TopologyException te) {
            Rendering2DTest.fail((String)("Error creating sample polygon for testing " + (Object)((Object)te)));
            return null;
        }
    }

    private GeometryCollection makeSampleGeometryCollection(GeometryFactory geomFac) {
        try {
            Geometry polyg = this.buildShiftedGeometry((Geometry)this.makeSamplePolygon(geomFac), 50.0, 50.0);
            Geometry lineString = this.buildShiftedGeometry((Geometry)this.makeSampleLineString(geomFac), 50.0, 50.0);
            return geomFac.createGeometryCollection(new Geometry[]{polyg, lineString});
        }
        catch (TopologyException te) {
            Rendering2DTest.fail((String)("Error creating sample polygon for testing " + (Object)((Object)te)));
            return null;
        }
    }

    private LinearRing makeSampleLinearRing(GeometryFactory geomFac) {
        try {
            Polygon polyg = (Polygon)this.buildShiftedGeometry((Geometry)this.makeSamplePolygon(geomFac), 0.0, 100.0);
            return polyg.getExteriorRing();
        }
        catch (TopologyException te) {
            Rendering2DTest.fail((String)("Error creating sample polygon for testing " + (Object)((Object)te)));
            return null;
        }
    }

    private Geometry buildShiftedGeometry(Geometry g, double shiftX, double shiftY) {
        Geometry clone = g.copy();
        for (Coordinate coord : clone.getCoordinates()) {
            coord.x += shiftX;
            coord.y += shiftY;
        }
        return clone;
    }

    public void testScaleCalc() throws Exception {
        CoordinateReferenceSystem crs = CRS.parseWKT((String)"PROJCS[\"NAD83 / BCAlbers\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"standard_parallel_1\",50],PARAMETER[\"standard_parallel_2\",58.5],PARAMETER[\"latitude_of_center\",45],PARAMETER[\"longitude_of_center\",-126],PARAMETER[\"false_easting\",1000000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AUTHORITY[\"EPSG\",\"3005\"]]");
        ReferencedEnvelope envelope = new ReferencedEnvelope(1388422.8746916912, 1407342.5139777814, 639551.3924667438, 650162.715579435, crs);
        double s = RendererUtilities.calculateScale((ReferencedEnvelope)envelope, (int)655, (int)368, (double)90.0);
        LOGGER.info(Double.toString(s));
    }

    public void testRenderEmptyLine() throws SchemaException, IllegalAttributeException {
        GeometryFactory gf = new GeometryFactory();
        StyleBuilder sb = new StyleBuilder();
        SimpleFeatureType pointType = DataUtilities.createType((String)"emptyLines", (String)"geom:LineString,name:String");
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)pointType, (Object[])new Object[]{gf.createLineString((Coordinate[])null), "name"}, null);
        Style style = sb.createStyle((Symbolizer)sb.createLineSymbolizer());
        this.renderEmptyGeometry(f, style);
    }

    public void testRenderEmptyCollection() throws SchemaException, IllegalAttributeException {
        GeometryFactory gf = new GeometryFactory();
        StyleBuilder sb = new StyleBuilder();
        SimpleFeatureType pointType = DataUtilities.createType((String)"emptyPolygon", (String)"geom:MultiPolygon,name:String");
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)pointType, (Object[])new Object[]{gf.createMultiPolygon((Polygon[])null), "name"}, null);
        Style style = sb.createStyle((Symbolizer)sb.createPolygonSymbolizer());
        this.renderEmptyGeometry(f, style);
    }

    public void testRenderCollectionWithEmptyItems() throws SchemaException, IllegalAttributeException {
        GeometryFactory gf = new GeometryFactory();
        StyleBuilder sb = new StyleBuilder();
        SimpleFeatureType pointType = DataUtilities.createType((String)"emptyPolygon", (String)"geom:MultiPolygon,name:String");
        Polygon p1 = gf.createPolygon(gf.createLinearRing((Coordinate[])null), null);
        Polygon p2 = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, 0.0), new Coordinate(0.0, 0.0)}), null);
        MultiPolygon mp = gf.createMultiPolygon(new Polygon[]{p1, p2});
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)pointType, (Object[])new Object[]{mp, "name"}, null);
        Style style = sb.createStyle((Symbolizer)sb.createPolygonSymbolizer());
        this.renderEmptyGeometry(f, style);
    }

    public void testRenderPolygonEmptyRings() throws SchemaException, IllegalAttributeException {
        GeometryFactory gf = new GeometryFactory();
        StyleBuilder sb = new StyleBuilder();
        SimpleFeatureType pointType = DataUtilities.createType((String)"emptyRings", (String)"geom:MultiPolygon,name:String");
        LinearRing emptyRing = gf.createLinearRing((Coordinate[])null);
        LinearRing realRing = gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, 0.0), new Coordinate(0.0, 0.0)});
        Polygon p1 = gf.createPolygon(realRing, new LinearRing[]{emptyRing});
        Polygon p2 = gf.createPolygon(emptyRing, new LinearRing[]{emptyRing});
        MultiPolygon mp = gf.createMultiPolygon(new Polygon[]{p1, p2});
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)pointType, (Object[])new Object[]{mp, "name"}, null);
        Style style = sb.createStyle((Symbolizer)sb.createPolygonSymbolizer());
        this.renderEmptyGeometry(f, style);
    }

    public void testMixedEmptyMultiLine() throws SchemaException, IllegalAttributeException {
        GeometryFactory gf = new GeometryFactory();
        StyleBuilder sb = new StyleBuilder();
        SimpleFeatureType pointType = DataUtilities.createType((String)"emptyRings", (String)"geom:MultiLineString,name:String");
        LineString emptyLine = gf.createLineString((Coordinate[])null);
        LineString realLine = gf.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0)});
        MultiLineString mls = gf.createMultiLineString(new LineString[]{emptyLine, realLine});
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)pointType, (Object[])new Object[]{mls, "name"}, null);
        Style style = sb.createStyle((Symbolizer)sb.createPolygonSymbolizer());
        this.renderEmptyGeometry(f, style);
    }

    private void renderEmptyGeometry(SimpleFeature f, Style style) {
        SimpleFeatureCollection fc = DataUtilities.collection((SimpleFeature)f);
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureCollection)fc, style));
        StreamingRenderer sr = new StreamingRenderer();
        sr.setMapContent(mc);
        BufferedImage bi = new BufferedImage(640, 480, 6);
        sr.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                Logger.getGlobal().log(Level.INFO, "", e);
                TestCase.fail((String)"Got an exception during rendering, this should not happen, not even with emtpy geometries");
            }
        });
        sr.paint((Graphics2D)bi.getGraphics(), new Rectangle(640, 480), new ReferencedEnvelope(new Envelope(0.0, 10.0, 0.0, 10.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        mc.dispose();
    }
}

