/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.File;
import java.lang.constant.Constable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class QueryOptimizeTest
extends TestCase {
    private static final long TIME = 2000L;
    SimpleFeatureSource squareFS;
    ReferencedEnvelope bounds;
    StreamingRenderer renderer;
    MapContent context;
    int count = 0;

    protected void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)((Object)this), (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.squareFS = ds.getFeatureSource("square");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer = new StreamingRenderer();
        this.context = new MapContent();
        this.renderer.setMapContent(this.context);
        HashMap<String, Constable> hints = new HashMap<String, Constable>();
        hints.put("maxFiltersToSendToDatastore", Integer.valueOf(2));
        hints.put("optimizedDataLoadingEnabled", Boolean.valueOf(true));
        this.renderer.setRendererHints(hints);
    }

    public void testLessFilters() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "fillSolidTwoRules.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.squareFS, style));
        this.renderer.setMapContent(mc);
        this.renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++QueryOptimizeTest.this.count;
            }

            public void errorOccurred(Exception e) {
            }
        });
        RendererBaseTest.showRender("OneSquare", (GTRenderer)this.renderer, 2000L, this.bounds);
        QueryOptimizeTest.assertEquals((int)2, (int)this.count);
    }
}

