/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import org.geotools.data.DataTestCase;
import org.geotools.filter.function.EnvFunction;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.junit.Test;
import org.opengis.feature.Feature;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.NilExpression;

public class MetaBufferEstimatorTest
extends DataTestCase {
    public MetaBufferEstimatorTest(String name) {
        super(name);
    }

    @Test
    public void testExternalGraphic() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "externalGraphic.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)48, (int)estimator.getBuffer());
    }

    @Test
    public void testExternalGraphicRectangleResized() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "externalGraphicRectImage.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)32, (int)estimator.getBuffer());
    }

    @Test
    public void testExternalGraphicNoSize() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "externalGraphicNoSize.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)64, (int)estimator.getBuffer());
    }

    @Test
    public void testMark() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "markCircle.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)32, (int)estimator.getBuffer());
    }

    @Test
    public void testThinLine() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineGray.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)1, (int)estimator.getBuffer());
    }

    @Test
    public void testThickLine() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineThick.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)4, (int)estimator.getBuffer());
    }

    @Test
    public void testGraphicStroke() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineRailway.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)10, (int)estimator.getBuffer());
    }

    @Test
    public void testPolygon() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "polygon.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)1, (int)estimator.getBuffer());
    }

    @Test
    public void testLabelShields() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textLabelShield.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)32, (int)estimator.getBuffer());
    }

    @Test
    public void testDynamicSize() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "externalGraphicDynamicSize.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertFalse((boolean)estimator.isEstimateAccurate());
    }

    @Test
    public void testInlineContent() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "base64.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)16, (int)estimator.getBuffer());
    }

    @Test
    public void testMarkNoSizeNoStroke() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Mark mark = sb.createMark("square");
        mark.setStroke(null);
        Graphic graphic = sb.createGraphic(null, mark, null);
        graphic.setSize(NilExpression.NIL);
        PointSymbolizer ps = sb.createPointSymbolizer(graphic);
        Style style = sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)16, (int)estimator.getBuffer());
    }

    @Test
    public void testMarkStroke() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Mark mark = sb.createMark("square");
        mark.getStroke().setWidth((Expression)sb.getFilterFactory().literal(10));
        Graphic graphic = sb.createGraphic(null, mark, null);
        graphic.setSize(NilExpression.NIL);
        PointSymbolizer ps = sb.createPointSymbolizer(graphic);
        Style style = sb.createStyle((Symbolizer)ps);
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)26, (int)estimator.getBuffer());
    }

    @Test
    public void testNullStroke() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        LineSymbolizer ls = sb.createLineSymbolizer(Stroke.NULL);
        Style style = sb.createStyle((Symbolizer)ls);
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)0, (int)estimator.getBuffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGraphicSizeFunction() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Mark mark = sb.createMark("square");
        mark.setStroke(null);
        Graphic graphic = sb.createGraphic(null, mark, null);
        FilterFactory2 ff = sb.getFilterFactory();
        graphic.setSize((Expression)ff.function("env", new Expression[]{ff.literal((Object)"test")}));
        PointSymbolizer ps = sb.createPointSymbolizer(graphic);
        Style style = sb.createStyle((Symbolizer)ps);
        try {
            EnvFunction.setGlobalValue((String)"test", (Object)10);
            MetaBufferEstimator estimator = new MetaBufferEstimator();
            style.accept((StyleVisitor)estimator);
            MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
            MetaBufferEstimatorTest.assertEquals((int)10, (int)estimator.getBuffer());
        }
        finally {
            EnvFunction.clearGlobalValues();
        }
    }

    @Test
    public void testMultiScript() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "multiscript/textMultiScriptLine.sld");
        MetaBufferEstimator estimator = new MetaBufferEstimator();
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)16, (int)estimator.getBuffer());
    }

    @Test
    public void testFeatureBound() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        LineSymbolizer ls = sb.createLineSymbolizer(Color.BLUE);
        ls.getStroke().setWidth((Expression)this.ff.multiply((Expression)this.ff.literal(2), (Expression)this.ff.property("flow")));
        Style style = sb.createStyle((Symbolizer)ls);
        MetaBufferEstimator estimator = new MetaBufferEstimator((Feature)this.riverFeatures[0]);
        style.accept((StyleVisitor)estimator);
        MetaBufferEstimatorTest.assertTrue((boolean)estimator.isEstimateAccurate());
        MetaBufferEstimatorTest.assertEquals((int)9, (int)estimator.getBuffer());
    }
}

