/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.data.DataTestCase;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.function.FilterFunction_strConcat;
import org.geotools.filter.function.InFunction;
import org.geotools.renderer.lite.MemoryFilterOptimizer;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class MemoryFilterOptimizerTest
extends DataTestCase {
    private PropertyName name;
    private PropertyName id;
    private PropertyIsEqualTo equalName;
    private PropertyIsEqualTo equalId;
    private And and;

    public void setUp() throws Exception {
        super.setUp();
        this.name = this.ff.property("name");
        this.equalName = this.ff.equal((Expression)this.name, (Expression)this.ff.literal((Object)"r1"), false);
        this.id = this.ff.property("id");
        this.equalId = this.ff.equal((Expression)this.id, (Expression)this.ff.literal(1), false);
        this.and = this.ff.and((Filter)this.equalName, (Filter)this.equalId);
    }

    public void testDuplicateWithoutTargets() {
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)this.roadType, Collections.emptySet());
        And copy = (And)this.and.accept((FilterVisitor)optimizer, null);
        List children = copy.getChildren();
        PropertyIsEqualTo equalNameCopy = (PropertyIsEqualTo)children.get(0);
        PropertyIsEqualTo equalIdCopy = (PropertyIsEqualTo)children.get(1);
        MemoryFilterOptimizerTest.assertFalse((boolean)Proxy.isProxyClass(equalNameCopy.getClass()));
        MemoryFilterOptimizerTest.assertFalse((boolean)Proxy.isProxyClass(equalIdCopy.getClass()));
        this.checkPropertiesIndexed(equalNameCopy, equalIdCopy);
    }

    public void checkPropertiesIndexed(PropertyIsEqualTo equalNameCopy, PropertyIsEqualTo equalIdCopy) {
        MemoryFilterOptimizerTest.assertTrue((boolean)(equalNameCopy.getExpression1() instanceof MemoryFilterOptimizer.IndexPropertyName));
        MemoryFilterOptimizer.IndexPropertyName indexedName = (MemoryFilterOptimizer.IndexPropertyName)equalNameCopy.getExpression1();
        MemoryFilterOptimizerTest.assertEquals((int)2, (int)indexedName.index);
        MemoryFilterOptimizerTest.assertEquals((Object)this.name, (Object)indexedName.delegate);
        MemoryFilterOptimizerTest.assertTrue((boolean)(equalIdCopy.getExpression1() instanceof MemoryFilterOptimizer.IndexPropertyName));
        MemoryFilterOptimizer.IndexPropertyName indexedId = (MemoryFilterOptimizer.IndexPropertyName)equalIdCopy.getExpression1();
        MemoryFilterOptimizerTest.assertEquals((int)0, (int)indexedId.index);
        MemoryFilterOptimizerTest.assertEquals((Object)this.id, (Object)indexedId.delegate);
    }

    public void testDuplicateAndMemoize() {
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)this.roadType, new HashSet<PropertyIsEqualTo>(Arrays.asList(this.equalName, this.equalId)));
        And copy = (And)this.and.accept((FilterVisitor)optimizer, null);
        List children = copy.getChildren();
        PropertyIsEqualTo equalNameCopy = (PropertyIsEqualTo)children.get(0);
        PropertyIsEqualTo equalIdCopy = (PropertyIsEqualTo)children.get(1);
        MemoryFilterOptimizerTest.assertTrue((boolean)Proxy.isProxyClass(equalNameCopy.getClass()));
        MemoryFilterOptimizerTest.assertTrue((boolean)Proxy.isProxyClass(equalIdCopy.getClass()));
        this.checkPropertiesIndexed(equalNameCopy, equalIdCopy);
    }

    public void testMemoizeDefaultGeometry() {
        PropertyName property = this.ff.property("");
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)this.roadType, Collections.singleton(property));
        PropertyName memoized = (PropertyName)property.accept((ExpressionVisitor)optimizer, null);
        SimpleFeature spy = (SimpleFeature)Mockito.spy((Object)this.roadFeatures[0]);
        MemoryFilterOptimizerTest.assertSame((Object)this.roadFeatures[0].getDefaultGeometry(), (Object)memoized.evaluate((Object)spy));
        MemoryFilterOptimizerTest.assertSame((Object)this.roadFeatures[0].getDefaultGeometry(), (Object)memoized.evaluate((Object)spy));
        ((SimpleFeature)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getDefaultGeometry();
    }

    public void testMemoizeNonExistingProperty() {
        PropertyName property = this.ff.property("foobar");
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)this.roadType, Collections.singleton(property));
        PropertyName memoized = (PropertyName)property.accept((ExpressionVisitor)optimizer, null);
        MemoryFilterOptimizerTest.assertNull((Object)memoized.evaluate((Object)this.roadFeatures[0]));
    }

    public void testEqualFeatureTypes() throws Exception {
        String name = "name";
        PropertyName property = this.ff.property(name);
        SimpleFeatureType subtype1 = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.roadType, (String[])new String[]{name});
        SimpleFeatureType subtype2 = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.roadType, (String[])new String[]{name});
        PropertyIsEqualTo nameR1 = this.ff.equal((Expression)this.ff.property(name), (Expression)this.ff.literal((Object)"r1"), false);
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)subtype1, Collections.singleton(name));
        PropertyName memoized = (PropertyName)property.accept((ExpressionVisitor)optimizer, null);
        SimpleFeature retyped = SimpleFeatureBuilder.retype((SimpleFeature)this.roadFeatures[0], (SimpleFeatureType)subtype2);
        SimpleFeature spy = (SimpleFeature)Mockito.spy((Object)retyped);
        MemoryFilterOptimizerTest.assertSame((Object)retyped.getAttribute(name), (Object)memoized.evaluate((Object)spy));
        ((SimpleFeature)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)0))).getAttribute(name);
        ((SimpleFeature)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getAttribute(0);
    }

    public void testInFunctionOptimizer() throws Exception {
        String name = "name";
        PropertyName property = this.ff.property(name);
        SimpleFeatureType subtype1 = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.roadType, (String[])new String[]{name});
        PropertyIsEqualTo nameR1 = this.ff.equal((Expression)property, (Expression)this.ff.literal((Object)"r1"), true);
        PropertyIsEqualTo nameR2 = this.ff.equal((Expression)property, (Expression)this.ff.literal((Object)"r2"), true);
        PropertyIsEqualTo nameR3 = this.ff.equal((Expression)this.ff.property(name), (Expression)this.ff.literal((Object)"r3"), true);
        List<Filter> filters = Arrays.asList(nameR1, nameR2, nameR3);
        Or or = this.ff.or(filters);
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)subtype1, Collections.singleton(name));
        Object object = or.accept((FilterVisitor)optimizer, null);
        MemoryFilterOptimizerTest.assertTrue((boolean)(object instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)object;
        MemoryFilterOptimizerTest.assertTrue((boolean)(eq.getExpression1() instanceof InFunction));
        InFunction inFunction = (InFunction)eq.getExpression1();
        MemoryFilterOptimizerTest.assertTrue((inFunction.getParameters().size() == 4 ? 1 : 0) != 0);
        PropertyName propname = (PropertyName)inFunction.getParameters().get(0);
        MemoryFilterOptimizerTest.assertEquals((String)name, (String)propname.getPropertyName());
        List inLiterals = inFunction.getParameters().stream().filter(ex -> ex instanceof Literal).map(ex -> (String)((Literal)ex).evaluate(null, String.class)).collect(Collectors.toList());
        MemoryFilterOptimizerTest.assertTrue((boolean)inLiterals.contains("r1"));
        MemoryFilterOptimizerTest.assertTrue((boolean)inLiterals.contains("r2"));
        MemoryFilterOptimizerTest.assertTrue((boolean)inLiterals.contains("r3"));
    }

    public void testInFunctionOptimizerNotUsed() throws Exception {
        String name = "name";
        PropertyName property = this.ff.property(name);
        PropertyName property2 = this.ff.property("other");
        SimpleFeatureType subtype1 = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.roadType, (String[])new String[]{name});
        PropertyIsEqualTo nameR1 = this.ff.equal((Expression)property, (Expression)this.ff.literal((Object)"r1"), true);
        PropertyIsEqualTo nameR2 = this.ff.equal((Expression)property2, (Expression)this.ff.literal((Object)"r2"), true);
        PropertyIsEqualTo nameR3 = this.ff.equal((Expression)property, (Expression)this.ff.literal((Object)"r3"), true);
        List<Filter> filters = Arrays.asList(nameR1, nameR2, nameR3);
        Or or = this.ff.or(filters);
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)subtype1, Collections.singleton(name));
        Object object = or.accept((FilterVisitor)optimizer, null);
        MemoryFilterOptimizerTest.assertTrue((boolean)(object instanceof Or));
    }

    public void testInFunctionOptimizerNotUsedOtherFilter() throws Exception {
        String name = "name";
        PropertyName property = this.ff.property(name);
        SimpleFeatureType subtype1 = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.roadType, (String[])new String[]{name});
        PropertyIsEqualTo nameR1 = this.ff.equal((Expression)property, (Expression)this.ff.literal((Object)"r1"), true);
        PropertyIsNotEqualTo nameR2 = this.ff.notEqual((Expression)property, (Expression)this.ff.literal((Object)"r2"), true);
        PropertyIsEqualTo nameR3 = this.ff.equal((Expression)property, (Expression)this.ff.literal((Object)"r3"), true);
        List<Filter> filters = Arrays.asList(nameR1, nameR2, nameR3);
        Or or = this.ff.or(filters);
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)subtype1, Collections.singleton(name));
        Object object = or.accept((FilterVisitor)optimizer, null);
        MemoryFilterOptimizerTest.assertTrue((boolean)(object instanceof Or));
    }

    public void testInFunctionOptimizerExpression() throws Exception {
        String name = "name";
        PropertyName property = this.ff.property(name);
        FilterFunction_strConcat concat = new FilterFunction_strConcat();
        ArrayList<Object> propExpressions = new ArrayList<Object>();
        propExpressions.add(property);
        propExpressions.add(this.ff.literal((Object)"-id"));
        concat.setParameters(propExpressions);
        SimpleFeatureType subtype1 = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)this.roadType, (String[])new String[]{name});
        PropertyIsEqualTo nameR1 = this.ff.equal((Expression)concat, (Expression)this.ff.literal((Object)"r1"), true);
        PropertyIsEqualTo nameR2 = this.ff.equal((Expression)concat, (Expression)this.ff.literal((Object)"r2"), true);
        PropertyIsEqualTo nameR3 = this.ff.equal((Expression)concat, (Expression)this.ff.literal((Object)"r3"), true);
        List<Filter> filters = Arrays.asList(nameR1, nameR2, nameR3);
        Or or = this.ff.or(filters);
        MemoryFilterOptimizer optimizer = new MemoryFilterOptimizer((FeatureType)subtype1, Collections.singleton(name));
        Object object = or.accept((FilterVisitor)optimizer, null);
        MemoryFilterOptimizerTest.assertTrue((boolean)(object instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)object;
        MemoryFilterOptimizerTest.assertTrue((boolean)(eq.getExpression1() instanceof InFunction));
        InFunction inFunction = (InFunction)eq.getExpression1();
        MemoryFilterOptimizerTest.assertTrue((inFunction.getParameters().size() == 4 ? 1 : 0) != 0);
        MemoryFilterOptimizerTest.assertTrue((boolean)(inFunction.getParameters().get(0) instanceof FilterFunction_strConcat));
        List inLiterals = inFunction.getParameters().stream().filter(ex -> ex instanceof Literal).map(ex -> (String)((Literal)ex).evaluate(null, String.class)).collect(Collectors.toList());
        MemoryFilterOptimizerTest.assertTrue((boolean)inLiterals.contains("r1"));
        MemoryFilterOptimizerTest.assertTrue((boolean)inLiterals.contains("r2"));
        MemoryFilterOptimizerTest.assertTrue((boolean)inLiterals.contains("r3"));
    }
}

