/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Ignore
public class LineTest {
    private static final long TIME = 4000L;
    SimpleFeatureSource fs;
    ReferencedEnvelope bounds;
    private ContentFeatureSource squares;
    private ContentFeatureSource fsAround;

    @AfterClass
    public static void clearClass() {
        System.clearProperty("org.geotools.referencing.forceXY");
        CRS.reset((String)"all");
    }

    @BeforeClass
    public static void setupClass() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        CRS.reset((String)"all");
    }

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"line.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("line");
        this.fsAround = ds.getFeatureSource("around");
        this.squares = ds.getFeatureSource("square");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    File file(String name) {
        return new File("src/test/resources/org/geotools/renderer/lite/test-data/line/" + name + ".png");
    }

    @Test
    public void testLineCircle() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("lineCircle.sld");
        BufferedImage image = RendererBaseTest.showRender("Lines with circle stroke", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("circle"), (RenderedImage)image, (int)10);
    }

    @Test
    public void testLineDoubleDash() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("lineDoubleDash.sld");
        MapViewport viewport = renderer.getMapContent().getViewport();
        ReferencedEnvelope re = viewport.getBounds();
        ReferencedEnvelope shifted = new ReferencedEnvelope(re.getMinX() + 2.0, re.getMaxX() - 3.0, re.getMinY() + 2.0, re.getMaxY() - 3.0, re.getCoordinateReferenceSystem());
        viewport.setBounds(shifted);
        BufferedImage image = RendererBaseTest.showRender("Lines with double dash array (2 fts)", (GTRenderer)renderer, 4000L, shifted);
        ImageAssert.assertEquals((File)this.file("doubleDash"), (RenderedImage)image, (int)10);
    }

    private StreamingRenderer setupLineMap(String styleFile) throws IOException {
        return this.setupMap(this.fs, styleFile);
    }

    private StreamingRenderer setupMap(SimpleFeatureSource fs, String styleFile) throws IOException {
        Style style = RendererBaseTest.loadStyle(this, styleFile);
        return this.setupMap(fs, style);
    }

    private StreamingRenderer setupMap(SimpleFeatureSource fs, Style style) {
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        return renderer;
    }

    @Test
    @Ignore
    public void testPerPropertyUOM10() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("linePerPropertyUom.sld");
        BufferedImage image = RendererBaseTest.showRender("linePerPropertyUom", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("linePerPropertyUom10"), (RenderedImage)image, (int)10);
    }

    @Test
    public void testLineRailway() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("lineRailway.sld");
        BufferedImage image = RendererBaseTest.showRender("Railway", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("railway"), (RenderedImage)image, (int)500);
    }

    @Test
    public void testLineRotatedSymbol() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("lineRotatedSymbol.sld");
        BufferedImage image = RendererBaseTest.showRender("Rotated symbol", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("lineRotatedSymbol"), (RenderedImage)image, (int)10);
    }

    @Test
    public void testLineDisplacedSymbol() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("lineDisplacedSymbol.sld");
        BufferedImage image = RendererBaseTest.showRender("Dispaced symbol", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("lineDispacedSymbol"), (RenderedImage)image, (int)10);
    }

    @Test
    public void testLineAnchorSymbol() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("lineAnchorSymbol.sld");
        BufferedImage image = RendererBaseTest.showRender("Anchor point at 1:1", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("lineAnchorSymbol"), (RenderedImage)image, (int)20);
    }

    @Test
    public void testLineDisplacedGraphic() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("lineDisplacedGraphic.sld");
        BufferedImage image = RendererBaseTest.showRender("Dispaced graphic", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("lineDispacedGraphic"), (RenderedImage)image, (int)10);
    }

    @Test
    public void testDotsStars() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("dotsStars.sld");
        BufferedImage image = RendererBaseTest.showRender("Dots and stars", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("dotstar"), (RenderedImage)image, (int)200);
    }

    @Test
    public void testRenderingTransform() throws Exception {
        StreamingRenderer renderer = this.setupLineMap("line_rendering_transform.sld");
        BufferedImage image = RendererBaseTest.showRender("Lines with buffer rendering transform", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("renderingTransform"), (RenderedImage)image, (int)10);
    }

    @Test
    public void testPerpendicularOffsetLeftRight() throws Exception {
        StreamingRenderer renderer = this.setupMap(this.fs, RendererBaseTest.loadSEStyle(this, "linePerpendicularOffset-se.sld"));
        BufferedImage image = RendererBaseTest.showRender("Perpendicular offset", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("linePerpendincularOffset"), (RenderedImage)image, (int)10);
    }

    @Test
    public void testPerpendicularOffsetLeftRightSquares() throws Exception {
        StreamingRenderer renderer = this.setupMap((SimpleFeatureSource)this.squares, RendererBaseTest.loadSEStyle(this, "linePerpendicularOffset-se.sld"));
        BufferedImage image = RendererBaseTest.showRender("Perpendicular offset", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("squaresPerpendincularOffset"), (RenderedImage)image, (int)10);
    }

    @Test
    public void testPerpendicularOffsetNPE() throws Exception {
        StreamingRenderer renderer = this.setupMap((SimpleFeatureSource)this.fsAround, RendererBaseTest.loadStyle(this, "linePerpendicularOffsetSmall.sld"));
        final AtomicInteger errors = new AtomicInteger(0);
        BufferedImage image = RendererBaseTest.showRender("Perpendicular offset", (GTRenderer)renderer, 4000L, new ReferencedEnvelope[]{new ReferencedEnvelope(1.0, 4.0, 1.0, 4.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84)}, new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
            }

            public void errorOccurred(Exception e) {
                errors.incrementAndGet();
            }
        });
        Assert.assertEquals((long)0L, (long)errors.get());
    }
}

