/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.geotools.data.FeatureSource;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.DirectLayer;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LabelWrapTest
extends TestCase {
    private static final long TIME = 10000L;
    SimpleFeatureSource fs;
    ReferencedEnvelope bounds;

    protected void setUp() throws Exception {
        RendererBaseTest.setupVeraFonts();
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Point.class);
        builder.add("label", String.class);
        builder.setName("labelWrap");
        SimpleFeatureType type = builder.buildFeatureType();
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 8.0)), "A long label, no newlines"}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 5.0)), "A long label\nwith newlines"}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPoint(new Coordinate(5.0, 2.0)), "A long label with (parenthesis)"}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f1);
        data.addFeature(f2);
        data.addFeature(f3);
        this.fs = data.getFeatureSource("labelWrap");
    }

    public void testNoAutoWrap() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textWrapDisabled.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label wrap disabled");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textWrapDisabled.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3200);
    }

    public void testAutoWrap() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textWrapEnabled.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label wrap enabled");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textWrapEnabled.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    public void testAutoWrapWithIncreasedSpacing() throws Exception {
        Style spacedStyle = this.getCharSpacedStyle("textWrapEnabled.sld", "charSpacing", 5.0f);
        BufferedImage image = this.renderLabels(this.fs, spacedStyle, "Label wrap enabled with extra char spacing");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textWrapEnabledSpaceIncreased.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    public void testAutoWrapWithDecreasedSpacing() throws Exception {
        Style spacedStyle = this.getCharSpacedStyle("textWrapEnabled.sld", "charSpacing", -2.0f);
        BufferedImage image = this.renderLabels(this.fs, spacedStyle, "Label wrap enabled with extra char spacing");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textWrapEnabledSpaceDecreased.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    public void testAutoWrapWithIncreasedWordSpacing() throws Exception {
        Style spacedStyle = this.getCharSpacedStyle("textWrapEnabled.sld", "wordSpacing", 15.0f);
        BufferedImage image = this.renderLabels(this.fs, spacedStyle, "Label wrap enabled with extra char spacing");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textWrapEnabledWordSpaceIncreased.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    private Style getCharSpacedStyle(String styleFile, final String key, final float spacing) throws IOException {
        Style style = RendererBaseTest.loadStyle((Object)this, styleFile);
        DuplicatingStyleVisitor visitor = new DuplicatingStyleVisitor(){

            public void visit(TextSymbolizer text) {
                super.visit(text);
                TextSymbolizer ts = (TextSymbolizer)this.getCopy();
                ts.getOptions().put(key, String.valueOf(spacing));
            }
        };
        style.accept((StyleVisitor)visitor);
        Style spacedStyle = (Style)visitor.getCopy();
        return spacedStyle;
    }

    public void testAutoWrapLocalTransform() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textWrapEnabled.sld");
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        int SIZE = 300;
        BufferedImage image = new BufferedImage(SIZE, SIZE, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, SIZE, SIZE);
        g.setTransform(new AffineTransform(1.1, Math.sin(Math.toRadians(15.0)), -Math.sin(Math.toRadians(15.0)), 1.1, 15.0, 20.0));
        renderer.paint(g, new Rectangle(SIZE, SIZE), this.bounds);
        mc.dispose();
        renderer.getMapContent().dispose();
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textWrapEnabledLocalTransform.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    public void testDirectLayerLabelInteraction() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "textWrapEnabled.sld");
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        mc.addLayer((Layer)new DirectLayer(){

            public ReferencedEnvelope getBounds() {
                return null;
            }

            public void draw(Graphics2D graphics, MapContent map, MapViewport viewport) {
            }
        });
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("Label and direct layers", (GTRenderer)renderer, 10000L, this.bounds);
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textWrapEnabled.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)3000);
    }

    private BufferedImage renderLabels(SimpleFeatureSource fs, Style style, String title) throws Exception {
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        return RendererBaseTest.showRender(title, (GTRenderer)renderer, 10000L, this.bounds);
    }
}

