/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashMap;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LabelShieldTest {
    private static final long TIME = 1000L;
    SimpleFeatureSource fs;
    ReferencedEnvelope bounds;
    StreamingRenderer renderer;
    SimpleFeatureSource fs_multiline;
    ContentFeatureSource pointShield;

    @BeforeClass
    public static void prepareCRS() {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        CRS.reset((String)"all");
    }

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"diaglines.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("diaglines");
        this.fs_multiline = ds.getFeatureSource("diaglines_multiline");
        this.pointShield = ds.getFeatureSource("point_shield");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer = new StreamingRenderer();
        HashMap<String, LabelCacheImpl> rendererParams = new HashMap<String, LabelCacheImpl>();
        LabelCacheImpl labelCache = new LabelCacheImpl();
        rendererParams.put("labelCache", labelCache);
        this.renderer.setRendererHints(rendererParams);
        this.renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.setupVeraFonts();
    }

    @Test
    public void testLabelShield() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textLabelShield.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        this.renderer.setMapContent(mc);
        RendererBaseTest.showRender("Labels and shield", (GTRenderer)this.renderer, 1000L, this.bounds);
    }

    @Test
    public void testPointShieldUnderTheLine() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textLabelShieldStretch2.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointShield, style));
        this.renderer.setMapContent(mc);
        ReferencedEnvelope pointBounds = this.pointShield.getBounds();
        pointBounds.expandBy(3.0, 3.0);
        BufferedImage image = RendererBaseTest.showRender("Text under the line", (GTRenderer)this.renderer, 1000L, pointBounds);
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textLabelShieldUnderTheLine.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1200);
    }

    @Test
    public void testPointIndependentGraphic() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textLabelIndependentGraphic.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointShield, style));
        this.renderer.setMapContent(mc);
        ReferencedEnvelope pointBounds = this.pointShield.getBounds();
        pointBounds.expandBy(3.0, 3.0);
        BufferedImage image = RendererBaseTest.showRender("Graphic above text", (GTRenderer)this.renderer, 1000L, pointBounds);
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textLabelIndependentGraphic.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1200);
    }

    @Test
    public void testLabelShieldMultiline() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textLabelShield.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_multiline, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("Labels and shield", (GTRenderer)this.renderer, 1000L, this.bounds);
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textLabelShieldMultiline.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1200);
    }

    @Test
    public void testLabelShieldMultilineStretch() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textLabelShieldStretch.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_multiline, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("Labels and shield", (GTRenderer)this.renderer, 1000L, this.bounds);
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/textLabelShieldMultilineStretch.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)1200);
    }

    @Test
    public void testOnlyShield() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "textOnlyShield.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs, style));
        this.renderer.setMapContent(mc);
        RendererBaseTest.showRender("Labels and shield, fontsize = 0", (GTRenderer)this.renderer, 1000L, this.bounds);
    }
}

