/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.data.DataTestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.FilterMemoizer;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class FilterMemoizerTest
extends DataTestCase {
    static FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    public void testMemoizeFilter() throws Exception {
        SimpleFeature rf0 = (SimpleFeature)Mockito.spy((Object)this.roadFeatures[0]);
        SimpleFeature rf1 = (SimpleFeature)Mockito.spy((Object)this.roadFeatures[1]);
        PropertyIsEqualTo nameR1 = FF.equal((Expression)FF.property("name"), (Expression)FF.literal((Object)"r1"), false);
        Filter memoized = FilterMemoizer.memoize((Filter)nameR1);
        FilterMemoizerTest.assertTrue((boolean)memoized.evaluate((Object)rf0));
        FilterMemoizerTest.assertTrue((boolean)memoized.evaluate((Object)rf0));
        ((SimpleFeature)Mockito.verify((Object)rf0, (VerificationMode)Mockito.times((int)1))).getAttribute("name");
        FilterMemoizerTest.assertFalse((boolean)memoized.evaluate((Object)rf1));
        ((SimpleFeature)Mockito.verify((Object)rf1, (VerificationMode)Mockito.times((int)1))).getAttribute("name");
        FilterMemoizerTest.assertTrue((boolean)memoized.evaluate((Object)rf0));
        ((SimpleFeature)Mockito.verify((Object)rf0, (VerificationMode)Mockito.times((int)2))).getAttribute("name");
    }

    public void testVolatileFunction() throws Exception {
        Function random = FF.function("random", new Expression[0]);
        Function spy = (Function)Mockito.spy((Object)random);
        PropertyIsGreaterThanOrEqualTo filter = FF.greaterOrEqual((Expression)spy, (Expression)FF.literal(0));
        Filter memoized = FilterMemoizer.memoize((Filter)filter);
        FilterMemoizerTest.assertTrue((boolean)memoized.evaluate(null));
        FilterMemoizerTest.assertTrue((boolean)memoized.evaluate(null));
        ((Function)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)2))).evaluate(null);
    }
}

