/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.IOException;
import java.net.URL;
import junit.framework.TestCase;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DirectLayer;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.test.TestData;
import org.geotools.xml.styling.SLDParser;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectLayerLabelsTest
extends TestCase {
    private long timout = 3000L;
    private static final int CENTERX = 130;
    private static final int CENTERY = 40;

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testPointLabeling() throws Exception {
        SimpleFeatureCollection collection = this.createPointFeatureCollection();
        Style style = this.loadStyle("PointStyle.sld");
        DirectLayerLabelsTest.assertNotNull((Object)style);
        MapContent map = new MapContent();
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)collection, style));
        DirectLayer dl = new DirectLayer(){

            public ReferencedEnvelope getBounds() {
                return null;
            }

            public void draw(Graphics2D graphics, MapContent map, MapViewport viewport) {
                graphics.setColor(Color.BLACK);
                graphics.drawString("DirectLayer", 10, 10);
            }
        };
        map.addLayer((Layer)dl);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(map);
        ReferencedEnvelope env = map.getMaxBounds();
        int boundary = 10;
        env = new ReferencedEnvelope(env.getMinX() - (double)boundary, env.getMaxX() + (double)boundary, env.getMinY() - (double)boundary, env.getMaxY() + (double)boundary, null);
        RendererBaseTest.showRender("testDirectLabeling", (GTRenderer)renderer, this.timout, env);
        map.dispose();
    }

    private Style loadStyle(String sldFilename) throws IOException {
        StyleFactory factory = CommonFactoryFinder.getStyleFactory();
        URL surl = TestData.getResource((Object)((Object)this), (String)sldFilename);
        SLDParser stylereader = new SLDParser(factory, surl);
        Style style = stylereader.readXML()[0];
        return style;
    }

    private SimpleFeatureCollection createPointFeatureCollection() throws Exception {
        AttributeDescriptor[] types = new AttributeDescriptor[2];
        GeometryFactory geomFac = new GeometryFactory();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(this.createPointFeature(2, 2, "LongLabel1", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(4, 4, "LongLabel2", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(0, 4, "LongLabel3", (CoordinateReferenceSystem)crs, geomFac, types));
        data.addFeature(this.createPointFeature(2, 6, "LongLabel6", (CoordinateReferenceSystem)crs, geomFac, types));
        return data.getFeatureSource("pointfeature").getFeatures();
    }

    private SimpleFeature createPointFeature(int x, int y, String name, CoordinateReferenceSystem crs, GeometryFactory geomFac, AttributeDescriptor[] types) throws Exception {
        Coordinate c = new Coordinate((double)x, (double)y);
        Point point = geomFac.createPoint(c);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        if (crs != null) {
            builder.add("point", point.getClass(), crs);
        } else {
            builder.add("centre", point.getClass());
        }
        builder.add("name", String.class);
        builder.setName("pointfeature");
        SimpleFeatureType type = builder.buildFeatureType();
        return SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point, name}, null);
    }
}

