/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelPainter;
import org.geotools.renderer.label.LineInfo;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryImpl;
import org.geotools.styling.TextSymbolizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.mockito.Mockito;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class LabelPainterTest {
    private static GeometryFactory geometryFactory = new GeometryFactory();
    private static StyleFactory styleFactory = new StyleFactoryImpl();
    private Graphics2D graphics;
    private TextStyle2D style;
    private TextSymbolizer symbolizer;
    LiteShape2 shape;

    @Before
    public void setUp() throws TransformException, FactoryException, IOException, FontFormatException {
        this.graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        Mockito.when((Object)this.graphics.getFontRenderContext()).thenReturn((Object)new FontRenderContext(new AffineTransform(), RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT));
        Mockito.when((Object)this.graphics.getTransform()).thenReturn((Object)new AffineTransform());
        this.style = new TextStyle2D();
        this.style.setFont(new Font("Serif", 0, 10));
        this.shape = new LiteShape2((Geometry)geometryFactory.createPoint(new Coordinate(10.0, 10.0)), (MathTransform)ProjectiveTransform.create((AffineTransform)new AffineTransform()), null, false);
        this.symbolizer = styleFactory.createTextSymbolizer();
        RendererBaseTest.setupVeraFonts();
    }

    @Test
    public void testEmptyLinesInLabel() {
        LabelPainter painter = new LabelPainter(this.graphics, LabelCacheImpl.LabelRenderingMode.STRING);
        LabelCacheItem labelItem = new LabelCacheItem("LAYERID", this.style, this.shape, "line1\n\nline2", this.symbolizer);
        labelItem.setAutoWrap(0);
        painter.setLabel(labelItem);
        Assert.assertEquals((long)3L, (long)painter.getLineCount());
    }

    @Test
    public void testEmptyLinesInLabelWithAutoWrap() {
        LabelPainter painter = new LabelPainter(this.graphics, LabelCacheImpl.LabelRenderingMode.STRING);
        LabelCacheItem labelItem = new LabelCacheItem("LAYERID", this.style, this.shape, "line1\n\nline2", this.symbolizer);
        labelItem.setAutoWrap(100);
        painter.setLabel(labelItem);
        Assert.assertEquals((long)3L, (long)painter.getLineCount());
    }

    @Test
    public void testOnlyNewlines() {
        LabelPainter painter = new LabelPainter(this.graphics, LabelCacheImpl.LabelRenderingMode.STRING);
        LabelCacheItem labelItem = new LabelCacheItem("LAYERID", this.style, this.shape, "\n\n", this.symbolizer);
        labelItem.setAutoWrap(100);
        painter.setLabel(labelItem);
        Assert.assertEquals((long)0L, (long)painter.getLineCount());
    }

    @Test
    public void testGetLastLineHeightOnlyNewLines() {
        LabelPainter painter = new LabelPainter(this.graphics, LabelCacheImpl.LabelRenderingMode.STRING);
        LabelCacheItem labelItem = new LabelCacheItem("LAYERID", this.style, this.shape, "\n\n", this.symbolizer);
        labelItem.setAutoWrap(100);
        painter.setLabel(labelItem);
        Assert.assertTrue((painter.getLineHeightForAnchorY(0.0) == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetLastLineHeightLabelWithAutoWrap() {
        LabelPainter painter = new LabelPainter(this.graphics, LabelCacheImpl.LabelRenderingMode.STRING);
        LabelCacheItem labelItem = new LabelCacheItem("LAYERID", this.style, this.shape, "line1\n\nline2", this.symbolizer);
        labelItem.setAutoWrap(100);
        painter.setLabel(labelItem);
        Assert.assertTrue((painter.getLineHeightForAnchorY(0.0) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((((LineInfo)painter.lines.get(0)).getLineHeight() == painter.getLineHeightForAnchorY(1.0) ? 1 : 0) != 0);
        Assert.assertTrue((((LineInfo)painter.lines.get(painter.getLineCount() - 1)).getLineHeight() == painter.getLineHeightForAnchorY(1.0) ? 1 : 0) != 0);
    }

    @Test
    public void testFullLabelBoundsNativeSize() throws Exception {
        TextStyle2D style = new TextStyle2D();
        style.setFont(new Font("Bitstream Vera Sans", 0, 10));
        LabelPainter painter = new LabelPainter(this.graphics, LabelCacheImpl.LabelRenderingMode.STRING);
        LabelCacheItem labelItem = new LabelCacheItem("LAYERID", style, this.shape, "line1", this.symbolizer);
        painter.setLabel(labelItem);
        double tolerance = 2.0;
        Rectangle2D lBounds = painter.getFullLabelBounds();
        Assert.assertEquals((double)0.0, (double)lBounds.getMinX(), (double)tolerance);
        Assert.assertEquals((double)-7.5, (double)lBounds.getMinY(), (double)tolerance);
        Assert.assertEquals((double)22.0, (double)lBounds.getWidth(), (double)tolerance);
        Assert.assertEquals((double)8.0, (double)lBounds.getHeight(), (double)tolerance);
        MarkStyle2D mark = new MarkStyle2D();
        mark.setShape((Shape)new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        mark.setSize(20.0);
        style.setGraphic((Style2D)mark);
        painter.setLabel(labelItem);
        Rectangle2D lgBounds = painter.getFullLabelBounds();
        Assert.assertEquals((double)0.0, (double)lgBounds.getMinX(), (double)tolerance);
        Assert.assertEquals((double)-13.5, (double)lgBounds.getMinY(), (double)tolerance);
        Assert.assertEquals((double)22.0, (double)lgBounds.getWidth(), (double)tolerance);
        Assert.assertEquals((double)20.0, (double)lgBounds.getHeight(), (double)tolerance);
        labelItem.setGraphicsResize(LabelCacheItem.GraphicResize.STRETCH);
        labelItem.setGraphicMargin(new int[]{5, 5, 5, 5});
        painter.setLabel(labelItem);
        Rectangle2D lgsBounds = painter.getFullLabelBounds();
        Assert.assertEquals((double)-5.0, (double)lgsBounds.getMinX(), (double)tolerance);
        Assert.assertEquals((double)-12.5, (double)lgsBounds.getMinY(), (double)tolerance);
        Assert.assertEquals((double)32.0, (double)lgsBounds.getWidth(), (double)tolerance);
        Assert.assertEquals((double)18.0, (double)lgsBounds.getHeight(), (double)tolerance);
        labelItem.setGraphicsResize(LabelCacheItem.GraphicResize.PROPORTIONAL);
        labelItem.setGraphicMargin(null);
        painter.setLabel(labelItem);
        Rectangle2D lgpBounds = painter.getFullLabelBounds();
        Assert.assertEquals((double)0.0, (double)lgpBounds.getMinX(), (double)tolerance);
        Assert.assertEquals((double)-14.0, (double)lgpBounds.getMinY(), (double)tolerance);
        Assert.assertEquals((double)22.0, (double)lgpBounds.getWidth(), (double)tolerance);
        Assert.assertEquals((double)22.0, (double)lgpBounds.getHeight(), (double)tolerance);
    }

    @Test
    public void testResizeGraphicWithMark2DGraphicResizeStrech() throws Exception {
        LabelCacheItem labelItem = new LabelCacheItem("LayerID", this.style, this.shape, "Test", this.symbolizer);
        labelItem.setGraphicsResize(LabelCacheItem.GraphicResize.STRETCH);
        Rectangle2D.Double labelBounds = new Rectangle2D.Double(0.0, -0.6875, 0.4, 0.4);
        MarkStyle2D style2D = new MarkStyle2D();
        style2D.setShape((Shape)new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        int[] graphicMargin = new int[]{0, 0, 0, 0};
        labelItem.setGraphicMargin(graphicMargin);
        LabelPainter painter = new LabelPainter(this.graphics, LabelCacheImpl.LabelRenderingMode.OUTLINE);
        painter.setLabel(labelItem);
        painter.labelBounds = labelBounds;
        Style2D reply = painter.resizeGraphic((Style2D)style2D);
        Assert.assertNotNull((Object)reply);
    }

    @Test
    public void testResizeGraphicWithMark2DGraphicResizeStrechNegativeMargin() throws Exception {
        LabelCacheItem labelItem = new LabelCacheItem("LayerID", this.style, this.shape, "Test", this.symbolizer);
        labelItem.setGraphicsResize(LabelCacheItem.GraphicResize.STRETCH);
        Rectangle2D.Double labelBounds = new Rectangle2D.Double(0.0, -0.6875, 0.4, 0.4);
        MarkStyle2D style2D = new MarkStyle2D();
        style2D.setShape((Shape)new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        int[] graphicMargin = new int[]{-1, -1, -1, -1};
        labelItem.setGraphicMargin(graphicMargin);
        LabelPainter painter = new LabelPainter(this.graphics, LabelCacheImpl.LabelRenderingMode.OUTLINE);
        painter.setLabel(labelItem);
        painter.labelBounds = labelBounds;
        Style2D reply = painter.resizeGraphic((Style2D)style2D);
        Assert.assertNull((Object)reply);
        painter.paintStraightLabel(new AffineTransform());
    }
}

