/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapLayerListListener;
import org.geotools.map.MapViewport;
import org.geotools.map.MockLayer;
import org.geotools.map.WaitingMapListener;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapContentTest {
    private static final long LISTENER_TIMEOUT = 500L;
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(149.0, 153.0, -32.0, -36.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private static final ReferencedEnvelope SMALL_WORLD = new ReferencedEnvelope(150.0, 152.0, -33.0, -35.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private static final double TOL = 1.0E-6;
    private MapContent mapContent;
    private WaitingMapListener listener;

    @Before
    public void setup() {
        this.mapContent = new MapContent();
        this.listener = new WaitingMapListener();
        this.mapContent.addMapLayerListListener((MapLayerListListener)this.listener);
    }

    @After
    public void cleanup() {
        this.mapContent.dispose();
    }

    @Test
    public void testNullLayerBounds() {
        MockLayer mapLayerBoundsNull = new MockLayer(null);
        this.mapContent.addLayer((Layer)mapLayerBoundsNull);
        ReferencedEnvelope maxBounds = this.mapContent.getMaxBounds();
        Assert.assertNotNull((Object)maxBounds);
        Assert.assertTrue((boolean)maxBounds.isEmpty());
    }

    @Test
    public void getDefaultViewport() throws Exception {
        this.mapContent.addLayer((Layer)new MockLayer(WORLD));
        MapViewport viewport = this.mapContent.getViewport();
        Assert.assertNotNull((Object)viewport);
        Assert.assertTrue((boolean)WORLD.boundsEquals2D((org.opengis.geometry.Envelope)viewport.getBounds(), 1.0E-6));
    }

    @Test
    public void setNewViewportAndCheckBounds() {
        this.mapContent.addLayer((Layer)new MockLayer(WORLD));
        MapViewport newViewport = new MapViewport();
        newViewport.setBounds(SMALL_WORLD);
        this.mapContent.setViewport(newViewport);
        ReferencedEnvelope bounds = this.mapContent.getBounds();
        Assert.assertTrue((boolean)SMALL_WORLD.boundsEquals2D((org.opengis.geometry.Envelope)bounds, 1.0E-6));
    }

    @Test
    public void addLayerAndGetEvent() {
        this.listener.setExpected(WaitingMapListener.Type.ADDED);
        this.mapContent.addLayer((Layer)new MockLayer(WORLD));
        Assert.assertTrue((boolean)this.listener.await(WaitingMapListener.Type.ADDED, 500L));
    }

    @Test
    public void removeLayerAndGetEvent() {
        MockLayer layer = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layer);
        this.listener.setExpected(WaitingMapListener.Type.REMOVED);
        this.mapContent.removeLayer((Layer)layer);
        Assert.assertTrue((boolean)this.listener.await(WaitingMapListener.Type.REMOVED, 500L));
    }

    @Test
    public void moveLayerAndGetEvent() {
        MockLayer layer0 = new MockLayer(WORLD);
        MockLayer layer1 = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layer0);
        this.mapContent.addLayer((Layer)layer1);
        this.listener.setExpected(WaitingMapListener.Type.MOVED);
        this.mapContent.moveLayer(0, 1);
        Assert.assertTrue((boolean)this.listener.await(WaitingMapListener.Type.MOVED, 500L));
    }

    @Test
    public void disposeMapContentAndGetLayerPreDisposeEvent() {
        MockLayer layer = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layer);
        this.listener.setExpected(WaitingMapListener.Type.PRE_DISPOSE);
        this.mapContent.dispose();
        Assert.assertTrue((boolean)this.listener.await(WaitingMapListener.Type.PRE_DISPOSE, 500L));
    }

    @Test
    public void crsIsAutoSetFromFirstLayerWithNonNullCRS() {
        CoordinateReferenceSystem startCRS = this.mapContent.getCoordinateReferenceSystem();
        ReferencedEnvelope envNoCRS = new ReferencedEnvelope((Envelope)WORLD, null);
        MockLayer layerNoCRS = new MockLayer(envNoCRS);
        this.mapContent.addLayer((Layer)layerNoCRS);
        Assert.assertEquals((Object)startCRS, (Object)this.mapContent.getCoordinateReferenceSystem());
        MockLayer layerWithCRS = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layerWithCRS);
        Assert.assertEquals((Object)WORLD.getCoordinateReferenceSystem(), (Object)this.mapContent.getCoordinateReferenceSystem());
    }

    @Test
    public void crsIsNotAutoSetIfViewportIsNotEditable() {
        MapViewport viewport = new MapViewport();
        viewport.setEditable(false);
        this.mapContent.setViewport(viewport);
        MockLayer layerWithCRS = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layerWithCRS);
        Assert.assertNull((Object)this.mapContent.getCoordinateReferenceSystem());
    }

    @Test
    public void crsIsNotAutoSetIfViewportHasExplicitCRS() {
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.GENERIC_2D;
        MapViewport viewport = new MapViewport();
        viewport.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
        this.mapContent.setViewport(viewport);
        MockLayer layerWithCRS = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layerWithCRS);
        Assert.assertTrue((boolean)viewport.isEditable());
        Assert.assertEquals((Object)crs, (Object)this.mapContent.getCoordinateReferenceSystem());
        Assert.assertFalse((boolean)WORLD.getCoordinateReferenceSystem().equals(this.mapContent.getCoordinateReferenceSystem()));
    }

    @Test
    public void crsIsAutoSetWhenGetViewportCalledBeforeAddingLayers() {
        MapViewport viewport = this.mapContent.getViewport();
        Assert.assertNull((Object)viewport.getCoordinateReferenceSystem());
        ReferencedEnvelope envNoCRS = new ReferencedEnvelope((Envelope)WORLD, null);
        MockLayer layerNoCRS = new MockLayer(envNoCRS);
        this.mapContent.addLayer((Layer)layerNoCRS);
        Assert.assertNull((Object)this.mapContent.getCoordinateReferenceSystem());
        MockLayer layerWithCRS = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layerWithCRS);
        Assert.assertEquals((Object)WORLD.getCoordinateReferenceSystem(), (Object)viewport.getCoordinateReferenceSystem());
    }

    @Test
    public void addingLayerViaLayersListFiresEvent() throws Exception {
        this.listener.setExpected(WaitingMapListener.Type.ADDED);
        this.mapContent.layers().add(new MockLayer(WORLD));
        this.listener.await(WaitingMapListener.Type.ADDED, 500L);
    }

    @Test
    public void addLayerWithMethodAndRemoveViaLayersList() throws Exception {
        MockLayer layer = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layer);
        Assert.assertTrue((boolean)this.mapContent.layers().remove((Object)layer));
    }

    @Test
    public void addLayerAtPosViaLayerList() throws Exception {
        MockLayer layer1 = new MockLayer(WORLD);
        MockLayer layer2 = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layer1);
        this.mapContent.layers().add(0, layer2);
        Assert.assertTrue((this.mapContent.layers().get(0) == layer2 ? 1 : 0) != 0);
        Assert.assertTrue((this.mapContent.layers().get(1) == layer1 ? 1 : 0) != 0);
    }

    @Test
    public void addFromCollectionViaLayerList() {
        MockLayer layer1 = new MockLayer(WORLD);
        MockLayer layer2 = new MockLayer(WORLD);
        MockLayer layer3 = new MockLayer(WORLD);
        List<Layer> layers = Arrays.asList(new Layer[]{layer1, layer2, layer3});
        this.mapContent.addLayer((Layer)layer2);
        Assert.assertTrue((boolean)this.mapContent.layers().addAll(layers));
        Assert.assertEquals((long)layers.size(), (long)this.mapContent.layers().size());
    }

    @Test
    public void addFromCollectionViaLayerListAtPosition() {
        MockLayer layer1 = new MockLayer(WORLD);
        MockLayer layer2 = new MockLayer(WORLD);
        MockLayer layer3 = new MockLayer(WORLD);
        List<Layer> layers = Arrays.asList(new Layer[]{layer1, layer2, layer3});
        this.mapContent.addLayer((Layer)layer2);
        Assert.assertTrue((boolean)this.mapContent.layers().addAll(0, layers));
        Assert.assertEquals((long)layers.size(), (long)this.mapContent.layers().size());
        Assert.assertTrue((this.mapContent.layers().get(0) == layer1 ? 1 : 0) != 0);
        Assert.assertTrue((this.mapContent.layers().get(1) == layer3 ? 1 : 0) != 0);
        Assert.assertTrue((this.mapContent.layers().get(2) == layer2 ? 1 : 0) != 0);
    }

    @Test
    public void removeLayerViaLayerListByPosition() throws Exception {
        MockLayer layer1 = new MockLayer(WORLD);
        this.mapContent.layers().add(layer1);
        MockLayer layer2 = new MockLayer(WORLD);
        this.mapContent.layers().add(layer2);
        this.mapContent.layers().remove(0);
        Assert.assertEquals((long)1L, (long)this.mapContent.layers().size());
        Assert.assertTrue((this.mapContent.layers().get(0) == layer2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)layer1.isDisposed());
        Assert.assertFalse((boolean)layer2.isDisposed());
    }

    @Test
    public void removeLayerViaLayerListByReference() throws Exception {
        MockLayer layer1 = new MockLayer(WORLD);
        this.mapContent.layers().add(layer1);
        MockLayer layer2 = new MockLayer(WORLD);
        this.mapContent.layers().add(layer2);
        this.mapContent.layers().remove((Object)layer1);
        Assert.assertEquals((long)1L, (long)this.mapContent.layers().size());
        Assert.assertTrue((this.mapContent.layers().get(0) == layer2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)layer1.isDisposed());
        Assert.assertFalse((boolean)layer2.isDisposed());
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void removeLayerIndexOutOfRangeThrowsException() throws Exception {
        this.mapContent.layers().add(new MockLayer(WORLD));
        this.mapContent.layers().remove(1);
    }

    @Test
    public void removeLayerNotInListReturnsFalse() throws Exception {
        Assert.assertFalse((boolean)this.mapContent.layers().remove((Object)new MockLayer(WORLD)));
    }

    @Test
    public void removeAllLayersInCollection() throws Exception {
        MockLayer layerFirst = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layerFirst);
        ArrayList<MockLayer> layers = new ArrayList<MockLayer>();
        for (int i = 0; i < 3; ++i) {
            MockLayer layer = new MockLayer(WORLD);
            layers.add(layer);
            this.mapContent.addLayer((Layer)layer);
        }
        MockLayer layerLast = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layerLast);
        Assert.assertTrue((boolean)this.mapContent.layers().removeAll(layers));
        Assert.assertEquals((long)2L, (long)this.mapContent.layers().size());
        Assert.assertTrue((this.mapContent.layers().get(0) == layerFirst ? 1 : 0) != 0);
        Assert.assertTrue((this.mapContent.layers().get(1) == layerLast ? 1 : 0) != 0);
        Assert.assertFalse((boolean)layerFirst.isDisposed());
        Assert.assertFalse((boolean)layerLast.isDisposed());
        for (MockLayer layer : layers) {
            Assert.assertTrue((boolean)layer.isDisposed());
        }
    }

    @Test
    public void retainAllLayersInCollection() throws Exception {
        MockLayer layerFirst = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layerFirst);
        ArrayList<MockLayer> layers = new ArrayList<MockLayer>();
        for (int i = 0; i < 3; ++i) {
            MockLayer layer = new MockLayer(WORLD);
            layers.add(layer);
            this.mapContent.addLayer((Layer)layer);
        }
        MockLayer layerLast = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layerLast);
        Assert.assertTrue((boolean)this.mapContent.layers().retainAll(layers));
        Assert.assertEquals((long)layers.size(), (long)this.mapContent.layers().size());
        for (int i = 0; i < layers.size(); ++i) {
            Assert.assertTrue((this.mapContent.layers().get(i) == layers.get(i) ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)layerFirst.isDisposed());
        Assert.assertTrue((boolean)layerLast.isDisposed());
        for (MockLayer layer : layers) {
            Assert.assertFalse((boolean)layer.isDisposed());
        }
    }

    @Test
    public void setLayerInLayerList() throws Exception {
        MockLayer layer1 = new MockLayer(WORLD);
        MockLayer layer2 = new MockLayer(WORLD);
        this.mapContent.addLayer((Layer)layer1);
        this.listener.setExpected(WaitingMapListener.Type.REMOVED);
        this.listener.setExpected(WaitingMapListener.Type.ADDED);
        this.mapContent.layers().set(0, layer2);
        Assert.assertTrue((boolean)this.listener.await(WaitingMapListener.Type.REMOVED, 500L));
        Assert.assertTrue((boolean)this.listener.await(WaitingMapListener.Type.ADDED, 500L));
        Assert.assertEquals((long)1L, (long)this.mapContent.layers().size());
        Assert.assertTrue((this.mapContent.layers().get(0) == layer2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)layer1.isDisposed());
        Assert.assertFalse((boolean)layer2.isDisposed());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void addingLayerViaListIteratorIsNotSupported() throws Exception {
        ListIterator<MockLayer> listIterator = this.mapContent.layers().listIterator();
        listIterator.add(new MockLayer(WORLD));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removingLayerViaListIteratorIsNotSupported() throws Exception {
        this.mapContent.addLayer((Layer)new MockLayer(WORLD));
        ListIterator listIterator = this.mapContent.layers().listIterator();
        listIterator.next();
        listIterator.remove();
    }
}

