/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.util.logging.Logging;

public class FontCache {
    private static final Logger LOGGER = Logging.getLogger(FontCache.class);
    static volatile FontCache defaultInstance;
    volatile Set<String> systemFonts = new HashSet<String>();
    Map<String, Font> loadedFonts = new ConcurrentHashMap<String, Font>();
    Map<String, List<String>> alternatives = new ConcurrentHashMap<String, List<String>>();

    public static FontCache getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new FontCache();
        }
        return defaultInstance;
    }

    public Font getFont(String requestedFont) {
        Font javaFont = null;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("trying to load " + requestedFont);
        }
        if (this.loadedFonts.containsKey(requestedFont)) {
            return this.loadedFonts.get(requestedFont);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("not already loaded");
        }
        if (this.getSystemFonts().contains(requestedFont)) {
            javaFont = new Font(requestedFont, 0, 12);
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("not a system font");
            }
            javaFont = FontCache.loadFromUrl(requestedFont);
        }
        if (javaFont == null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.fine("Could not load font " + requestedFont);
            }
        } else {
            this.loadedFonts.put(requestedFont, javaFont);
        }
        return javaFont;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Font loadFromUrl(String fontUrl) {
        try (InputStream is = FontCache.getInputStream(fontUrl);){
            if (is == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("null input stream, could not load the font");
                }
                Font font2 = null;
                return font2;
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("about to load");
            }
            Font font = Font.createFont(0, is);
            return font;
        }
        catch (FontFormatException ffe) {
            if (!LOGGER.isLoggable(Level.INFO)) return null;
            LOGGER.info("Font format error in FontCache " + fontUrl + "\n" + String.valueOf(ffe));
            return null;
        }
        catch (IOException ioe) {
            if (!LOGGER.isLoggable(Level.INFO)) return null;
            LOGGER.info("IO error in FontCache " + fontUrl + "\n" + String.valueOf(ioe));
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static InputStream getInputStream(String fontUrl) {
        if (fontUrl.startsWith("http") || fontUrl.startsWith("file:") || fontUrl.startsWith("jar:")) {
            try {
                URL url = new URL(fontUrl);
                return url.openStream();
            }
            catch (MalformedURLException mue) {
                if (!LOGGER.isLoggable(Level.INFO)) return null;
                LOGGER.info("Bad url in SLDStyleFactory " + fontUrl + "\n" + String.valueOf(mue));
                return null;
            }
            catch (IOException ioe) {
                if (!LOGGER.isLoggable(Level.INFO)) return null;
                LOGGER.info("IO error in SLDStyleFactory " + fontUrl + "\n" + String.valueOf(ioe));
                return null;
            }
        } else {
            File file;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("not a URL");
            }
            if (!(file = new File(fontUrl)).exists()) return null;
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fne) {
                if (!LOGGER.isLoggable(Level.INFO)) return null;
                LOGGER.info("Bad file name in SLDStyleFactory" + fontUrl + "\n" + String.valueOf(fne));
            }
        }
        return null;
    }

    public void registerFont(Font f) {
        this.loadedFonts.put(f.getName(), f);
    }

    public synchronized void resetCache() {
        if (this.systemFonts != null) {
            this.systemFonts.clear();
        }
        if (this.loadedFonts != null) {
            this.loadedFonts.clear();
        }
        if (this.alternatives != null) {
            this.alternatives.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getSystemFonts() {
        if (this.systemFonts.isEmpty()) {
            Set<String> set = this.systemFonts;
            synchronized (set) {
                if (this.systemFonts.isEmpty()) {
                    Font[] fonts;
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    HashSet<String> fontset = new HashSet<String>();
                    for (Font font : fonts = ge.getAllFonts()) {
                        fontset.add(font.getName());
                        fontset.add(font.getFamily());
                    }
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("there are " + fontset.size() + " fonts available");
                    }
                    this.systemFonts.addAll(fontset);
                }
            }
        }
        return this.systemFonts;
    }

    public Set<String> getAvailableFonts() {
        HashSet<String> availableFonts = new HashSet<String>();
        availableFonts.addAll(this.getSystemFonts());
        availableFonts.addAll(this.loadedFonts.keySet());
        return availableFonts;
    }

    public List<String> getAlternatives(String name) {
        List<String> result = this.alternatives.get(name);
        if (result == null) {
            result = FontCache.getDefaultInstance().getAvailableFonts().stream().filter(f -> f.startsWith(name)).filter(f -> {
                String lc = f.toLowerCase();
                return !lc.contains(" bold") && !lc.contains(" italic");
            }).sorted().collect(Collectors.toList());
            this.alternatives.put(name, result);
        }
        return result;
    }
}

