/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.List;
import java.util.stream.Collectors;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.style.FeatureTypeStyle;

class SimplifyingStyleVisitor
extends DuplicatingStyleVisitor {
    SimplifyingStyleVisitor() {
        super(CommonFactoryFinder.getStyleFactory(null), CommonFactoryFinder.getFilterFactory2(null), (DuplicatingFilterVisitor)new SimplifyingFilterVisitor());
    }

    SimplifyingStyleVisitor(FeatureType schema) {
        super(CommonFactoryFinder.getStyleFactory(null), CommonFactoryFinder.getFilterFactory2(null), (DuplicatingFilterVisitor)SimplifyingStyleVisitor.getFilterSimplifier(schema));
    }

    private static SimplifyingFilterVisitor getFilterSimplifier(FeatureType schema) {
        SimplifyingFilterVisitor filterSimplifier = new SimplifyingFilterVisitor();
        filterSimplifier.setFeatureType(schema);
        return filterSimplifier;
    }

    public void visit(org.geotools.styling.FeatureTypeStyle fts) {
        FeatureTypeStyleImpl copy = new FeatureTypeStyleImpl((FeatureTypeStyle)fts);
        List rulesCopy = fts.rules().stream().filter(r -> r != null).map(r -> {
            r.accept((StyleVisitor)this);
            return !this.pages.isEmpty() ? (Rule)this.pages.pop() : null;
        }).filter(r -> r != null).collect(Collectors.toList());
        copy.rules().clear();
        copy.rules().addAll(rulesCopy);
        if (fts.getTransformation() != null) {
            copy.setTransformation(fts.getTransformation());
        }
        if (fts.getOnlineResource() != null) {
            copy.setOnlineResource(fts.getOnlineResource());
        }
        copy.getOptions().clear();
        copy.getOptions().putAll(fts.getOptions());
        if (this.STRICT && !copy.equals(fts)) {
            throw new IllegalStateException("Was unable to duplicate provided FeatureTypeStyle:" + String.valueOf(fts));
        }
        this.pages.push(copy);
    }
}

