/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class OpacityFinder
extends AbstractStyleVisitor
implements StyleVisitor {
    private Class<?>[] acceptableTypes;
    public boolean hasOpacity;

    public OpacityFinder(Class<?>[] acceptableTypes) {
        this.acceptableTypes = acceptableTypes;
    }

    public void visit(Style style) {
        for (FeatureTypeStyle featureTypeStyle : style.featureTypeStyles()) {
            if (this.hasOpacity) break;
            featureTypeStyle.accept((StyleVisitor)this);
        }
    }

    public void visit(Rule rule) {
        for (Symbolizer symbolizer : rule.symbolizers()) {
            if (this.hasOpacity) break;
            symbolizer.accept((StyleVisitor)this);
        }
    }

    public void visit(FeatureTypeStyle fts) {
        for (Rule rule : fts.rules()) {
            if (this.hasOpacity) break;
            rule.accept((StyleVisitor)this);
        }
    }

    public void visit(Fill fill) {
        this.checkOpacity(fill.getOpacity());
    }

    private void checkOpacity(Expression exp) {
        if (exp != null && exp instanceof Literal) {
            float opacity;
            Literal literal = (Literal)exp;
            Object obj = literal.getValue();
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Float) {
                Float i = (Float)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Double) {
                Double i = (Double)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Short) {
                Short i = (Short)obj;
                opacity = i.floatValue();
            } else if (obj instanceof Byte) {
                Byte i = (Byte)obj;
                opacity = i.floatValue();
            } else if (obj instanceof String) {
                try {
                    Double value = Double.valueOf((String)obj);
                    opacity = value.floatValue();
                }
                catch (NumberFormatException e) {
                    return;
                }
            } else {
                return;
            }
            if ((double)opacity > 0.01 && (double)opacity < 0.99) {
                this.hasOpacity = true;
            }
        }
    }

    public void visit(Stroke stroke) {
        this.checkOpacity(stroke.getOpacity());
    }

    public void visit(Symbolizer sym) {
        PointSymbolizer ps;
        if (sym instanceof PointSymbolizer) {
            ps = (PointSymbolizer)sym;
            ps.accept((StyleVisitor)this);
        }
        if (sym instanceof LineSymbolizer) {
            ps = (LineSymbolizer)sym;
            ps.accept((StyleVisitor)this);
        }
        if (sym instanceof PolygonSymbolizer) {
            ps = (PolygonSymbolizer)sym;
            ps.accept((StyleVisitor)this);
        }
        if (sym instanceof RasterSymbolizer) {
            RasterSymbolizer rs = (RasterSymbolizer)sym;
            rs.accept((StyleVisitor)this);
        }
    }

    public void visit(PointSymbolizer ps) {
        if (this.isAcceptable((Symbolizer)ps)) {
            ps.getGraphic().accept((StyleVisitor)this);
        }
    }

    private boolean isAcceptable(Symbolizer s) {
        for (Class<?> type : this.acceptableTypes) {
            if (!type.isAssignableFrom(s.getClass())) continue;
            return true;
        }
        return false;
    }

    public void visit(LineSymbolizer line) {
        if (this.isAcceptable((Symbolizer)line) && line.getStroke() != null) {
            line.getStroke().accept((StyleVisitor)this);
        }
    }

    public void visit(PolygonSymbolizer poly) {
        if (this.isAcceptable((Symbolizer)poly)) {
            if (poly.getStroke() != null) {
                poly.getStroke().accept((StyleVisitor)this);
            }
            if (poly.getFill() != null) {
                poly.getFill().accept((StyleVisitor)this);
            }
        }
    }

    public void visit(TextSymbolizer text) {
    }

    public void visit(RasterSymbolizer raster) {
        if (this.isAcceptable((Symbolizer)raster)) {
            if (raster.getOpacity() != null) {
                this.checkOpacity(raster.getOpacity());
            }
            if (raster.getColorMap() != null) {
                raster.getColorMap().accept((StyleVisitor)this);
            }
        }
    }

    public void visit(Graphic gr) {
    }

    public void visit(Mark mark) {
    }

    public void visit(ExternalGraphic exgr) {
    }

    public void visit(PointPlacement pp) {
    }

    public void visit(AnchorPoint ap) {
    }

    public void visit(Displacement dis) {
    }

    public void visit(LinePlacement lp) {
    }

    public void visit(Halo halo) {
    }

    public static void main(String[] args) {
    }

    public void visit(StyledLayerDescriptor sld) {
    }

    public void visit(NamedLayer layer) {
    }

    public void visit(UserLayer layer) {
    }

    public void visit(FeatureTypeConstraint ftc) {
    }

    public void visit(ColorMap cm) {
        for (ColorMapEntry cme : cm.getColorMapEntries()) {
            cme.accept((StyleVisitor)this);
        }
    }

    public void visit(ColorMapEntry cme) {
        if (cme.getOpacity() != null) {
            this.checkOpacity(cme.getOpacity());
        }
    }

    public void visit(ContrastEnhancement contrastEnhancement) {
    }

    public void visit(ImageOutline outline) {
    }

    public void visit(ChannelSelection cs) {
    }

    public void visit(OverlapBehavior ob) {
    }

    public void visit(SelectedChannelType sct) {
    }

    public void visit(ShadedRelief sr) {
    }
}

