/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.GlyphProperty;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class GlyphPropertiesList {
    private List<GlyphProperty> list = new ArrayList<GlyphProperty>();
    private List<String> names = new ArrayList<String>();
    private FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);

    public void addProperty(String name, Class<?> type, Object value) {
        if (!type.isAssignableFrom(value.getClass())) {
            throw new RuntimeException("Wrong class for setting variable " + name + ".  Expected a " + String.valueOf(type) + " but received a " + String.valueOf(value.getClass()) + ".");
        }
        this.list.add(new GlyphProperty(name, type, value));
        this.names.add(name);
    }

    public String getPropertyName(int i) {
        return this.list.get(i).getName();
    }

    public int getPropertyIndex(String name) {
        return this.names.indexOf(name);
    }

    public Class getPropertyType(int i) {
        return this.list.get(i).getType();
    }

    public Class getPropertyType(String name) {
        int index = this.names.indexOf(name);
        if (index != -1) {
            return this.getPropertyType(index);
        }
        throw new RuntimeException("Tried to get the class of a non-existent property: " + name);
    }

    public boolean hasProperty(String name) {
        return this.names.contains(name);
    }

    public Object getPropertyValue(int i) {
        return this.list.get(i).getValue();
    }

    public Object getPropertyValue(String name) {
        int index = this.names.indexOf(name);
        if (index != -1) {
            return this.getPropertyValue(index);
        }
        throw new RuntimeException("Tried to get the class of a non-existent property: " + name);
    }

    private Expression stringToLiteral(String s) {
        return this.factory.literal((Object)s);
    }

    private Expression numberToLiteral(Double d) {
        return this.factory.literal(d.doubleValue());
    }

    private Expression numberToLiteral(Integer i) {
        return this.factory.literal(i.intValue());
    }

    public void setPropertyValue(String name, int value) {
        this.setPropertyValue(name, (Object)value);
    }

    public void setPropertyValue(String name, double value) {
        this.setPropertyValue(name, (Object)value);
    }

    public void setPropertyValue(String name, Object value) {
        GlyphProperty prop;
        int index = this.names.indexOf(name);
        if (index != -1) {
            prop = this.list.get(index);
            if (value instanceof String) {
                value = this.stringToLiteral((String)value);
            }
            if (value instanceof Integer) {
                value = this.numberToLiteral((Integer)value);
            }
            if (value instanceof Double) {
                value = this.numberToLiteral((Double)value);
            }
            if (!prop.getType().isAssignableFrom(value.getClass())) {
                throw new RuntimeException("Wrong class for setting variable " + name + ".  Expected a " + String.valueOf(prop.getType()) + " but received a " + String.valueOf(value.getClass()) + ".");
            }
        } else {
            throw new RuntimeException("Tried to set the value of a non-existent property: " + name);
        }
        prop.setValue(value);
    }
}

