/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.util;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.geotools.renderer.util.ExplicitBoundsShape;
import org.junit.Assert;
import org.junit.Test;

public class TestExplicitBoundsShape {
    @Test
    public void testConstructorOk() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            Assert.assertNotNull((Object)target);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testConstructor_NullShape() throws Exception {
        try {
            new ExplicitBoundsShape(null);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDelegate_AllMethods() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            EasyMock.reset((Object[])new Object[]{shape});
            EasyMock.expect((Object)shape.contains((Point2D)null)).andReturn((Object)false);
            EasyMock.expect((Object)shape.contains((Rectangle2D)null)).andReturn((Object)false);
            EasyMock.expect((Object)shape.contains(0.0, 0.0)).andReturn((Object)false);
            EasyMock.expect((Object)shape.contains(0.0, 0.0, 0.0, 0.0)).andReturn((Object)false);
            EasyMock.expect((Object)shape.getBounds()).andReturn(null);
            EasyMock.expect((Object)shape.getBounds2D()).andReturn(null);
            EasyMock.expect((Object)shape.getPathIterator(null)).andReturn(null);
            EasyMock.expect((Object)shape.getPathIterator(null, 0.0)).andReturn(null);
            EasyMock.expect((Object)shape.intersects(null)).andReturn((Object)false);
            EasyMock.expect((Object)shape.intersects(0.0, 0.0, 0.0, 0.0)).andReturn((Object)false);
            EasyMock.replay((Object[])new Object[]{shape});
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            Assert.assertFalse((boolean)target.contains((Point2D)null));
            Assert.assertFalse((boolean)target.contains((Rectangle2D)null));
            Assert.assertFalse((boolean)target.contains(0.0, 0.0));
            Assert.assertFalse((boolean)target.contains(0.0, 0.0, 0.0, 0.0));
            Assert.assertNull((Object)target.getBounds());
            Assert.assertNull((Object)target.getBounds2D());
            Assert.assertNull((Object)target.getPathIterator(null));
            Assert.assertNull((Object)target.getPathIterator(null, 0.0));
            Assert.assertFalse((boolean)target.intersects(null));
            Assert.assertFalse((boolean)target.intersects(0.0, 0.0, 0.0, 0.0));
            EasyMock.verify((Object[])new Object[]{shape});
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testSetBounds() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            EasyMock.reset((Object[])new Object[]{shape});
            Rectangle shapeBounds = new Rectangle(8, 7, 9, 3);
            EasyMock.expect((Object)shape.getBounds()).andReturn((Object)shapeBounds);
            EasyMock.expect((Object)shape.getBounds2D()).andReturn((Object)shapeBounds);
            EasyMock.replay((Object[])new Object[]{shape});
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            Assert.assertEquals((Object)shapeBounds, (Object)target.getBounds());
            Assert.assertEquals((Object)shapeBounds, (Object)target.getBounds2D());
            Rectangle bounds = new Rectangle(1, 2, 5, 6);
            target.setBounds((Rectangle2D)bounds);
            Assert.assertEquals((Object)bounds, (Object)target.getBounds());
            Assert.assertEquals((Object)bounds, (Object)target.getBounds2D());
            EasyMock.verify((Object[])new Object[]{shape});
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testEquals_Shape() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            Assert.assertEquals((Object)target, (Object)shape);
            Rectangle bounds = new Rectangle(1, 2, 5, 6);
            target.setBounds((Rectangle2D)bounds);
            Assert.assertNotEquals((Object)target, (Object)shape);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testEquals_Null() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            Assert.assertNotEquals(null, (Object)target);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testEquals_Object() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            Assert.assertNotEquals((Object)target, (Object)new Object());
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testEquals_SameObject() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            Assert.assertEquals((Object)target, (Object)target);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testEquals_OtherObject() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            Shape shape2 = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            ExplicitBoundsShape other = new ExplicitBoundsShape(shape);
            ExplicitBoundsShape another = new ExplicitBoundsShape(shape2);
            Assert.assertEquals((Object)target, (Object)other);
            Assert.assertNotEquals((Object)target, (Object)another);
            Rectangle bounds = new Rectangle(1, 1, 4, 4);
            target.setBounds((Rectangle2D)bounds);
            Assert.assertNotEquals((Object)target, (Object)other);
            another.setBounds((Rectangle2D)bounds);
            Assert.assertNotEquals((Object)target, (Object)another);
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }

    @Test
    public void testHashCode() {
        try {
            Shape shape = (Shape)EasyMock.createMock(Shape.class);
            ExplicitBoundsShape target = new ExplicitBoundsShape(shape);
            Assert.assertEquals((long)shape.hashCode(), (long)target.hashCode());
            Rectangle bounds = new Rectangle(1, 1, 4, 4);
            target.setBounds((Rectangle2D)bounds);
            Assert.assertNotEquals((long)shape.hashCode(), (long)target.hashCode());
        }
        catch (Throwable e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            Assert.fail((String)("Should not throw " + e.getClass().getSimpleName()));
        }
    }
}

