/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.windbarbs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.style.windbarbs.WindBarbsFactory;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WindBarbsFactoryTest
extends Assert {
    private static final WKTWriter WKT_WRITER = new WKTWriter(2);
    private WindBarbsFactory wbf = new WindBarbsFactory();
    private SimpleFeature feature;
    private Expression exp;
    private FilterFactory ff;

    public WindBarbsFactoryTest() {
        try {
            this.ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
            featureTypeBuilder.setName("TestType");
            featureTypeBuilder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            SimpleFeatureType featureType = featureTypeBuilder.buildFeatureType();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
            this.feature = featureBuilder.buildFeature(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testInvalidAndRare() {
        this.exp = this.ff.literal((Object)"windbarbs://default(Infinity)[kts]");
        Shape shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        this.exp = this.ff.literal((Object)"windbarbs://default(-Infinity)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        this.exp = this.ff.literal((Object)"windbarbs://default(NaN)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString(), (Object)"MULTILINESTRING ((0 -0, 0 40), (5 45, -5 35), (-5 45, 5 35))");
        this.exp = this.ff.literal((Object)"windbarbs://default(110)[kts]emisphere=N");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        this.exp = this.ff.literal((Object)"windbarbs://default(110)[kts]&emisphere=N");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
    }

    @Test
    public void otherInvalidTests() {
        this.exp = this.ff.literal((Object)"windbarbs://dummy(110)[kts]");
        Shape shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        this.exp = this.ff.literal((Object)"windbarbs://(110)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        this.exp = this.ff.literal((Object)"wrong://default(110)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        this.exp = this.ff.literal((Object)"windbarbs://default(110)");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        this.exp = this.ff.literal((Object)"windbarbs://default110[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        shp = this.wbf.getShape(null, null, (Feature)this.feature);
        WindBarbsFactoryTest.assertNull((Object)shp);
        shp = this.wbf.getShape(null, this.exp, null);
        WindBarbsFactoryTest.assertNull((Object)shp);
    }

    @Test
    public void testCustomBarbs() {
        this.exp = this.ff.literal((Object)"windbarbs://default(NaN)[kts]?vectorLength=50");
        Shape shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        String wkt = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)wkt, (Object)"MULTILINESTRING ((0 -0, 0 50), (5 55, -5 45), (-5 55, 5 45))");
        this.exp = this.ff.literal((Object)"windbarbs://default(2.999999999999)[kts]?zeroWindRadius=15");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Ellipse2D));
        WindBarbsFactoryTest.assertEquals((double)((Ellipse2D)shp).getHeight(), (double)((Ellipse2D)shp).getWidth(), (double)1.0E-6);
        WindBarbsFactoryTest.assertEquals((double)((Ellipse2D)shp).getHeight(), (double)15.0, (double)1.0E-6);
        WindBarbsFactoryTest.assertEquals((double)((Ellipse2D)shp).getWidth(), (double)15.0, (double)1.0E-6);
        this.exp = this.ff.literal((Object)"windbarbs://default(3)[kts]?vectorLength=50");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        wkt = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)wkt, (Object)"MULTILINESTRING ((0 -0, 0 50), (0 45, 10 46.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(3)[kts]?emisphere=S&vectorLength=50");
        Shape shpS = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shpS);
        WindBarbsFactoryTest.assertTrue((boolean)(shpS instanceof Path2D));
        shpS = WindBarbsFactory.SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shpS);
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shpS)).toString(), (Object)wkt);
        this.exp = this.ff.literal((Object)"windbarbs://default(5)[kts]?vectorLength=50");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        wkt = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)wkt, (Object)"MULTILINESTRING ((0 -0, 0 50), (0 45, 10 46.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(5)[kts]?hemisphere=S&vectorLength=50");
        shpS = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shpS);
        WindBarbsFactoryTest.assertTrue((boolean)(shpS instanceof Path2D));
        shpS = WindBarbsFactory.SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shpS);
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shpS)).toString(), (Object)wkt);
        this.exp = this.ff.literal((Object)"windbarbs://default(15)[kts]?vectorLength=30");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)), (Object)"MULTILINESTRING ((0 -0, 0 30), (0 30, 20 32.5), (0 25, 10 26.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(20)[kts]?longBarbLength=50");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)), (Object)"MULTILINESTRING ((0 -0, 0 40), (0 40, 50 42.5), (0 35, 50 37.5))");
        this.exp = this.ff.literal((Object)"windbarbs://default(25)[kts]?longBarbLength=50");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)), (Object)"MULTILINESTRING ((0 -0, 0 40), (0 40, 50 42.5), (0 35, 50 37.5), (0 30, 25 31.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(50)[kts]?basePennantLength=10");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)), (Object)"MULTILINESTRING ((0 -0, 0 40), (0 40, 20 35, 0 30, 0 40))");
        this.exp = this.ff.literal((Object)"windbarbs://default(100)[kts]?vectorLength=30");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        wkt = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)wkt, (Object)"MULTILINESTRING ((0 -0, 0 30), (0 30, 20 27, 0 24, 0 30), (0 24, 20 21, 0 18, 0 24))");
        this.exp = this.ff.literal((Object)"windbarbs://default(100)[kts]?hemisphere=s&vectorLength=30");
        shpS = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shpS);
        WindBarbsFactoryTest.assertTrue((boolean)(shpS instanceof Path2D));
        shpS = WindBarbsFactory.SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shpS);
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shpS)).toString(), (Object)wkt);
    }

    @Test
    public void testDefaultValid() {
        this.exp = this.ff.literal((Object)"windbarbs://default(NaN)[kts]");
        Shape shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString(), (Object)"MULTILINESTRING ((0 -0, 0 40), (5 45, -5 35), (-5 45, 5 35))");
        this.exp = this.ff.literal((Object)"windbarbs://default(1)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Ellipse2D));
        WindBarbsFactoryTest.assertEquals((double)((Ellipse2D)shp).getHeight(), (double)((Ellipse2D)shp).getWidth(), (double)1.0E-6);
        this.exp = this.ff.literal((Object)"windbarbs://default(2.999999999999)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Ellipse2D));
        WindBarbsFactoryTest.assertEquals((double)((Ellipse2D)shp).getHeight(), (double)((Ellipse2D)shp).getWidth(), (double)1.0E-6);
        this.exp = this.ff.literal((Object)"windbarbs://default(3)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        String shpString = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString(), (Object)"MULTILINESTRING ((0 -0, 0 40), (0 35, 10 36.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(3)[kts]?emisphere=S");
        Shape shpS = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shpS);
        WindBarbsFactoryTest.assertTrue((boolean)(shpS instanceof Path2D));
        shpS = WindBarbsFactory.SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shpS);
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shpS)).toString(), (Object)shpString);
        this.exp = this.ff.literal((Object)"windbarbs://default(5)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        shpString = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)shpString, (Object)"MULTILINESTRING ((0 -0, 0 40), (0 35, 10 36.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(5)[kts]?hemisphere=S");
        shpS = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shpS);
        WindBarbsFactoryTest.assertTrue((boolean)(shpS instanceof Path2D));
        shpS = WindBarbsFactory.SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shpS);
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shpS)).toString(), (Object)shpString);
        this.exp = this.ff.literal((Object)"windbarbs://default(15)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString(), (Object)"MULTILINESTRING ((0 -0, 0 40), (0 40, 20 42.5), (0 35, 10 36.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(20)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString(), (Object)"MULTILINESTRING ((0 -0, 0 40), (0 40, 20 42.5), (0 35, 20 37.5))");
        this.exp = this.ff.literal((Object)"windbarbs://default(25)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString(), (Object)"MULTILINESTRING ((0 -0, 0 40), (0 40, 20 42.5), (0 35, 20 37.5), (0 30, 10 31.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(50)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString(), (Object)"MULTILINESTRING ((0 -0, 0 40), (0 40, 20 37, 0 34, 0 40))");
        this.exp = this.ff.literal((Object)"windbarbs://default(100)[kts]?vectorLength=30");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        shpString = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)shpString, (Object)"MULTILINESTRING ((0 -0, 0 30), (0 30, 20 27, 0 24, 0 30), (0 24, 20 21, 0 18, 0 24))");
        this.exp = this.ff.literal((Object)"windbarbs://default(100)[kts]?vectorLength=30&hemisphere=s");
        shpS = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shpS);
        WindBarbsFactoryTest.assertTrue((boolean)(shpS instanceof Path2D));
        shpS = WindBarbsFactory.SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shpS);
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shpS)).toString(), (Object)shpString);
        this.exp = this.ff.literal((Object)"windbarbs://default(175)[kts]");
        shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        shpString = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)shpString, (Object)"MULTILINESTRING ((0 -0, 0 40), (0 40, 20 37, 0 34, 0 40), (0 34, 20 31, 0 28, 0 34), (0 28, 20 25, 0 22, 0 28), (0 17, 20 19.5), (0 12, 20 14.5), (0 7, 10 8.25))");
        this.exp = this.ff.literal((Object)"windbarbs://default(175)[kts]?hemisphere=s");
        shpS = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shpS);
        WindBarbsFactoryTest.assertTrue((boolean)(shpS instanceof Path2D));
        shpS = WindBarbsFactory.SOUTHERN_EMISPHERE_FLIP.createTransformedShape(shpS);
        WindBarbsFactoryTest.assertEquals((Object)WKT_WRITER.write(JTS.toGeometry((Shape)shpS)).toString(), (Object)shpString);
    }

    @Test
    public void testUncachedBarb() {
        this.exp = this.ff.literal((Object)"windbarbs://default(500)[kts]?vectorLength=80");
        Shape shp = this.wbf.getShape(null, this.exp, (Feature)this.feature);
        WindBarbsFactoryTest.assertNotNull((Object)shp);
        WindBarbsFactoryTest.assertTrue((boolean)(shp instanceof Path2D));
        String shpString = WKT_WRITER.write(JTS.toGeometry((Shape)shp)).toString();
        WindBarbsFactoryTest.assertEquals((Object)shpString, (Object)"MULTILINESTRING ((0 -0, 0 80), (0 80, 20 77, 0 74, 0 80), (0 74, 20 71, 0 68, 0 74), (0 68, 20 65, 0 62, 0 68), (0 62, 20 59, 0 56, 0 62), (0 56, 20 53, 0 50, 0 56), (0 50, 20 47, 0 44, 0 50), (0 44, 20 41, 0 38, 0 44), (0 38, 20 35, 0 32, 0 38), (0 32, 20 29, 0 26, 0 32), (0 26, 20 23, 0 20, 0 26))");
    }

    @Ignore
    @Test
    public void testWellKnownTextLineString() {
        WindBarbsFactory wbf = new WindBarbsFactory();
        try {
            this.exp = this.ff.literal((Object)"windbarbs://default(100)[kts]?vectorLength=30");
            Shape shp = wbf.getShape(null, this.exp, (Feature)this.feature);
            ShapePanel p = new ShapePanel();
            p.shp = shp;
            JFrame frame = new JFrame("Draw Shapes");
            frame.getContentPane().add(p);
            frame.setSize(100, 100);
            frame.setDefaultCloseOperation(3);
            frame.setVisible(true);
            System.in.read();
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
            WindBarbsFactoryTest.fail();
            return;
        }
        WindBarbsFactoryTest.assertTrue((boolean)true);
    }

    class ShapePanel
    extends JPanel {
        private Shape shp;

        ShapePanel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.black);
            g2d.setTransform(AffineTransform.getTranslateInstance(-this.shp.getBounds().getMinX(), -this.shp.getBounds().getMinY()));
            g2d.draw(this.shp);
            g2d.dispose();
        }
    }
}

