/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.markwkt;

import java.io.File;
import java.net.URL;
import org.geotools.TestData;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.style.markwkt.WKTMarkFactory;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WKTMarkFactoryTest {
    private static final SimpleFeature feature;
    private static final FilterFactory ff;
    private static final URL rootDir;

    @Test
    public void testWellKnownTextLineString() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        try {
            Literal exp = ff.literal((Object)"wkt://LINESTRING(0.0 0.25, 0.25 0.25, 0.5 0.75, 0.75 0.25, 1.00 0.25)");
            wmf.getShape(null, (Expression)exp, (Feature)feature);
        }
        catch (Exception e) {
            Assert.fail();
            return;
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testWellKnownTextMultiLineString() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        try {
            Literal exp = ff.literal((Object)"wkt://MULTILINESTRING((0.25 0.25, 0.5 0.75, 0.75 0.25, 0.25 0.25), (0.25 0.75, 0.5 0.25, 0.75 0.75, 0.25 0.75))");
            wmf.getShape(null, (Expression)exp, (Feature)feature);
        }
        catch (Exception e) {
            Assert.fail();
            return;
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testWellKnownTextPolygon() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        try {
            Literal exp = ff.literal((Object)"wkt://POLYGON((0.25 0.25, 0.5 0.75, 0.75 0.25, 0.25 0.25))");
            wmf.getShape(null, (Expression)exp, (Feature)feature);
        }
        catch (Exception e) {
            Assert.fail();
            return;
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testWellKnownTextCurve() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        try {
            Literal exp = ff.literal((Object)"wkt://CURVEPOLYGON(COMPOUNDCURVE(CIRCULARSTRING(0 0,2 0, 2 1, 2 3, 4 3),(4 3, 4 5, 1 4, 0 0)))");
            wmf.getShape(null, (Expression)exp, (Feature)feature);
        }
        catch (Exception e) {
            Assert.fail();
            return;
        }
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testWellKnownTextPolygonError() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        try {
            Literal exp = ff.literal((Object)"wkt://POLYGON((0.25 0.25, 0.5 0.75, 0.75 0.25,     ))");
            wmf.getShape(null, (Expression)exp, (Feature)feature);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
            return;
        }
        Assert.fail();
    }

    @Test
    public void testUnknownProtocol() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        try {
            Literal exp = ff.literal((Object)"xxx://POLYGON((0.25 0.25, 0.5 0.75, 0.75 0.25,))");
            if (wmf.getShape(null, (Expression)exp, (Feature)feature) == null) {
                Assert.assertTrue((boolean)true);
                return;
            }
        }
        catch (Exception e) {
            Assert.fail();
            return;
        }
        Assert.fail();
    }

    @Test
    public void testWellKnownTextFromNotExistingFile() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        WKTMarkFactory.setRoot((URL)rootDir);
        Literal exp = ff.literal((Object)"wktlib://xxx.properties#xxx");
        try {
            wmf.getShape(null, (Expression)exp, (Feature)feature);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testNotExistingWellKnownTextFromFile() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        WKTMarkFactory.setRoot((URL)rootDir);
        Literal exp = ff.literal((Object)"wktlib://wkt.properties#xxx");
        try {
            wmf.getShape(null, (Expression)exp, (Feature)feature);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testWellKnownTextFromFile() {
        WKTMarkFactory wmf = new WKTMarkFactory();
        WKTMarkFactory.setRoot((URL)rootDir);
        Literal exp = ff.literal((Object)"wktlib://wkt.properties#ls");
        try {
            wmf.getShape(null, (Expression)exp, (Feature)feature);
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCacheSingleLibrary() {
        WKTMarkFactoryPublic wmfp = new WKTMarkFactoryPublic();
        WKTMarkFactoryPublic.setRoot((URL)rootDir);
        try {
            Literal exp = ff.literal((Object)"wkt.properties");
            wmfp.addToCachePublic((String)exp.evaluate((Object)feature, String.class));
            Assert.assertEquals((Object)wmfp.getFromCachePublic("wkt.properties", "ls"), (Object)"LINESTRING(0.0 0.25, 0.25 0.25, 0.5 0.75, 0.75 0.25, 1.00 0.25)");
            Assert.assertNull((Object)wmfp.getFromCachePublic("wkt.properties", "xx"));
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testCacheMultipleLibraries() {
        WKTMarkFactoryPublic wmfp = new WKTMarkFactoryPublic();
        WKTMarkFactoryPublic.setRoot((URL)rootDir);
        try {
            Literal exp = ff.literal((Object)"wkt.properties");
            wmfp.addToCachePublic((String)exp.evaluate((Object)feature, String.class));
            exp = ff.literal((Object)"wkt2.properties");
            wmfp.addToCachePublic((String)exp.evaluate((Object)feature, String.class));
            Assert.assertEquals((Object)wmfp.getFromCachePublic("wkt.properties", "ls"), (Object)"LINESTRING(0.0 0.25, 0.25 0.25, 0.5 0.75, 0.75 0.25, 1.00 0.25)");
            Assert.assertEquals((Object)wmfp.getFromCachePublic("wkt2.properties", "ls2"), (Object)"LINESTRING(0.0 0.5, 0.5 0.5, 0.75 1.0, 1.0 0.5, 1.25 0.5)");
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    static {
        try {
            ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
            featureTypeBuilder.setName("TestType");
            featureTypeBuilder.add("geom", LineString.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            SimpleFeatureType featureType = featureTypeBuilder.buildFeatureType();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
            feature = featureBuilder.buildFeature(null);
            File fl = TestData.file(WKTMarkFactoryTest.class, (String)"");
            assert (fl.isDirectory() && fl.exists());
            rootDir = fl.toURI().toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    final class WKTMarkFactoryPublic
    extends WKTMarkFactory {
        WKTMarkFactoryPublic() {
        }

        public String getFromCachePublic(String urlLib, String wktName) {
            return this.getFromCache(urlLib, wktName);
        }

        public void addToCachePublic(String urlLib) {
            this.addToCache(urlLib);
        }
    }
}

