/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.net.URL;
import javax.imageio.ImageIO;
import org.geotools.data.ows.MockURLChecker;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckers;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.GraphicLegend;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.test.TestData;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.operation.MathTransform;

public class StyledShapePainterTest {
    @After
    public void cleanupCheckers() {
        URLCheckers.reset();
    }

    @Test
    public void testGraphicLegendNullLegend() throws Exception {
        StyledShapePainter painter = new StyledShapePainter();
        BufferedImage image = new BufferedImage(100, 100, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        LinearTransform transform = ProjectiveTransform.create((AffineTransform)new AffineTransform());
        Decimator decimator = new Decimator((MathTransform)transform, new Rectangle());
        Point point = new GeometryFactory().createPoint(new Coordinate(10.0, 10.0));
        LiteShape2 pointShape = new LiteShape2((Geometry)point, (MathTransform)transform, decimator, false);
        try {
            painter.paint(g2, pointShape, (org.opengis.style.GraphicLegend)((GraphicLegend)null), 1.0, false);
            Assert.fail();
        }
        catch (NullPointerException e) {
            Assert.assertEquals((Object)"ShapePainter has been asked to paint a null legend!!", (Object)e.getMessage());
        }
    }

    @Test
    public void testGraphicLegend() throws Exception {
        URL imageURL = TestData.getResource((Object)this, (String)"icon64.png");
        BufferedImage testImage = ImageIO.read(imageURL);
        int width = testImage.getWidth();
        int height = testImage.getHeight();
        Style style = RendererBaseTest.loadStyle(this, "testGraphicLegend.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        GraphicLegend legend = (GraphicLegend)rule.getLegend();
        Point point = new GeometryFactory().createPoint(new Coordinate((double)(width / 2), (double)(height / 2)));
        LiteShape2 shape = new LiteShape2((Geometry)point, null, null, false);
        int imageType = testImage.getType();
        if (imageType == 0) {
            imageType = 1;
        }
        BufferedImage paintedImage = new BufferedImage(width, height, imageType);
        Graphics2D graphics = paintedImage.createGraphics();
        StyledShapePainter painter = new StyledShapePainter();
        painter.paint(graphics, shape, (org.opengis.style.GraphicLegend)legend, 1.0, false);
        graphics.dispose();
        Assert.assertTrue((boolean)StyledShapePainterTest.imagesIdentical(paintedImage, testImage));
    }

    @Test
    public void testGraphicLegendURLCheckerAllowed() throws Exception {
        URLCheckers.register((URLChecker)new MockURLChecker(u -> u.contains("icon64.png")));
        this.testGraphicLegend();
    }

    @Test
    public void testGraphicLegendURLCheckerDisallowed() throws Exception {
        URLCheckers.register((URLChecker)new MockURLChecker(u -> false));
        Style style = RendererBaseTest.loadStyle(this, "testGraphicLegend.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        GraphicLegend legend = (GraphicLegend)rule.getLegend();
        new StyledShapePainter().paint(null, null, (org.opengis.style.GraphicLegend)legend, 1.0, false);
    }

    @Test
    public void testGraphicLegendNegativeScale() throws Exception {
        URL imageURL = TestData.getResource((Object)this, (String)"icon64.png");
        BufferedImage testImage = ImageIO.read(imageURL);
        int width = testImage.getWidth();
        int height = testImage.getHeight();
        Style style = RendererBaseTest.loadStyle(this, "testGraphicLegend.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        GraphicLegend legend = (GraphicLegend)rule.getLegend();
        Point point = new GeometryFactory().createPoint(new Coordinate((double)(width / 2), (double)(height / 2)));
        LiteShape2 shape = new LiteShape2((Geometry)point, null, null, false);
        int imageType = testImage.getType();
        if (imageType == 0) {
            imageType = 1;
        }
        BufferedImage paintedImage = new BufferedImage(width, height, imageType);
        Graphics2D graphics = paintedImage.createGraphics();
        StyledShapePainter painter = new StyledShapePainter();
        painter.paint(graphics, shape, (org.opengis.style.GraphicLegend)legend, -1.0, false);
        graphics.dispose();
        Assert.assertTrue((boolean)StyledShapePainterTest.imagesIdentical(paintedImage, testImage));
    }

    @Test
    public void testGraphicLegendRotation() throws Exception {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
        URL imageURL = TestData.getResource((Object)this, (String)"icon64.png");
        BufferedImage testImage = ImageIO.read(imageURL);
        int width = testImage.getWidth();
        int height = testImage.getHeight();
        Style style = RendererBaseTest.loadStyle(this, "testGraphicLegend.sld");
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        GraphicLegend legend = (GraphicLegend)rule.getLegend();
        legend.setRotation((Expression)ff.literal(45.0));
        Point point = gf.createPoint(new Coordinate((double)(width / 2), (double)(height / 2)));
        LiteShape2 shape = new LiteShape2((Geometry)point, null, null, false);
        int imageType = testImage.getType();
        if (imageType == 0) {
            imageType = 1;
        }
        BufferedImage paintedImage = new BufferedImage(width, height, imageType);
        Graphics2D graphics = paintedImage.createGraphics();
        StyledShapePainter painter = new StyledShapePainter();
        painter.paint(graphics, shape, (org.opengis.style.GraphicLegend)legend, 1.0, false);
        graphics.dispose();
        Assert.assertFalse((boolean)StyledShapePainterTest.imagesIdentical(paintedImage, testImage));
    }

    private static boolean imagesIdentical(BufferedImage image1, BufferedImage image2) {
        WritableRaster raster1 = image1.getRaster();
        WritableRaster raster2 = image2.getRaster();
        int numBands = raster1.getNumBands();
        if (raster2.getNumBands() != numBands) {
            return false;
        }
        int width = raster1.getWidth();
        if (raster2.getWidth() != width) {
            return false;
        }
        int height = raster1.getHeight();
        if (raster2.getHeight() != height) {
            return false;
        }
        int[] pixel1 = new int[numBands];
        int[] pixel2 = new int[numBands];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                raster1.getPixel(x, y, pixel1);
                raster2.getPixel(x, y, pixel2);
                for (int i = 0; i < numBands; ++i) {
                    if (pixel1[i] == pixel2[i]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Test
    public void testGraphicLegend2() throws Exception {
        StyledShapePainter painter = new StyledShapePainter();
        GraphicImpl legend = new GraphicImpl(CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints()));
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        legend.setRotation((Expression)ff.literal(0));
        legend.setOpacity((Expression)ff.literal(1));
        URL url = StreamingRenderer.class.getResource("test-data/");
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        ExternalGraphic eg = sf.createExternalGraphic(String.valueOf(url) + "icon64.png", "image/png");
        legend.graphicalSymbols().add(eg);
        BufferedImage image = new BufferedImage(100, 100, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        LinearTransform transform = ProjectiveTransform.create((AffineTransform)new AffineTransform());
        Decimator decimator = new Decimator((MathTransform)transform, new Rectangle());
        Point point = new GeometryFactory().createPoint(new Coordinate(10.0, 10.0));
        LiteShape2 pointShape = new LiteShape2((Geometry)point, (MathTransform)transform, decimator, false);
        painter.paint(g2, pointShape, (org.opengis.style.GraphicLegend)legend, 1.0, false);
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(0, 0, 0));
        Assert.assertEquals((long)64L, (long)image.getRaster().getSample(0, 0, 1));
        Assert.assertEquals((long)128L, (long)image.getRaster().getSample(0, 0, 2));
        Assert.assertEquals((long)255L, (long)image.getRaster().getSample(30, 30, 0));
        Assert.assertEquals((long)255L, (long)image.getRaster().getSample(30, 30, 1));
        Assert.assertEquals((long)255L, (long)image.getRaster().getSample(30, 30, 2));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(90, 30, 0));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(90, 30, 1));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(90, 30, 2));
        image = new BufferedImage(100, 100, 2);
        g2 = (Graphics2D)image.getGraphics();
        painter.paint(g2, pointShape, (org.opengis.style.GraphicLegend)legend, 2.0, false);
        Assert.assertEquals((long)255L, (long)image.getRaster().getSample(0, 0, 0));
        Assert.assertEquals((long)255L, (long)image.getRaster().getSample(0, 0, 1));
        Assert.assertEquals((long)192L, (long)image.getRaster().getSample(0, 0, 2));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(30, 30, 0));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(30, 30, 1));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(30, 30, 2));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(90, 30, 0));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(90, 30, 1));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(90, 30, 2));
    }
}

