/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.referencing.CRS;
import org.opengis.filter.capability.FunctionName;
import org.opengis.parameter.Parameter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReprojectCollectionFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("ReprojectCollection", FunctionNameImpl.parameter((String)"crs", String.class), new Parameter[0]);

    public ReprojectCollectionFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        String targetCRS = this.getAttribute(object, 0, String.class, true);
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)targetCRS);
            return new ReprojectingFeatureCollection((SimpleFeatureCollection)object, crs);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reproject the collection");
        }
    }

    <T> T getAttribute(Object object, int expressionIdx, Class<T> targetClass, boolean mandatory) {
        try {
            Object result = this.getExpression(expressionIdx).evaluate(object, targetClass);
            if (result == null && mandatory) {
                throw new IllegalArgumentException("Could not find function argument #" + expressionIdx + ", but it's mandatory");
            }
            return (T)result;
        }
        catch (Exception e) {
            if (mandatory) {
                throw new IllegalArgumentException("Could not find function argument #" + expressionIdx + ", but it's mandatory");
            }
            return null;
        }
    }
}

