/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RenderUtilitiesTest {
    @Test
    public void testNAD83() throws Exception {
        CoordinateReferenceSystem nad83 = CRS.decode((String)"EPSG:4269", (boolean)true);
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(-121.1, -121.0, 46.7, 46.8), nad83);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)750, (int)600, (double)75.0);
        Assert.assertEquals((double)41470.0, (double)scale, (double)1.0);
    }

    @Test
    public void testWGS84() throws Exception {
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(-121.1, -121.0, 46.7, 46.8), wgs84);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)750, (int)600, (double)75.0);
        Assert.assertEquals((double)41470.0, (double)scale, (double)1.0);
    }

    @Test
    public void testWorld() throws Exception {
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), wgs84);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)500, (double)75.0);
        Assert.assertEquals((double)5.2830886E7, (double)scale, (double)1.0);
    }

    @Test
    public void testWorldTwice() throws Exception {
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(-360.0, 360.0, -180.0, 180.0), wgs84);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)500, (double)75.0);
        Assert.assertEquals((double)1.05661772E8, (double)scale, (double)1.0);
    }

    @Test
    public void testScaleProjected() throws Exception {
        CoordinateReferenceSystem utm1N = CRS.decode((String)"EPSG:32601");
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(200000.0, 200100.0, 0.0, 100.0), utm1N);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)100, (int)100, (double)2.54);
        Assert.assertEquals((double)100.0, (double)scale, (double)0.1);
    }

    @Test
    public void testScaleCartesian() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 10.0, 0.0, 10.0), (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)1000, (double)2.54);
        Assert.assertEquals((double)1.0, (double)scale, (double)1.0E-5);
    }

    @Test
    public void testScaleGeneric() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 10.0, 0.0, 10.0), (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)1000, (double)2.54);
        Assert.assertEquals((double)1.0, (double)scale, (double)1.0E-5);
    }

    @Test
    public void testScaleGenericFeet() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(1587500.0, 1587510.0, 475000.0, 475010.0), CRS.decode((String)"EPSG:2927", (boolean)true));
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)1000, (double)2.54);
        Assert.assertEquals((double)0.30564, (double)scale, (double)1.0E-5);
    }

    @Test
    public void testOGCScaleProjected() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 10.0, 0.0, 10.0), (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        int tenMetersPixels = (int)Math.round(35714.28571428572);
        double scale = RendererUtilities.calculateOGCScale((ReferencedEnvelope)re, (int)tenMetersPixels, new HashMap());
        Assert.assertEquals((double)1.0, (double)scale, (double)1.0E-4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOGCScaleFeet() throws Exception {
        try {
            ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 10.0, 0.0, 10.0), CRS.decode((String)"EPSG:2927", (boolean)true));
            int tenMetersPixels = (int)Math.round(35714.28571428572);
            RendererUtilities.SCALE_UNIT_COMPENSATION = false;
            double scale = RendererUtilities.calculateOGCScale((ReferencedEnvelope)re, (int)tenMetersPixels, new HashMap());
            Assert.assertEquals((double)1.0, (double)scale, (double)1.0E-4);
            RendererUtilities.SCALE_UNIT_COMPENSATION = true;
            scale = RendererUtilities.calculateOGCScale((ReferencedEnvelope)re, (int)tenMetersPixels, new HashMap());
            Assert.assertEquals((double)0.304803, (double)scale, (double)1.0E-4);
        }
        finally {
            RendererUtilities.SCALE_UNIT_COMPENSATION = true;
        }
    }

    @Test
    public void testOGCScaleGeographic() throws Exception {
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(0.0, 2.0, 0.0, 2.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        double scale = RendererUtilities.calculateOGCScale((ReferencedEnvelope)re, (int)600, new HashMap());
        Assert.assertEquals((double)1325232.03, (double)scale, (double)0.01);
    }

    @Test
    public void testOGCScaleAffineProjected() throws Exception {
        AffineTransform screenToWord = AffineTransform.getScaleInstance(500.0, 500.0);
        AffineTransform worldToScreen = screenToWord.createInverse();
        DefaultEngineeringCRS crs = DefaultEngineeringCRS.CARTESIAN_2D;
        double scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        Assert.assertEquals((double)1785714.285714286, (double)scale, (double)1.0E-4);
        worldToScreen.rotate(1.0);
        scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        Assert.assertEquals((double)1785714.285714286, (double)scale, (double)1.0E-4);
        worldToScreen.translate(100.0, 100.0);
        scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        Assert.assertEquals((double)1785714.285714286, (double)scale, (double)1.0E-4);
    }

    @Test
    public void testOGCScaleAffineGeographic() throws Exception {
        AffineTransform screenToWord = AffineTransform.getScaleInstance(0.5, 0.5);
        AffineTransform worldToScreen = screenToWord.createInverse();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        double scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        Assert.assertEquals((double)1.9878480498798856E8, (double)scale, (double)1.0E-4);
        worldToScreen.rotate(1.0);
        scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        Assert.assertEquals((double)1.9878480498798856E8, (double)scale, (double)1.0E-4);
        worldToScreen.translate(100.0, 100.0);
        scale = RendererUtilities.calculateOGCScaleAffine((CoordinateReferenceSystem)crs, (AffineTransform)worldToScreen, new HashMap());
        Assert.assertEquals((double)1.9878480498798856E8, (double)scale, (double)1.0E-4);
    }

    @Test
    public void testCreateMapEnvelope() throws Exception {
        double offset = 10000.0;
        Rectangle paintArea = new Rectangle(0, 0, 800, 600);
        AffineTransform worldToScreen = AffineTransform.getScaleInstance(0.5, 0.5);
        worldToScreen.translate(-10000.0, -10000.0);
        AffineTransform at = new AffineTransform(worldToScreen);
        Envelope env = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)at);
        this.assertEnvelopeEquals(new Envelope(10000.0, 11600.0, 10000.0, 11200.0), env, 0.001);
        at.translate(20000.0, 20000.0);
        env = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)at);
        this.assertEnvelopeEquals(new Envelope(-10000.0, -8400.0, -10000.0, -8800.0), env, 0.001);
        at.translate(-20000.0, -20000.0);
        at.rotate(1.5707963267948966, 10000.0, 10000.0);
        env = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)at);
        this.assertEnvelopeEquals(new Envelope(10000.0, 11200.0, 8400.0, 10000.0), env, 1.0E-4);
        at = new AffineTransform(worldToScreen);
        at.rotate(0.7853981633974483, 10000.0, 10000.0);
        env = RendererUtilities.createMapEnvelope((Rectangle)paintArea, (AffineTransform)at);
        this.assertEnvelopeEquals(new Envelope(10000.0, 10000.0 + Math.cos(0.7853981633974483) * 1600.0 + Math.sin(0.7853981633974483) * 1200.0, 10000.0 - Math.sin(0.7853981633974483) * 1600.0, 10000.0 + Math.cos(0.7853981633974483) * 1200.0), env, 1.0E-4);
    }

    private void assertEnvelopeEquals(Envelope expected, Envelope actual, double delta) {
        if (expected.equals((Object)actual)) {
            return;
        }
        boolean equals = true;
        equals &= Math.abs(expected.getMinX() - actual.getMinX()) <= delta;
        equals &= Math.abs(expected.getMaxX() - actual.getMaxX()) <= delta;
        equals &= Math.abs(expected.getMinY() - actual.getMinY()) <= delta;
        if (!(equals &= Math.abs(expected.getMaxY() - actual.getMaxY()) <= delta)) {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testCenterTile() throws Exception {
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 36.0, -18.0, 18.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)envelope, (int)512, (int)512, (double)72.0);
        double groundDistance = Math.hypot(36.0, 36.0) * 111120.0;
        double pixelDistance = Math.hypot(512.0, 512.0) * 3.5277777777777776E-4;
        double expected = groundDistance / pixelDistance;
        Assert.assertEquals((double)expected, (double)scale, (double)(expected * 0.05));
    }

    @Test
    public void testHemisphereCrossing() throws Exception {
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope re = new ReferencedEnvelope(new Envelope(-72.0, 132.0, -4.0, 70.0), wgs84);
        double scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)500, (double)75.0);
        Assert.assertTrue((scale > 1.0 ? 1 : 0) != 0);
        re = new ReferencedEnvelope(new Envelope(-72.0, 132.0, 4.0, 70.0), wgs84);
        scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)500, (double)75.0);
        Assert.assertTrue((scale > 1.0 ? 1 : 0) != 0);
        re = new ReferencedEnvelope(new Envelope(-72.0, 132.0, -4.0, -70.0), wgs84);
        scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)500, (double)75.0);
        Assert.assertTrue((scale > 1.0 ? 1 : 0) != 0);
        re = new ReferencedEnvelope(new Envelope(-72.0, -132.0, -90.0, 90.0), wgs84);
        scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)500, (double)75.0);
        Assert.assertTrue((scale > 1.0 ? 1 : 0) != 0);
        re = new ReferencedEnvelope(new Envelope(72.0, 132.0, -90.0, 90.0), wgs84);
        scale = RendererUtilities.calculateScale((ReferencedEnvelope)re, (int)1000, (int)500, (double)75.0);
        Assert.assertTrue((scale > 1.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSampleForCentralPoint() throws Exception {
        Polygon g = (Polygon)new WKTReader().read("POLYGON ((-112.534433451864 43.8706532611928,-112.499157652296 44.7878240499628,-99.6587666095152 44.7878240499628,-99.7242788087131 43.2155312692142,-111.085391877449 43.099601544023,-110.744593363875 36.1862602686501,-98.6760836215473 35.9436771582516,-98.7415958207452 33.5197257879307,-111.77852346112 33.9783111823157,-111.758573671673 34.6566040234952,-113.088767445077 34.7644575726901,-113.023255245879 43.8706532611928,-112.534433451864 43.8706532611928))");
        Point p = g.getCentroid();
        Assert.assertFalse((boolean)g.contains((Geometry)p));
        Assert.assertNull((Object)RendererUtilities.sampleForInternalPoint((Polygon)g, (Point)p, null, null, (double)-1.0, (int)2));
        Assert.assertNotNull((Object)RendererUtilities.sampleForInternalPoint((Polygon)g, (Point)p, null, null, (double)-1.0, (int)10));
    }

    @Test
    public void testFindCentralPoint() throws Exception {
        Polygon g = (Polygon)new WKTReader().read("POLYGON ((0 0, 0 10, 10 0, 10 10, 0 0))");
        Assert.assertNotNull((Object)RendererUtilities.getPolygonCentroid((Polygon)g));
    }
}

