/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.GridCoverageLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MultiLayerTest {
    @Test
    public void testRasterOpacity() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"buildings.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        ContentFeatureSource fs = ds.getFeatureSource("buildings");
        ReferencedEnvelope bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        StyleBuilder sb = new StyleBuilder();
        Style pst = sb.createStyle((Symbolizer)sb.createPolygonSymbolizer(null, sb.createFill(Color.GRAY, 0.5)));
        BufferedImage bi = new BufferedImage(300, 300, 6);
        Graphics g = bi.getGraphics();
        g.setColor(Color.RED);
        g.fillRect(0, 0, 300, 300);
        g.dispose();
        GridCoverage2D coverage = new GridCoverageFactory().create((CharSequence)"test_red", (RenderedImage)bi, (Envelope)bounds);
        Style rst = sb.createStyle((Symbolizer)sb.createRasterSymbolizer());
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, pst));
        mc.addLayer((Layer)new GridCoverageLayer(coverage, rst));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage img = RendererBaseTest.renderImage((GTRenderer)renderer, bounds, null);
        int[] pixel = new int[4];
        img.getData().getPixel(100, 100, pixel);
        Assert.assertEquals((long)255L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        Assert.assertEquals((long)255L, (long)pixel[3]);
    }
}

