/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collections;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MarkTest {
    private static final long TIME = 3000L;
    SimpleFeatureSource pointFS;
    SimpleFeatureSource lineFS;
    ReferencedEnvelope bounds;
    SimpleFeatureSource pointRotationFS;
    ContentFeatureSource arrowBasesFS;
    ReferencedEnvelope arrowBounds;

    @BeforeClass
    public static void setupClass() {
        System.clearProperty("org.geotools.referencing.forceXY");
        CRS.reset((String)"all");
    }

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"point.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.pointFS = ds.getFeatureSource("point");
        this.lineFS = ds.getFeatureSource("line");
        this.pointRotationFS = ds.getFeatureSource("pointRotation");
        this.arrowBasesFS = ds.getFeatureSource("arrowBases");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, CRS.decode((String)"EPSG:4326"));
        this.arrowBounds = new ReferencedEnvelope(-1.0, 5.0, -1.0, 11.0, CRS.decode((String)"EPSG:4326"));
        Font f = Font.createFont(0, TestData.getResource((Object)this, (String)"recreate.ttf").openStream());
        FontCache.getDefaultInstance().registerFont(f);
    }

    File file(String name) {
        return new File("src/test/resources/org/geotools/renderer/lite/test-data/mark/" + name + ".png");
    }

    @Test
    public void testCircle() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "markCircle.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Decorative marks", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("circle"), (RenderedImage)image, (int)150);
    }

    @Test
    public void testAnchor() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "markAnchor.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Decorative marks", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("markAnchor"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testRotatePenIcon() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "rotatePenIcon.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointRotationFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Rotate north arrow", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("rotatePenIcon"), (RenderedImage)image, (int)100);
    }

    @Test
    public void testArrowThickness() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "arrowThickness.sld");
        Style dotStyle = RendererBaseTest.loadStyle(this, "dot.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.arrowBasesFS, pStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.arrowBasesFS, dotStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, this.arrowBounds, null, 600, 100);
        ImageAssert.assertEquals((File)this.file("arrowThickness"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testArrowHeight() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "arrowHeight.sld");
        Style dotStyle = RendererBaseTest.loadStyle(this, "dot.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.arrowBasesFS, pStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.arrowBasesFS, dotStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, this.arrowBounds, null, 600, 100);
        ImageAssert.assertEquals((File)this.file("arrowHeight"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testArrowHeightRotation() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "arrowHeightRotation.sld");
        Style dotStyle = RendererBaseTest.loadStyle(this, "dot.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.arrowBasesFS, pStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.arrowBasesFS, dotStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, this.arrowBounds, null, 600, 100);
        ImageAssert.assertEquals((File)this.file("arrowHeightRotation"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testArrowBase() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "arrowBase.sld");
        Style dotStyle = RendererBaseTest.loadStyle(this, "dot.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.arrowBasesFS, pStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.arrowBasesFS, dotStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, this.arrowBounds, null, 600, 100);
        ImageAssert.assertEquals((File)this.file("arrowBase"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testRotateNorthArrow() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "rotateArrow.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointRotationFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Rotate north arrow", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("rotateArrow"), (RenderedImage)image, (int)240);
    }

    @Test
    public void testRenderingBufferCircle() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "markCircle.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setRendererHints(Collections.singletonMap("advancedProjectionHandling", true));
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.bounds = new ReferencedEnvelope(-10.0, -0.1, -10.0, -0.1, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BufferedImage image = RendererBaseTest.showRender("Decorative marks in the corner", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("bufferCircle"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testRenderingBufferCircleLarge() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "markCircleLarge.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setRendererHints(Collections.singletonMap("advancedProjectionHandling", true));
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setRendererHints(Collections.singletonMap("renderingBuffer", 64));
        ReferencedEnvelope bounds = new ReferencedEnvelope(-10.0, -0.5, -10.0, -0.5, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        BufferedImage image = RendererBaseTest.showRender("Decorative marks in the corner", (GTRenderer)renderer, 3000L, bounds);
        ImageAssert.assertEquals((File)this.file("bufferCircleLarge"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testTriangle() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "markTriangle.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Decorative marks", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("triangle"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testDecorative() throws Exception {
        Style pStyle = RendererBaseTest.loadStyle(this, "markDecorative.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Decorative marks", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("decorative"), (RenderedImage)image, (int)50);
    }

    @Test
    public void testExternalMark() throws Exception {
        Style pStyle = RendererBaseTest.loadSEStyle(this, "externalMark.sld");
        Style lStyle = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.lineFS, lStyle));
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, pStyle));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("External mark reference", (GTRenderer)renderer, 3000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("externalMark"), (RenderedImage)image, (int)50);
    }
}

