/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LabelFontShrinkSizeMinTest {
    private static final long TIME = 5000L;
    SimpleFeatureSource fs;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        RendererBaseTest.setupVeraFonts();
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, null);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.add("geom", Polygon.class);
        builder.add("label", String.class);
        builder.setName("labelFontShrinkSizeMin");
        SimpleFeatureType type = builder.buildFeatureType();
        GeometryFactory gf = new GeometryFactory();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPolygon(new Coordinate[]{new Coordinate(4.0, 7.0), new Coordinate(4.0, 9.0), new Coordinate(7.0, 9.0), new Coordinate(7.0, 7.0), new Coordinate(4.0, 7.0)}), "labelPoly A"}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{gf.createPolygon(new Coordinate[]{new Coordinate(2.5, 7.0), new Coordinate(2.5, 8.0), new Coordinate(4.0, 8.0), new Coordinate(4.0, 7.0), new Coordinate(2.5, 7.0)}), "labelPoly B"}, null);
        MemoryDataStore data = new MemoryDataStore();
        data.addFeature(f2);
        data.addFeature(f1);
        this.fs = data.getFeatureSource("labelFontShrinkSizeMin");
    }

    @Test
    public void testFonstShrinkSize() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fontShrinkSize/fontShrinkSizeMin.sld");
        BufferedImage image = this.renderLabels(this.fs, style, "Label fontShrink");
        String refPath = "./src/test/resources/org/geotools/renderer/lite/test-data/fontShrinkSize/fontShrinkSizeMin.png";
        ImageAssert.assertEquals((File)new File(refPath), (RenderedImage)image, (int)800);
    }

    private BufferedImage renderLabels(SimpleFeatureSource fs, Style style, String title) throws Exception {
        MapContent mc = new MapContent();
        mc.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setMapContent(mc);
        return RendererBaseTest.showRender(title, (GTRenderer)renderer, 5000L, this.bounds);
    }
}

