/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;

public class FillMarginTest {
    private static final long TIME = 2000L;
    SimpleFeatureSource fs;
    SimpleFeatureSource bfs;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("square");
        this.bfs = ds.getFeatureSource("bigsquare");
        this.bounds = this.fs.getBounds();
        this.bounds.expandBy(0.2, 0.2);
        Font f = Font.createFont(0, TestData.getResource((Object)this, (String)"recreate.ttf").openStream());
        FontCache.getDefaultInstance().registerFont(f);
    }

    @Test
    public void testFillSE11() throws Exception {
        Style style = RendererBaseTest.loadSEStyle(this, "margin/fill.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.bfs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("MarginFill", (GTRenderer)renderer, 2000L, this.bounds);
        ImageAssert.assertEquals((File)new File("./src/test/resources/org/geotools/renderer/lite/test-data/margin/expected.png"), (RenderedImage)image, (int)100);
    }

    @Test
    public void testFillSLD10() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "margin/fill10.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.bfs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("MarginFill", (GTRenderer)renderer, 2000L, this.bounds);
        ImageAssert.assertEquals((File)new File("./src/test/resources/org/geotools/renderer/lite/test-data/margin/expected.png"), (RenderedImage)image, (int)100);
    }

    @Test
    public void testFillSLD10HighDPI() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "margin/fill10.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.bfs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        Map<String, Integer> hints = Collections.singletonMap("dpi", 300);
        renderer.setRendererHints(hints);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)renderer, this.bounds, null, 480, 480);
        ImageAssert.assertEquals((File)new File("./src/test/resources/org/geotools/renderer/lite/test-data/margin/expected-dpi300.png"), (RenderedImage)image, (int)100);
    }

    @Test
    public void testMarkMargin() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "margin/mark-margin.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.bfs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("MarkMargin", (GTRenderer)renderer, 2000L, this.bounds);
        ImageAssert.assertEquals((File)new File("./src/test/resources/org/geotools/renderer/lite/test-data/margin/markmargin.png"), (RenderedImage)image, (int)100);
    }

    @Test
    public void testFillSingle() throws Exception {
        Style style = RendererBaseTest.loadSEStyle(this, "margin/fill-single.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.bfs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.showRender("MarginFill", (GTRenderer)renderer, 2000L, this.bounds);
        ImageAssert.assertEquals((File)new File("./src/test/resources/org/geotools/renderer/lite/test-data/margin/single-expected.png"), (RenderedImage)image, (int)100);
    }
}

