/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.Collections;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.FastBBOX;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FastBBOXTest {
    MockDataObject circle;
    FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2();

    @Before
    public void setUp() {
        GeometricShapeFactory shapeFactory = new GeometricShapeFactory();
        shapeFactory.setEnvelope(new Envelope(-1.0, 1.0, -1.0, 1.0));
        this.circle = new MockDataObject((Geometry)shapeFactory.createCircle());
    }

    @Test
    public void evaluate_envelopeOverlapsBBOX() throws Exception {
        FastBBOX fastBBOX = new FastBBOX(this.filterFactory.property("geometry"), new Envelope(0.8, 2.0, 0.8, 2.0), (FilterFactory)this.filterFactory);
        Assert.assertTrue((boolean)fastBBOX.evaluate((Object)this.circle));
    }

    @Test
    public void evaluate_envelopeIntersectsGeometry() throws Exception {
        FastBBOX fastBBOX = new FastBBOX(this.filterFactory.property("geometry"), new Envelope(0.5, 2.0, 0.5, 2.0), (FilterFactory)this.filterFactory);
        Assert.assertTrue((boolean)fastBBOX.evaluate((Object)this.circle));
    }

    @Test
    public void evaluate_envelopeDisjoint() throws Exception {
        FastBBOX fastBBOX = new FastBBOX(this.filterFactory.property("geometry"), new Envelope(1.1, 2.0, 1.1, 2.0), (FilterFactory)this.filterFactory);
        Assert.assertFalse((boolean)fastBBOX.evaluate((Object)this.circle));
    }

    @Test
    public void evaluateOnGeometryAttribute() throws FactoryException {
        Envelope env = new Envelope(0.5, 2.0, 0.5, 2.0);
        FastBBOX fastBBOX = new FastBBOX(this.filterFactory.property("geometryAttribute"), env, (FilterFactory)this.filterFactory);
        Assert.assertTrue((boolean)fastBBOX.evaluate((Object)this.circle));
    }

    public static class MockPropertyAccessorFactory
    implements PropertyAccessorFactory {
        public PropertyAccessor createPropertyAccessor(Class<?> type, String xpath, Class<?> target, Hints hints) {
            if (!MockDataObject.class.equals(type)) {
                return null;
            }
            return new PropertyAccessor(){

                public boolean canHandle(Object object, String xpath, Class<?> target) {
                    return object instanceof MockDataObject;
                }

                public <T> T get(Object object, String xpath, Class<T> target) throws IllegalArgumentException {
                    if ("geometry".equals(xpath)) {
                        Geometry result = ((MockDataObject)object).geometry;
                        return (T)result;
                    }
                    if ("geometryAttribute".equals(xpath)) {
                        GeometryAttribute result = ((MockDataObject)object).geometryAttribute;
                        return (T)result;
                    }
                    throw new IllegalArgumentException("Unknown field");
                }

                public <T> void set(Object object, String xpath, T value, Class<T> target) throws IllegalArgumentException {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class MockDataObject {
        Geometry geometry;
        GeometryAttribute geometryAttribute;

        public MockDataObject(Geometry g) {
            this.geometry = g;
            GeometryTypeImpl type = new GeometryTypeImpl((Name)new NameImpl("GEOMETRY"), Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, false, false, Collections.emptyList(), null, null);
            GeometryDescriptorImpl desc = new GeometryDescriptorImpl((GeometryType)type, (Name)new NameImpl("geometry"), 0, 1, false, null);
            this.geometryAttribute = new GeometryAttributeImpl((Object)g, (GeometryDescriptor)desc, null);
        }
    }
}

