/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;

public class CurveTest {
    private static final long TIME = 40000L;

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testCurvePolygons() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"curvepolygons.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        ContentFeatureSource fs = ds.getFeatureSource("curvepolygons");
        ReferencedEnvelope bounds = fs.getBounds();
        bounds.expandBy(1.0, 1.0);
        Style style = RendererBaseTest.loadStyle(this, "fillSolid.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
        renderer.setJava2DHints(hints);
        BufferedImage image = RendererBaseTest.showRender("Curved polygons", (GTRenderer)renderer, 40000L, bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/curvedPolygons.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)100);
    }

    @Test
    public void testCurveLines() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"curvelines.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        ContentFeatureSource fs = ds.getFeatureSource("curvelines");
        ReferencedEnvelope bounds = fs.getBounds();
        bounds.expandBy(1.0, 1.0);
        Style style = RendererBaseTest.loadStyle(this, "lineGray.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)fs, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setMapContent(mc);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
        renderer.setJava2DHints(hints);
        BufferedImage image = RendererBaseTest.showRender("Curved lines", (GTRenderer)renderer, 40000L, bounds);
        File reference = new File("./src/test/resources/org/geotools/renderer/lite/test-data/curvedLines.png");
        ImageAssert.assertEquals((File)reference, (RenderedImage)image, (int)100);
    }
}

