/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.capability.FunctionName;
import org.opengis.parameter.Parameter;

public class BufferTestFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("BufferTest", FunctionNameImpl.parameter((String)"distance", Double.class), new Parameter[0]);

    public BufferTestFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        SimpleFeatureCollection fc = (SimpleFeatureCollection)object;
        Double distance = null;
        try {
            distance = (Double)this.getExpression(0).evaluate(null, Double.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for test buffer argument #0 - expected type Double");
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        GeometryDescriptor gd = ((SimpleFeatureType)fc.getSchema()).getGeometryDescriptor();
        tb.add(gd.getName().getLocalPart(), Polygon.class, gd.getCoordinateReferenceSystem());
        tb.setName("bufferedCollection");
        SimpleFeatureType schema = tb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        ListFeatureCollection result = new ListFeatureCollection(schema);
        try (SimpleFeatureIterator fi = fc.features();){
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                fb.add((Object)((Geometry)f.getDefaultGeometry()).buffer(distance.doubleValue()));
                result.add(fb.buildFeature(null));
            }
            ListFeatureCollection listFeatureCollection = result;
            return listFeatureCollection;
        }
    }
}

