/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapLayerListListener;
import org.geotools.map.MockLayer;
import org.geotools.map.WaitingMapListener;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapContentConcurrencyTest {
    private static final ReferencedEnvelope WORLD = new ReferencedEnvelope(0.0, 100.0, 0.0, 100.0, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
    private static final long LISTENER_TIMEOUT = 500L;
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private MapContent mapContent;
    private WaitingMapListener listener;

    @Before
    public void setup() {
        this.mapContent = new MapContent();
        this.listener = new WaitingMapListener();
        this.mapContent.addMapLayerListListener((MapLayerListListener)this.listener);
    }

    @Test
    public void addingLayersOnSeparateThreads() throws Exception {
        CountDownLatch startLatch = new CountDownLatch(1);
        MockLayer layer1 = new MockLayer(WORLD);
        MockLayer layer2 = new MockLayer(WORLD);
        executor.submit(new AddLayerTask(layer1, startLatch));
        executor.submit(new AddLayerTask(layer1, startLatch));
        executor.submit(new AddLayerTask(layer2, startLatch));
        executor.submit(new AddLayerTask(layer2, startLatch));
        this.listener.setExpected(WaitingMapListener.Type.ADDED, 2);
        startLatch.countDown();
        this.listener.await(WaitingMapListener.Type.ADDED, 500L);
        Assert.assertEquals((long)2L, (long)this.mapContent.layers().size());
    }

    @Test
    public void addAndRemoveOnSeparateThreads() throws Exception {
        int k;
        CountDownLatch startLatch = new CountDownLatch(1);
        int numThreads = 100;
        MockLayer layer1 = new MockLayer(WORLD);
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(100);
        for (k = 0; k < 50; ++k) {
            tasks.add(new AddLayerTask(layer1, startLatch){

                @Override
                public void postRun() {
                    Assert.assertEquals((long)1L, (long)MapContentConcurrencyTest.this.mapContent.layers().size());
                }
            });
        }
        while (k < 100) {
            tasks.add(new RemoveLayerTask(layer1, startLatch){

                @Override
                public void postRun() {
                    Assert.assertTrue((boolean)MapContentConcurrencyTest.this.mapContent.layers().isEmpty());
                }
            });
            ++k;
        }
        Collections.shuffle(tasks);
        for (Runnable task : tasks) {
            executor.submit(task);
        }
        startLatch.countDown();
    }

    private class RemoveLayerTask
    implements Runnable {
        private final CountDownLatch startLatch;
        private final Layer layer;

        public RemoveLayerTask(Layer layer, CountDownLatch startLatch) {
            this.layer = layer;
            this.startLatch = startLatch;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.preRun();
                MapContentConcurrencyTest.this.mapContent.layers().remove(this.layer);
                this.postRun();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void preRun() {
        }

        public void postRun() {
        }
    }

    private class AddLayerTask
    implements Runnable {
        private final CountDownLatch startLatch;
        private final Layer layer;

        public AddLayerTask(Layer layer, CountDownLatch startLatch) {
            this.layer = layer;
            this.startLatch = startLatch;
        }

        @Override
        public void run() {
            try {
                this.startLatch.await();
                this.preRun();
                MapContentConcurrencyTest.this.mapContent.layers().add(this.layer);
                this.postRun();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void preRun() {
        }

        public void postRun() {
        }
    }
}

