/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import java.io.ByteArrayOutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.geotools.util.logging.Logging;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class LoggerTest {
    private static final Logger LOGGER = Logging.getLogger(LoggerTest.class);
    private static Level oldLevel;
    protected Handler logHandler;
    protected ByteArrayOutputStream logStream;

    @BeforeClass
    public static void setupOnce() {
        oldLevel = LOGGER.getLevel();
        LOGGER.setLevel(Level.FINE);
    }

    @AfterClass
    public static void cleanupOnce() {
        LOGGER.setLevel(oldLevel);
    }

    protected void grabLogger() {
        this.grabLogger(Level.ALL);
    }

    protected void grabLogger(Level level) {
        this.logStream = new ByteArrayOutputStream();
        this.logHandler = new StreamHandler(this.logStream, new SimpleFormatter());
        this.logHandler.setLevel(level);
        LOGGER.addHandler(this.logHandler);
        LOGGER.setUseParentHandlers(false);
    }

    protected void releaseLogger() {
        if (this.logHandler != null) {
            LOGGER.removeHandler(this.logHandler);
            LOGGER.setUseParentHandlers(true);
        }
    }

    public String getLogOutput() {
        this.logHandler.flush();
        return this.logStream.toString();
    }
}

