/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style.windbarbs;

import org.geotools.renderer.style.windbarbs.SpeedConverter;
import org.junit.Assert;
import org.junit.Test;
import systems.uom.common.USCustomary;

public class SpeedConverterTest
extends Assert {
    @Test
    public void test() {
        double speed = SpeedConverter.toKnots((double)1.0, (String)"m/s");
        SpeedConverterTest.assertEquals((double)1.94384449, (double)speed, (double)1.0E-6);
        speed = SpeedConverter.toKnots((double)-1.0, (String)"m/s");
        SpeedConverterTest.assertEquals((double)-1.94384449, (double)speed, (double)1.0E-6);
        speed = SpeedConverter.toKnots((double)100.0, (String)"cm/s");
        SpeedConverterTest.assertEquals((double)1.94384449, (double)speed, (double)1.0E-6);
        speed = SpeedConverter.toKnots((double)10.0, (String)"cm/s");
        SpeedConverterTest.assertEquals((double)0.194384449, (double)speed, (double)1.0E-6);
        speed = SpeedConverter.toKnots((double)10.0, (String)"kn");
        SpeedConverterTest.assertEquals((double)10.0, (double)speed, (double)1.0E-6);
        speed = SpeedConverter.toKnots((double)10.0, (String)"kts");
        SpeedConverterTest.assertEquals((double)10.0, (double)speed, (double)1.0E-6);
        speed = SpeedConverter.toKnots((double)1.0, (String)"mph");
        SpeedConverterTest.assertEquals((double)0.868976242, (double)speed, (double)1.0E-6);
        speed = SpeedConverter.toKnots((double)1.0, (String)"km/h");
        SpeedConverterTest.assertEquals((double)0.539956803, (double)speed, (double)1.0E-6);
        speed = SpeedConverter.toKnots((double)Double.NaN, (String)"km/h");
        SpeedConverterTest.assertEquals((double)Double.NaN, (double)speed, (double)1.0E-6);
        try {
            speed = SpeedConverter.toKnots((double)Double.NEGATIVE_INFINITY, (String)"km/h");
            SpeedConverterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            speed = SpeedConverter.toKnots((double)Double.POSITIVE_INFINITY, (String)"km/h");
            SpeedConverterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        speed = SpeedConverter.toKnots((double)1.0, (String)(USCustomary.FOOT.toString() + "/s"));
        SpeedConverterTest.assertEquals((double)0.592483801, (double)speed, (double)1.0E-6);
        try {
            speed = SpeedConverter.toKnots((double)1.0, (String)"a/s");
            SpeedConverterTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

