/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import it.geosolutions.jaiext.classifier.LinearColorMap;
import it.geosolutions.jaiext.classifier.LinearColorMapElement;
import java.util.HashMap;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.EnvFunction;
import org.geotools.renderer.lite.gridcoverage2d.SLDColorMapBuilder;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ColorMapEntryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class SLDColorMapBuilderTest {
    private SLDColorMapBuilder builder;
    private ColorMapEntry entry;
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
    Map<String, Object> envValues;

    @Before
    public void setUp() {
        this.builder = new SLDColorMapBuilder();
        this.builder.setNumberColorMapEntries(1);
        this.builder.setLinearColorMapType(3);
        this.entry = new ColorMapEntryImpl();
        this.entry.setColor((Expression)this.ff.literal((Object)"#000000"));
        this.entry.setQuantity((Expression)this.ff.literal(1.0));
        this.entry.setOpacity((Expression)this.ff.literal(1.0));
        this.entry.setLabel("label");
        this.envValues = new HashMap<String, Object>();
    }

    @Test
    public void testDynamicQuantity() {
        this.entry.setQuantity((Expression)this.ff.literal((Object)"${6.0+4.0}"));
        this.builder.addColorMapEntry(this.entry);
        LinearColorMap colorMap = this.builder.buildLinearColorMap();
        LinearColorMapElement[] domainElements = colorMap.getDomainElements();
        Assert.assertEquals((long)1L, (long)domainElements.length);
        Assert.assertEquals((double)10.0, (double)domainElements[0].getInputMinimum(), (double)0.0);
        Assert.assertEquals((double)10.0, (double)domainElements[0].getInputMaximum(), (double)0.0);
    }

    @Test
    public void testDynamicQuantityEnv() {
        EnvFunction.setLocalValue((String)"quantity", (Object)10.0);
        try {
            this.entry.setQuantity((Expression)this.ff.literal((Object)"${env('quantity')}"));
            this.builder.addColorMapEntry(this.entry);
            LinearColorMap colorMap = this.builder.buildLinearColorMap();
            LinearColorMapElement[] domainElements = colorMap.getDomainElements();
            Assert.assertEquals((long)1L, (long)domainElements.length);
            Assert.assertEquals((double)10.0, (double)domainElements[0].getInputMinimum(), (double)0.0);
            Assert.assertEquals((double)10.0, (double)domainElements[0].getInputMaximum(), (double)0.0);
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void testDynamicColor() {
        this.entry.setColor((Expression)this.ff.literal((Object)"${strConcat('#FF','0000')}"));
        this.builder.addColorMapEntry(this.entry);
        LinearColorMap colorMap = this.builder.buildLinearColorMap();
        LinearColorMapElement[] domainElements = colorMap.getDomainElements();
        Assert.assertEquals((long)1L, (long)domainElements.length);
        Assert.assertEquals((long)1L, (long)domainElements[0].getColors().length);
        Assert.assertEquals((long)255L, (long)domainElements[0].getColors()[0].getRed());
        Assert.assertEquals((long)0L, (long)domainElements[0].getColors()[0].getGreen());
        Assert.assertEquals((long)0L, (long)domainElements[0].getColors()[0].getBlue());
    }

    @Test
    public void testDynamicColorEnv() {
        EnvFunction.setLocalValue((String)"color", (Object)"#FF0000");
        try {
            this.entry.setColor((Expression)this.ff.literal((Object)"${env('color')}"));
            this.builder.addColorMapEntry(this.entry);
            LinearColorMap colorMap = this.builder.buildLinearColorMap();
            LinearColorMapElement[] domainElements = colorMap.getDomainElements();
            Assert.assertEquals((long)1L, (long)domainElements.length);
            Assert.assertEquals((long)1L, (long)domainElements[0].getColors().length);
            Assert.assertEquals((long)255L, (long)domainElements[0].getColors()[0].getRed());
            Assert.assertEquals((long)0L, (long)domainElements[0].getColors()[0].getGreen());
            Assert.assertEquals((long)0L, (long)domainElements[0].getColors()[0].getBlue());
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void testDynamicOpacityEnv() {
        EnvFunction.setLocalValue((String)"opacity", (Object)0.5);
        try {
            this.entry.setOpacity((Expression)this.ff.literal((Object)"${env('opacity')}"));
            this.builder.addColorMapEntry(this.entry);
            LinearColorMap colorMap = this.builder.buildLinearColorMap();
            LinearColorMapElement[] domainElements = colorMap.getDomainElements();
            Assert.assertEquals((long)1L, (long)domainElements.length);
            Assert.assertEquals((long)1L, (long)domainElements[0].getColors().length);
            Assert.assertEquals((long)128L, (long)domainElements[0].getColors()[0].getAlpha());
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }

    @Test
    public void testDynamicOpacity() {
        this.entry.setOpacity((Expression)this.ff.literal((Object)"${0.25*2}"));
        this.builder.addColorMapEntry(this.entry);
        LinearColorMap colorMap = this.builder.buildLinearColorMap();
        LinearColorMapElement[] domainElements = colorMap.getDomainElements();
        Assert.assertEquals((long)1L, (long)domainElements.length);
        Assert.assertEquals((long)1L, (long)domainElements[0].getColors().length);
        Assert.assertEquals((long)128L, (long)domainElements[0].getColors()[0].getAlpha());
    }
}

