/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.test.TestData;
import org.geotools.util.factory.Hints;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpatialFilterTest {
    private static final long TIME = 2000L;
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    SimpleFeatureSource squareFS;
    ReferencedEnvelope bounds;
    StreamingRenderer renderer;
    MapContent content;
    int errorCount = 0;
    Set<String> renderedIds = new HashSet<String>();
    RenderListener listener;
    SimpleFeatureSource pointFS;

    @BeforeClass
    public static void setupCRS() throws FactoryException {
        CRS.reset((String)"all");
        Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
        Set factories = ReferencingFactoryFinder.getCRSAuthorityFactories(null);
        for (CRSAuthorityFactory factory : factories) {
            if (!factory.getClass().getSimpleName().equals("EPSGCRSAuthorityFactory")) continue;
            ReferencingFactoryFinder.removeAuthorityFactory((AuthorityFactory)factory);
        }
        Assert.assertEquals((Object)CRS.AxisOrder.NORTH_EAST, (Object)CRS.getAxisOrder((CoordinateReferenceSystem)CRS.decode((String)"urn:ogc:def:crs:EPSG::4326")));
    }

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.squareFS = ds.getFeatureSource("square");
        this.pointFS = ds.getFeatureSource("point");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer = new StreamingRenderer();
        this.content = new MapContent();
        this.content.getViewport().setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer.setMapContent(this.content);
        this.renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                SpatialFilterTest.this.renderedIds.add(feature.getID());
            }

            public void errorOccurred(Exception e) {
                ++SpatialFilterTest.this.errorCount;
            }
        });
    }

    @AfterClass
    public static void tearDownClass() {
        Hints.removeSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
    }

    @Test
    public void testSpatialNoReprojection() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        PolygonSymbolizer ps = sb.createPolygonSymbolizer();
        Style style = sb.createStyle((Symbolizer)ps);
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        rule.setFilter((Filter)this.ff.bbox("geom", 1.0, 1.0, 4.0, 4.0, "EPSG:4326"));
        this.content.addLayer((Layer)new FeatureLayer((FeatureSource)this.squareFS, style));
        RendererBaseTest.showRender("Spatial with default CRS", (GTRenderer)this.renderer, 2000L, this.bounds);
        Assert.assertEquals((long)2L, (long)this.renderedIds.size());
    }

    @Test
    public void testSpatialDefaulter() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        PolygonSymbolizer ps = sb.createPolygonSymbolizer();
        Style style = sb.createStyle((Symbolizer)ps);
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        rule.setFilter((Filter)this.ff.bbox("geom", 1.0, 1.0, 4.0, 4.0, null));
        this.content.addLayer((Layer)new FeatureLayer((FeatureSource)this.squareFS, style));
        RendererBaseTest.showRender("Spatial without CRS", (GTRenderer)this.renderer, 2000L, this.bounds);
        Assert.assertEquals((long)2L, (long)this.renderedIds.size());
    }

    @Test
    public void testSpatialDefaulterForceEPSG() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        PointSymbolizer ps = sb.createPointSymbolizer();
        Style style = sb.createStyle((Symbolizer)ps);
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        rule.setFilter((Filter)this.ff.bbox("geom", 5.0, 1.0, 7.0, 3.0, null));
        this.renderer.setRendererHints(Collections.singletonMap("ForceEPSGAxisOrder", true));
        this.content.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, style));
        RendererBaseTest.showRender("Spatial in EPSG order", (GTRenderer)this.renderer, 2000L, this.bounds);
        Assert.assertEquals((long)1L, (long)this.renderedIds.size());
        Assert.assertEquals((Object)"point.4", (Object)this.renderedIds.iterator().next());
    }

    @Test
    public void testReprojectedBBOX() throws Exception {
        CoordinateReferenceSystem utm31n = CRS.decode((String)"EPSG:32631");
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
        ReferencedEnvelope envWgs84 = new ReferencedEnvelope(1.0, 3.0, 5.0, 7.0, wgs84);
        ReferencedEnvelope envUTM31N = envWgs84.transform(utm31n, true);
        StyleBuilder sb = new StyleBuilder();
        PointSymbolizer ps = sb.createPointSymbolizer();
        Style style = sb.createStyle((Symbolizer)ps);
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        rule.setFilter((Filter)this.ff.bbox("geom", envUTM31N.getMinX(), envUTM31N.getMinY(), envUTM31N.getMaxX(), envUTM31N.getMaxY(), "EPSG:32631"));
        this.renderer.setRendererHints(Collections.singletonMap("ForceEPSGAxisOrder", true));
        this.content.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, style));
        RendererBaseTest.showRender("Spatial in EPSG order", (GTRenderer)this.renderer, 2000L, this.bounds);
        Assert.assertEquals((long)1L, (long)this.renderedIds.size());
        Assert.assertEquals((Object)"point.4", (Object)this.renderedIds.iterator().next());
    }

    @Test
    public void testReprojectedPolygon() throws Exception {
        CoordinateReferenceSystem utm31n = CRS.decode((String)"EPSG:32631");
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
        ReferencedEnvelope envWgs84 = new ReferencedEnvelope(1.0, 3.0, 5.0, 7.0, wgs84);
        ReferencedEnvelope envUTM31N = envWgs84.transform(utm31n, true);
        StyleBuilder sb = new StyleBuilder();
        PointSymbolizer ps = sb.createPointSymbolizer();
        Style style = sb.createStyle((Symbolizer)ps);
        Rule rule = (Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0);
        Polygon polygon = JTS.toGeometry((ReferencedEnvelope)envUTM31N);
        polygon.setUserData((Object)utm31n);
        rule.setFilter((Filter)this.ff.intersects((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)polygon)));
        this.content.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, style));
        RendererBaseTest.showRender("Reprojected polygon", (GTRenderer)this.renderer, 2000L, this.bounds);
        Assert.assertEquals((long)1L, (long)this.renderedIds.size());
        Assert.assertEquals((Object)"point.4", (Object)this.renderedIds.iterator().next());
    }

    @Test
    public void testReprojectedPolygonFromSLD() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "spatialFilter.sld");
        this.content.addLayer((Layer)new FeatureLayer((FeatureSource)this.pointFS, style));
        RendererBaseTest.showRender("Reprojected polygon from SLD", (GTRenderer)this.renderer, 2000L, this.bounds);
        Assert.assertEquals((long)1L, (long)this.renderedIds.size());
        Assert.assertEquals((Object)"point.4", (Object)this.renderedIds.iterator().next());
    }

    @Test
    public void testReprojectedPolygonFromDefinitionQuery() throws Exception {
        CoordinateReferenceSystem utm31n = CRS.decode((String)"EPSG:32631");
        CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
        ReferencedEnvelope envWgs84 = new ReferencedEnvelope(1.0, 3.0, 5.0, 7.0, wgs84);
        ReferencedEnvelope envUTM31N = envWgs84.transform(utm31n, true);
        StyleBuilder sb = new StyleBuilder();
        PointSymbolizer ps = sb.createPointSymbolizer();
        Style style = sb.createStyle((Symbolizer)ps);
        FeatureLayer layer = new FeatureLayer((FeatureSource)this.pointFS, style);
        Polygon polygon = JTS.toGeometry((Envelope)envUTM31N);
        polygon.setUserData((Object)utm31n);
        layer.setQuery(new Query(null, (Filter)this.ff.intersects((Expression)this.ff.property("geom"), (Expression)this.ff.literal((Object)polygon))));
        this.content.addLayer((Layer)layer);
        RendererBaseTest.showRender("Reprojected polygon as a definition query", (GTRenderer)this.renderer, 2000L, this.bounds);
        Assert.assertEquals((long)1L, (long)this.renderedIds.size());
        Assert.assertEquals((Object)"point.4", (Object)this.renderedIds.iterator().next());
    }
}

