/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.Font;
import org.opengis.style.LabelPlacement;

public class ScreenMapShapefileTest {
    private DataStore shapeFileDataStore;
    private SimpleFeatureType featureType;
    private SimpleFeature feature;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("render-test");
        ftb.add("the_geom", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ftb.setDefaultGeometry("the_geom");
        ftb.add("name", String.class);
        this.featureType = ftb.buildFeatureType();
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(this.featureType);
        fb.set("the_geom", (Object)gf.createPoint(new Coordinate(10.0, 10.0)));
        fb.set("name", (Object)"The name");
        this.feature = fb.buildFeature(null);
        File shpFile = new File("./target/screenMapTest/" + this.feature.getFeatureType().getName().getLocalPart() + ".shp");
        shpFile.getParentFile().mkdirs();
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, URL> params = new HashMap<String, URL>();
        params.put(ShapefileDataStoreFactory.URLP.key, shpFile.toURI().toURL());
        this.shapeFileDataStore = dataStoreFactory.createNewDataStore(params);
        this.shapeFileDataStore.createSchema((FeatureType)this.feature.getFeatureType());
        SimpleFeatureStore featureStore = (SimpleFeatureStore)this.shapeFileDataStore.getFeatureSource(this.shapeFileDataStore.getTypeNames()[0]);
        featureStore.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)this.feature));
        RendererBaseTest.setupVeraFonts();
    }

    @After
    public void dispose() {
        if (this.shapeFileDataStore != null) {
            this.shapeFileDataStore.dispose();
        }
    }

    @Test
    public void testFeatureCollection() throws IOException {
        SimpleFeatureSource featureSource = DataUtilities.source((SimpleFeature[])new SimpleFeature[]{this.feature});
        ScreenMapShapefileTest.checkTiles(featureSource);
    }

    @Test
    public void testShapeFile() throws Exception {
        SimpleFeatureSource fs = this.shapeFileDataStore.getFeatureSource(this.featureType.getTypeName());
        ScreenMapShapefileTest.checkTiles(fs);
    }

    private static void checkTiles(SimpleFeatureSource featureSource) {
        Style style = ScreenMapShapefileTest.createPointStyle();
        BufferedImage untiled = ScreenMapShapefileTest.renderImage(featureSource, 100, 100, new Rectangle2D.Double(5.0, 5.0, 10.0, 10.0), style, Collections.emptyMap());
        BufferedImage tile1 = ScreenMapShapefileTest.renderImage(featureSource, 50, 100, new Rectangle2D.Double(5.0, 5.0, 5.0, 10.0), style, Collections.emptyMap());
        BufferedImage tile2 = ScreenMapShapefileTest.renderImage(featureSource, 50, 100, new Rectangle2D.Double(10.0, 5.0, 5.0, 10.0), style, Collections.emptyMap());
        ScreenMapShapefileTest.assertEqualsImage(untiled.getSubimage(0, 0, 50, 100), tile1);
        ScreenMapShapefileTest.assertEqualsImage(untiled.getSubimage(50, 0, 50, 100), tile2);
    }

    private static void assertEqualsImage(BufferedImage expected, BufferedImage actual) {
        Assert.assertEquals((long)expected.getWidth(), (long)actual.getWidth());
        Assert.assertEquals((long)expected.getHeight(), (long)actual.getHeight());
        for (int y = 0; y < expected.getHeight(); ++y) {
            for (int x = 0; x < expected.getWidth(); ++x) {
                int expectedRgb = expected.getRGB(x, y);
                int actualRgb = actual.getRGB(x, y);
                Assert.assertEquals((String)("[" + y + ", " + x + "]"), (Object)new Color(expectedRgb), (Object)new Color(actualRgb));
            }
        }
    }

    private static BufferedImage renderImage(SimpleFeatureSource featureSource, int width, int height, Rectangle2D mapArea, Style style, Map<Object, Object> renderingHints) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        MapContent mapContent = new MapContent();
        MapViewport viewport = mapContent.getViewport();
        viewport.setBounds(new ReferencedEnvelope(mapArea, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        viewport.setScreenArea(new Rectangle(width, height));
        mapContent.addLayer((Layer)new FeatureLayer((FeatureSource)featureSource, style));
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setRendererHints(renderingHints);
        renderer.setMapContent(mapContent);
        renderer.paint(g, viewport.getScreenArea(), viewport.getBounds());
        return image;
    }

    private static Style createPointStyle() {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        URL iconUrl = ScreenMapShapefileTest.class.getResource("icon.png");
        ExternalGraphic icon = sf.createExternalGraphic(iconUrl, "image/png");
        Graphic graphic = sf.createGraphic(new ExternalGraphic[]{icon}, null, null, null, null, null);
        PointSymbolizer symbolizer = sf.createPointSymbolizer(graphic, "the_geom");
        Rule rule = sf.createRule();
        rule.symbolizers().add(symbolizer);
        FeatureTypeStyle fts = sf.createFeatureTypeStyle();
        fts.rules().add(rule);
        Style style = sf.createStyle();
        style.featureTypeStyles().add(fts);
        return style;
    }

    @Test
    public void testOffsetLabel() throws IOException {
        SimpleFeatureSource fs = this.shapeFileDataStore.getFeatureSource(this.featureType.getTypeName());
        Style style = ScreenMapShapefileTest.createLabelOffsetStyle();
        HashMap<Object, Object> renderingHints = new HashMap<Object, Object>();
        BufferedImage image = ScreenMapShapefileTest.renderImage(fs, 200, 200, new Rectangle2D.Double(15.0, 0.0, 25.0, 10.0), style, renderingHints);
        Assert.assertEquals((long)0L, (long)this.countNonBlankPixels(image));
        renderingHints.put("renderingBuffer", 100);
        image = ScreenMapShapefileTest.renderImage(fs, 200, 200, new Rectangle2D.Double(15.0, 0.0, 25.0, 10.0), style, renderingHints);
        Assert.assertTrue((this.countNonBlankPixels(image) > 0 ? 1 : 0) != 0);
    }

    private static Style createLabelOffsetStyle() {
        StyleBuilder sb = new StyleBuilder();
        PointPlacement pp = sb.createPointPlacement(0.5, 0.5, 50.0, 0.0, 0.0);
        TextSymbolizer ts = sb.createTextSymbolizer();
        ts.setFont((Font)sb.createFont("Bitstream Vera Sans", 20.0));
        ts.setLabel((Expression)sb.getFilterFactory().literal((Object)"name"));
        ts.setLabelPlacement((LabelPlacement)pp);
        ts.getOptions().put("partials", "true");
        return sb.createStyle((Symbolizer)ts);
    }

    protected int countNonBlankPixels(BufferedImage image) {
        int pixelsDiffer = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (image.getRGB(x, y) == Color.WHITE.getRGB()) continue;
                ++pixelsDiffer;
            }
        }
        return pixelsDiffer;
    }
}

