/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PartialsTest {
    SimpleFeatureSource fs_point;
    SimpleFeatureSource fs_line;
    SimpleFeatureSource fs_area;
    ReferencedEnvelope bounds;
    StreamingRenderer renderer;

    @Before
    public void setUp() throws Exception {
        File property_point = new File(TestData.getResource((Object)this, (String)"partialPointLabel.properties").toURI());
        PropertyDataStore ds_point = new PropertyDataStore(property_point.getParentFile());
        this.fs_point = ds_point.getFeatureSource("partialPointLabel");
        File property_line = new File(TestData.getResource((Object)this, (String)"partialLineLabel.properties").toURI());
        PropertyDataStore ds_line = new PropertyDataStore(property_line.getParentFile());
        this.fs_line = ds_line.getFeatureSource("partialLineLabel");
        File property_area = new File(TestData.getResource((Object)this, (String)"partialAreaLabel.properties").toURI());
        PropertyDataStore ds_area = new PropertyDataStore(property_area.getParentFile());
        this.fs_area = ds_area.getFeatureSource("partialAreaLabel");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer = new StreamingRenderer();
        HashMap<String, LabelCacheImpl> rendererParams = new HashMap<String, LabelCacheImpl>();
        LabelCacheImpl labelCache = new LabelCacheImpl();
        rendererParams.put("labelCache", labelCache);
        this.renderer.setRendererHints(rendererParams);
        this.renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
    }

    @Test
    public void testPartialPointLabelNo() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialPointLabelNo.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_point, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 282, 152, Color.WHITE);
    }

    @Test
    public void testPointLabelFalse() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialPointLabelFalse.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_point, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 282, 152, Color.WHITE);
    }

    @Test
    public void testPartialPointLabelTrue() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialPointLabelTrue.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_point, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 282, 150, Color.BLACK);
    }

    @Test
    public void testPartialLineLabelNo() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialLineLabelNo.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 282, 155, Color.WHITE);
    }

    @Test
    public void testPartialLineLabelFalse() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialLineLabelFalse.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 282, 155, Color.WHITE);
    }

    @Test
    public void testPartialLineLabelTrue() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialLineLabelTrue.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_line, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 150, 1, Color.BLACK, 30);
    }

    @Test
    public void testPartialAreaLabelNo() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialAreaLabelNo.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_area, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 282, 152, Color.WHITE);
    }

    @Test
    public void testPartialAreaLabelFalse() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialAreaLabelFalse.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_area, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 282, 152, Color.WHITE);
    }

    @Test
    public void testPartialAreaLabelTrue() throws Exception {
        Thread.sleep(1000L);
        Style style = RendererBaseTest.loadStyle(this, "partialAreaLabelTrue.sld");
        MapContent mc = new MapContent();
        mc.addLayer((Layer)new FeatureLayer((FeatureSource)this.fs_area, style));
        this.renderer.setMapContent(mc);
        BufferedImage image = RendererBaseTest.renderImage((GTRenderer)this.renderer, this.bounds, null);
        RendererBaseTest.assertPixel(image, 282, 150, Color.BLACK);
    }

    public static void showImage(String testName, long timeOut, final BufferedImage image) throws InterruptedException {
        try {
            Frame frame = new Frame(testName);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    e.getWindow().dispose();
                }
            });
            Panel p = new Panel(){
                private static final long serialVersionUID = 1L;
                {
                    this.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
                }

                @Override
                public void paint(Graphics g) {
                    g.drawImage(image, 0, 0, this);
                }
            };
            frame.add(p);
            frame.pack();
            frame.setVisible(true);
            Thread.sleep(timeOut);
            frame.dispose();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }
}

